/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.gui;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.input.MouseButtonInfo;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import xaero.common.IXaeroMinimap;
import xaero.common.graphics.TextureUtils;
import xaero.common.gui.GuiWaypointsOptions;
import xaero.common.gui.MySmallButton;
import xaero.common.gui.ScreenBase;
import xaero.common.settings.ModSettings;
import xaero.hud.minimap.world.container.MinimapWorldRootContainer;
import xaero.hud.render.util.GuiRenderUtil;

public class GuiWorldTpCommand
extends ScreenBase {
    private MySmallButton confirmButton;
    private EditBox commandFormatTextField;
    private EditBox rotationCommandFormatTextField;
    private boolean usingDefault;
    private String commandFormat;
    private String rotationCommandFormat;
    private MinimapWorldRootContainer rootContainer;

    public GuiWorldTpCommand(IXaeroMinimap modMain, Screen parent, Screen escape, MinimapWorldRootContainer rootContainer) {
        super(modMain, parent, escape, (Component)Component.translatable((String)"gui.xaero_world_teleport_command"));
        this.rootContainer = rootContainer;
        this.commandFormat = rootContainer.getConfig().getServerTeleportCommandFormat() == null ? modMain.getSettings().defaultWaypointTPCommandFormat : rootContainer.getConfig().getServerTeleportCommandFormat();
        this.rotationCommandFormat = rootContainer.getConfig().getServerTeleportCommandRotationFormat() == null ? modMain.getSettings().defaultWaypointTPCommandRotationFormat : rootContainer.getConfig().getServerTeleportCommandRotationFormat();
        this.usingDefault = rootContainer.getConfig().isUsingDefaultTeleportCommand();
    }

    @Override
    public void init() {
        super.init();
        this.parent.resize(this.minecraft, this.width, this.height);
        this.commandFormatTextField = new EditBox(this, this.font, this.width / 2 - 100, this.height / 7 + 50, 200, 20, (Component)Component.translatable((String)"gui.xaero_world_teleport_command")){

            public void insertText(String textToWrite) {
                if (this.active) {
                    super.insertText(textToWrite);
                }
            }

            public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
                if (this.active) {
                    return super.mouseClicked(event, doubleClick);
                }
                return false;
            }

            public void deleteChars(int p_146175_1_) {
                if (this.active) {
                    super.deleteChars(p_146175_1_);
                }
            }

            public void deleteWords(int p_146177_1_) {
                if (this.active) {
                    super.deleteWords(p_146177_1_);
                }
            }
        };
        this.commandFormatTextField.setMaxLength(128);
        this.rotationCommandFormatTextField = new EditBox(this, this.font, this.width / 2 - 100, this.height / 7 + 98, 200, 20, (Component)Component.translatable((String)"gui.xaero_world_teleport_command_with_rotation")){

            public void insertText(String textToWrite) {
                if (this.active) {
                    super.insertText(textToWrite);
                }
            }

            public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
                if (this.active) {
                    return super.mouseClicked(event, doubleClick);
                }
                return false;
            }

            public void deleteChars(int p_146175_1_) {
                if (this.active) {
                    super.deleteChars(p_146175_1_);
                }
            }

            public void deleteWords(int p_146177_1_) {
                if (this.active) {
                    super.deleteWords(p_146177_1_);
                }
            }
        };
        this.rotationCommandFormatTextField.setMaxLength(128);
        this.commandFormatTextField.active = !this.usingDefault;
        this.rotationCommandFormatTextField.active = !this.usingDefault;
        this.commandFormatTextField.setValue(this.commandFormat);
        this.rotationCommandFormatTextField.setValue(this.rotationCommandFormat);
        this.addWidget(this.commandFormatTextField);
        this.addWidget(this.rotationCommandFormatTextField);
        this.confirmButton = new MySmallButton(200, this.width / 2 - 155, this.height / 6 + 168, (Component)Component.translatable((String)"gui.xaero_confirm", (Object[])new Object[0]), b -> {
            if (this.commandFormat.equals(this.modMain.getSettings().defaultWaypointTPCommandFormat) && this.rotationCommandFormat.equals(this.modMain.getSettings().defaultWaypointTPCommandRotationFormat)) {
                this.usingDefault = true;
                this.commandFormat = null;
                this.rotationCommandFormat = null;
            }
            this.rootContainer.getConfig().setUsingDefaultTeleportCommand(this.usingDefault);
            this.rootContainer.getConfig().setServerTeleportCommandFormat(this.commandFormat);
            this.rootContainer.getConfig().setServerTeleportCommandRotationFormat(this.rotationCommandFormat);
            this.rootContainer.getSession().getWorldManagerIO().getRootConfigIO().save(this.rootContainer);
            this.goBack();
        });
        this.addRenderableWidget((GuiEventListener)this.confirmButton);
        this.addRenderableWidget((GuiEventListener)new MySmallButton(201, this.width / 2 + 5, this.height / 6 + 168, (Component)Component.translatable((String)"gui.xaero_cancel", (Object[])new Object[0]), b -> this.goBack()));
        this.addRenderableWidget((GuiEventListener)new MySmallButton(202, this.width / 2 - 75, this.height / 7 + 8, (Component)Component.literal((String)(I18n.get((String)"gui.xaero_use_default", (Object[])new Object[0]) + ": " + ModSettings.getTranslation(this.usingDefault))), b -> {
            this.usingDefault = !this.usingDefault;
            this.commandFormatTextField.active = !this.usingDefault;
            this.rotationCommandFormatTextField.active = !this.usingDefault;
            this.init(this.minecraft, this.width, this.height);
        }));
    }

    public void renderBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        if (this.parent instanceof GuiWaypointsOptions) {
            ((GuiWaypointsOptions)this.parent).parent.renderWithTooltipAndSubtitles(guiGraphics, 0, 0, f);
            GuiRenderUtil.flushGUI();
        }
        TextureUtils.clearRenderTargetDepth(this.minecraft.getMainRenderTarget(), 1.0f);
        super.renderBackground(guiGraphics, i, j, f);
        GuiRenderUtil.flushGUI();
        super.renderBackground(guiGraphics, i, j, f);
        guiGraphics.drawCenteredString(this.font, this.title, this.width / 2, 20, -1);
        guiGraphics.drawCenteredString(this.font, "{x} {y} {z} {name}", this.width / 2, this.height / 7 + 36, -5592406);
        guiGraphics.drawCenteredString(this.font, "{x} {y} {z} {name} {yaw}", this.width / 2, this.height / 7 + 84, -5592406);
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partial) {
        super.render(guiGraphics, mouseX, mouseY, partial);
        if (this.usingDefault) {
            this.commandFormatTextField.setValue(this.modMain.getSettings().defaultWaypointTPCommandFormat);
            this.rotationCommandFormatTextField.setValue(this.modMain.getSettings().defaultWaypointTPCommandRotationFormat);
            this.commandFormatTextField.setTextColor(-11184811);
            this.rotationCommandFormatTextField.setTextColor(-11184811);
        }
        this.commandFormatTextField.render(guiGraphics, mouseX, mouseY, partial);
        this.rotationCommandFormatTextField.render(guiGraphics, mouseX, mouseY, partial);
        if (this.usingDefault) {
            this.commandFormatTextField.setValue(this.commandFormat);
            this.rotationCommandFormatTextField.setValue(this.rotationCommandFormat);
            this.commandFormatTextField.setTextColor(-1);
            this.rotationCommandFormatTextField.setTextColor(-1);
        }
    }

    public void tick() {
        this.commandFormat = this.commandFormatTextField.getValue();
        this.rotationCommandFormat = this.rotationCommandFormatTextField.getValue();
        this.confirmButton.active = this.commandFormat != null && this.commandFormat.length() > 0 && this.rotationCommandFormat != null && this.rotationCommandFormat.length() > 0 || this.usingDefault;
    }

    public boolean keyPressed(KeyEvent event) {
        if (event.key() == 257 && (this.commandFormatTextField.isFocused() || this.rotationCommandFormatTextField.isFocused()) && this.commandFormat != null && this.commandFormat.length() > 0 && this.rotationCommandFormat != null && this.rotationCommandFormat.length() > 0) {
            this.confirmButton.onClick(new MouseButtonEvent(0.0, 0.0, new MouseButtonInfo(0, 0)), false);
        }
        return super.keyPressed(event);
    }
}

