/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.pvp.module.notification;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import xaero.hud.pvp.module.notification.Notification;
import xaero.hud.pvp.module.notification.NotificationSession;
import xaero.hud.render.TextureLocations;
import xaero.hud.render.module.IModuleRenderer;
import xaero.hud.render.module.ModuleRenderContext;

public class NotificationRenderer
implements IModuleRenderer<NotificationSession> {
    @Override
    public void render(NotificationSession session, ModuleRenderContext c, GuiGraphics guiGraphics, float partialTicks) {
        boolean air;
        if (System.currentTimeMillis() - session.getLastBlink() > 500L) {
            session.setLastBlink(System.currentTimeMillis());
            session.setBlink(!session.getBlink());
        }
        Minecraft mc = Minecraft.getInstance();
        int total = 0;
        boolean lowHunger = session.getNotificationHunger() && (float)mc.player.getFoodData().getFoodLevel() <= 2.0f * (float)session.getLowHunger();
        boolean lowHealth = session.getNotificationHP() && mc.player.getHealth() <= 2.0f * (float)session.getLowHealth();
        boolean tnt = session.getNotificationTNT() && session.getWorldHelper().tntIsAround(mc.player);
        boolean arrow = session.getNotificationArrow() && session.getWorldHelper().arrowIsAround(mc.player);
        boolean bl = air = session.getNotificationAir() && mc.player.getAirSupply() <= 30 * session.getLowAir();
        if (lowHunger) {
            ++total;
        }
        if (lowHealth) {
            ++total;
        }
        if (tnt) {
            ++total;
        }
        if (arrow) {
            ++total;
        }
        if (air) {
            ++total;
        }
        if (total == 0) {
            return;
        }
        int between = 32 - 4 * total;
        int unitLength = 32 + between;
        int totalLength = total * unitLength;
        int drawY = c.y + (c.h - 32) / 2;
        int drawX = c.x + c.w / 2 - totalLength / 2 + between / 2;
        int color = -1;
        if (session.getBlink()) {
            color = -6710887;
        }
        if (lowHunger) {
            this.renderNotification(Notification.LOW_HUNGER, drawX, drawY, guiGraphics, color);
            drawX += unitLength;
        }
        if (lowHealth) {
            this.renderNotification(Notification.LOW_HEALTH, drawX, drawY, guiGraphics, color);
            drawX += unitLength;
        }
        if (tnt) {
            this.renderNotification(Notification.TNT, drawX, drawY, guiGraphics, color);
            drawX += unitLength;
        }
        if (arrow) {
            this.renderNotification(Notification.ARROW, drawX, drawY, guiGraphics, color);
            drawX += unitLength;
        }
        if (air) {
            this.renderNotification(Notification.AIR, drawX, drawY, guiGraphics, color);
            drawX += unitLength;
        }
    }

    private void renderNotification(Notification notification, int drawX, int drawY, GuiGraphics guiGraphics, int color) {
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TextureLocations.GUI_TEXTURES, drawX, drawY, 17.0f, (float)(notification.getTextureIndex() * 32), notification.getTextureW(), 32, 256, 256, color);
    }
}

