/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.gui;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;
import org.lwjgl.glfw.GLFW;
import xaero.common.IXaeroMinimap;
import xaero.common.graphics.CursorBox;
import xaero.common.graphics.TextureUtils;
import xaero.common.gui.ICanTooltip;
import xaero.common.gui.IScreenBase;
import xaero.common.gui.dropdown.DropDownWidget;
import xaero.common.misc.Misc;
import xaero.hud.render.util.GuiRenderUtil;

public class ScreenBase
extends Screen
implements IScreenBase {
    protected IXaeroMinimap modMain;
    public Screen parent;
    public Screen escape;
    protected boolean canSkipWorldRender;
    protected DropDownWidget openDropdown;
    private List<DropDownWidget> dropdowns;
    private static final CursorBox worldmapBox = new CursorBox("gui.xaero_uses_worldmap_value");

    protected ScreenBase(IXaeroMinimap modMain, Screen parent, Screen escape, Component titleIn) {
        super(titleIn);
        this.modMain = modMain;
        this.parent = parent;
        this.escape = escape;
        this.dropdowns = new ArrayList<DropDownWidget>();
    }

    protected void onExit(Screen screen) {
        this.minecraft.setScreen(screen);
    }

    protected void goBack() {
        this.onExit(this.parent);
    }

    public void onClose() {
        this.onExit(this.escape);
    }

    public void renderEscapeScreen(GuiGraphics guiGraphics, int p_230430_2_, int p_230430_3_, float p_230430_4_) {
        if (this.escape != null) {
            this.escape.renderWithTooltipAndSubtitles(guiGraphics, p_230430_2_, p_230430_3_, p_230430_4_);
            GuiRenderUtil.flushGUI();
            TextureUtils.clearRenderTargetDepth(this.minecraft.getMainRenderTarget(), 1.0f);
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partial) {
        super.render(guiGraphics, mouseX, mouseY, partial);
        this.renderPreDropdown(guiGraphics, mouseX, mouseY, partial);
        for (DropDownWidget dropdown : this.dropdowns) {
            dropdown.render(guiGraphics, mouseX, mouseY, partial);
        }
        if (this.openDropdown != null) {
            this.openDropdown.render(guiGraphics, mouseX, mouseY, this.height, false);
        }
    }

    protected void renderPreDropdown(GuiGraphics guiGraphics, int mouseX, int mouseY, float partial) {
    }

    protected void init() {
        super.init();
        this.dropdowns.clear();
        this.openDropdown = null;
        if (this.escape != null) {
            this.escape.init(this.minecraft, this.width, this.height);
        }
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean doubleClick) {
        if (this.openDropdown != null) {
            if (!this.openDropdown.onDropDown((int)event.x(), (int)event.y(), this.height)) {
                this.openDropdown.setClosed(true);
                this.openDropdown = null;
            } else {
                this.openDropdown.mouseClicked(event, doubleClick);
                return true;
            }
        }
        return super.mouseClicked(event, doubleClick);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double g, double wheel) {
        if (this.openDropdown != null) {
            if (this.openDropdown.onDropDown((int)mouseX, (int)mouseY, this.height)) {
                return this.openDropdown.mouseScrolled(mouseX, mouseY, g, wheel);
            }
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, g, wheel);
    }

    public boolean mouseReleased(MouseButtonEvent event) {
        if (this.openDropdown != null && this.openDropdown.mouseReleased(event)) {
            return true;
        }
        return super.mouseReleased(event);
    }

    @Override
    public boolean shouldSkipWorldRender() {
        return this.canSkipWorldRender && Misc.screenShouldSkipWorldRender(this.modMain, this.escape, true);
    }

    protected boolean renderTooltips(GuiGraphics guiGraphics, int par1, int par2, float par3) {
        boolean result = this.modMain.getWidgetScreenHandler().renderTooltips(guiGraphics, this, this.width, this.height, par1, par2, this.minecraft.getWindow().getGuiScale());
        boolean mousePressed = GLFW.glfwGetMouseButton((long)this.minecraft.getWindow().handle(), (int)0) == 1;
        for (GuiEventListener el : this.children()) {
            CursorBox tooltip;
            AbstractWidget b;
            if (!(el instanceof AbstractWidget) || !((b = (AbstractWidget)el) instanceof ICanTooltip) || b instanceof AbstractSliderButton && mousePressed) continue;
            ICanTooltip optionWidget = (ICanTooltip)b;
            if (par1 < b.getX() || par2 < b.getY() || par1 >= b.getX() + b.getWidth() || par2 >= b.getY() + b.getHeight() || optionWidget.getXaero_tooltip() == null || (tooltip = optionWidget.getXaero_tooltip().get()) == null) continue;
            tooltip.drawBox(guiGraphics, par1, par2, this.width, this.height);
            result = true;
            break;
        }
        return result;
    }

    @Override
    public void onDropdownOpen(DropDownWidget menu) {
        if (this.openDropdown != null && this.openDropdown != menu) {
            this.openDropdown.setClosed(true);
        }
        this.openDropdown = menu;
    }

    @Override
    public void onDropdownClosed(DropDownWidget menu) {
        if (menu != this.openDropdown && this.openDropdown != null) {
            this.openDropdown.setClosed(true);
        }
        this.openDropdown = null;
    }

    protected <T extends GuiEventListener & NarratableEntry> T addWidget(T guiEventListener) {
        if (guiEventListener instanceof DropDownWidget) {
            this.dropdowns.add((DropDownWidget)guiEventListener);
        }
        return (T)super.addWidget(guiEventListener);
    }

    private void handleDropdownReplacement(AbstractWidget current, AbstractWidget replacement) {
        int dropdownIndex = this.dropdowns.indexOf(current);
        if (dropdownIndex != -1) {
            this.dropdowns.set(dropdownIndex, (DropDownWidget)replacement);
        }
        if (this.getFocused() == current) {
            this.setFocused((GuiEventListener)replacement);
        }
    }

    private void replaceWidget(AbstractWidget current, AbstractWidget replacement, boolean renderable) {
        int childIndex = this.children().indexOf(current);
        if (childIndex != -1) {
            super.removeWidget((GuiEventListener)current);
            if (renderable) {
                super.addRenderableWidget((GuiEventListener)replacement);
            } else {
                super.addWidget((GuiEventListener)replacement);
            }
            this.children().remove(replacement);
            this.children().add(childIndex, replacement);
        }
        this.handleDropdownReplacement(current, replacement);
    }

    public void replaceWidget(AbstractWidget current, AbstractWidget replacement) {
        this.replaceWidget(current, replacement, false);
    }

    public void replaceRenderableWidget(AbstractWidget current, AbstractWidget replacement) {
        this.replaceWidget(current, replacement, true);
    }

    protected void removeWidget(GuiEventListener current) {
        this.dropdowns.remove(current);
        super.removeWidget(current);
    }

    @Override
    public Screen getEscape() {
        return this.escape;
    }

    public static Screen tryToGetEscape(Screen screen) {
        if (screen instanceof IScreenBase) {
            IScreenBase screenBase = (IScreenBase)screen;
            return screenBase.getEscape();
        }
        return null;
    }

    public static boolean hasShiftDown() {
        return InputConstants.isKeyDown((Window)Minecraft.getInstance().getWindow(), (int)340) || InputConstants.isKeyDown((Window)Minecraft.getInstance().getWindow(), (int)344);
    }

    public static boolean hasControlDown() {
        return InputConstants.isKeyDown((Window)Minecraft.getInstance().getWindow(), (int)341) || InputConstants.isKeyDown((Window)Minecraft.getInstance().getWindow(), (int)345);
    }
}

