/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.pvp.module.entityinfo;

import com.google.common.collect.Ordering;
import com.mojang.blaze3d.textures.GpuTextureView;
import java.util.Collection;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Holder;
import net.minecraft.data.AtlasIds;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import org.joml.Matrix3x2fStack;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import xaero.common.misc.Misc;
import xaero.hud.pvp.module.entityinfo.EntityInfoSession;
import xaero.hud.render.module.IModuleRenderer;
import xaero.hud.render.module.ModuleRenderContext;
import xaero.hud.render.util.GuiRenderUtil;
import xaero.pvp.BetterPVP;

public class EntityInfoRenderer
implements IModuleRenderer<EntityInfoSession> {
    public static final ResourceLocation HEART_CONTANER = ResourceLocation.parse((String)"hud/heart/container_blinking");
    public static final ResourceLocation NORMAL_HEART_FULL = ResourceLocation.parse((String)"hud/heart/full");
    public static final ResourceLocation NORMAL_HEART_HALF = ResourceLocation.parse((String)"hud/heart/half");
    public static final ResourceLocation ABSORBING_HEART_FULL = ResourceLocation.parse((String)"hud/heart/absorbing_full");
    public static final ResourceLocation ABSORBING_HEART_HALF = ResourceLocation.parse((String)"hud/heart/absorbing_half");
    public static final ResourceLocation ARMOR_EMPTY = ResourceLocation.parse((String)"hud/armor_empty");
    public static final ResourceLocation ARMOR_HALF = ResourceLocation.parse((String)"hud/armor_half");
    public static final ResourceLocation ARMOR_FULL = ResourceLocation.parse((String)"hud/armor_full");
    private final Random random = new Random();

    @Override
    public void render(EntityInfoSession session, ModuleRenderContext c, GuiGraphics guiGraphics, float partialTicks) {
        LivingEntity displayedEntity;
        Minecraft mc = Minecraft.getInstance();
        long time = System.currentTimeMillis();
        EntityHitResult objectMouseOver = session.getDetector().getMouseOver(mc, (Level)mc.level, session.getEntityInfoDistance(), partialTicks);
        if (objectMouseOver != null && objectMouseOver.getEntity() instanceof LivingEntity) {
            ServerLevel serverWorld;
            session.setDisplayedEntity((LivingEntity)objectMouseOver.getEntity());
            if (mc.getSingleplayerServer() != null && (serverWorld = mc.getSingleplayerServer().getLevel(mc.level.dimension())) != null) {
                session.setDisplayedServerEntity((LivingEntity)serverWorld.getEntity(objectMouseOver.getEntity().getUUID()));
            }
            session.setLastDetection(time);
        }
        if ((displayedEntity = session.getDisplayedEntity()) == null) {
            return;
        }
        if (time - session.getLastDetection() > 1000L * (long)session.getEntityInfoStay()) {
            return;
        }
        if (System.currentTimeMillis() - session.getLastEffectBlink() > 500L) {
            session.setLastEffectBlink(System.currentTimeMillis());
            session.setEffectBlink(!session.getEffectBlink());
        }
        try {
            int healthOff;
            boolean flippedVer = c.flippedVertically;
            boolean flippedHor = c.flippedHorizontally;
            float resize = 1.0f;
            if (displayedEntity.getBbWidth() > resize) {
                resize = displayedEntity.getBbWidth();
            }
            if (displayedEntity.getBbHeight() > resize * 2.0f) {
                resize = displayedEntity.getBbHeight() / 2.0f;
            }
            if (session.getEntityInfoShowEntityModel()) {
                this.drawEntityOnScreen(mc, guiGraphics, c.x + (flippedHor ? c.w - 25 : 25), c.y + 35, (int)(30.0f / resize), displayedEntity, flippedHor);
            }
            LivingEntity displayedServerEntity = session.getDisplayedServerEntity();
            int n = healthOff = session.getEntityInfoShowEntityModel() ? 55 : 5;
            if (mc.getSingleplayerServer() != null && session.getEntityInfoEffects() && displayedServerEntity != null) {
                int effectsOffset = (int)this.drawPotionEffects(mc, guiGraphics, session, displayedServerEntity, c.x + (flippedHor ? c.w - 3 : 3), c.y + (flippedVer ? c.h - 5 : 5), flippedVer ? c.y + c.h : c.screenHeight - c.y, flippedHor, flippedVer, c.screenScale);
                if (!session.getEntityInfoShowEntityModel() && effectsOffset != -1) {
                    healthOff += 3 + effectsOffset;
                }
            }
            boolean renderedArmor = session.getEntityInfoShowArmour() && this.drawArmourBar(mc, guiGraphics, session, displayedEntity, c.x + (flippedHor ? c.w - healthOff : healthOff), c.y + 15 + (flippedVer ? 31 : 0), flippedHor);
            this.drawHealthBar(mc, guiGraphics, session, displayedEntity, c.x + (flippedHor ? c.w - healthOff : healthOff), c.y + 15 + (flippedVer ? 31 : 0) + (renderedArmor ? 10 : 0) * (flippedVer ? -1 : 1), flippedHor, flippedVer);
            Component component = Misc.getFixedDisplayName((Entity)displayedEntity);
            if (component != null) {
                String name = component.getString();
                int xCoord = c.x + (flippedHor ? c.w - healthOff - mc.font.width(name) : healthOff);
                guiGraphics.drawString(mc.font, name, xCoord, c.y + 5 + (flippedVer ? 52 : 0), -1);
            }
        }
        catch (Exception e) {
            BetterPVP.LOGGER.error("Please report this to Xaero96 on PlanetMinecraft/MinecraftForums/CurseForge!", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawEntityOnScreen(Minecraft mc, GuiGraphics guiGraphics, int x, int y, int scale, LivingEntity entity, boolean flip) {
        double cos;
        if (entity == null) {
            return;
        }
        EntityRenderDispatcher rendermanager = mc.getEntityRenderDispatcher();
        if (rendermanager.camera == null) {
            return;
        }
        float yBodyRotBU = entity.yBodyRot;
        float yRotBU = entity.getYRot();
        float yHeadRotBU = entity.yHeadRot;
        entity.yBodyRot = 0.0f;
        entity.setYRot(0.0f);
        entity.yHeadRot = yHeadRotBU - yBodyRotBU;
        Quaternionf rotation = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf xRotation = new Quaternionf().rotateX(-0.5235988f);
        rotation.mul((Quaternionfc)xRotation);
        float width = entity.getBbWidth() * (float)scale / 30.0f;
        if (width < 1.0f) {
            width = 1.0f;
        }
        if ((cos = Math.sqrt(2.0) / 2.0 / (double)width) > 1.0) {
            cos = 1.0;
        }
        float yAngle = (float)Math.toDegrees(Math.acos(cos));
        Quaternionf yRotation = new Quaternionf().rotateY((float)((double)(180.0f + (flip ? -yAngle : yAngle)) * (Math.PI / 180)));
        rotation.mul((Quaternionfc)yRotation);
        Vector3f translation = new Vector3f(0.0f, entity.getBbHeight() / 2.0f, 0.0f);
        EntityRenderer entityRenderer = rendermanager.getRenderer((Entity)entity);
        try {
            EntityRenderState entityRenderState = entityRenderer.createRenderState((Entity)entity, 1.0f);
            guiGraphics.submitEntityRenderState(entityRenderState, (float)scale / entity.getScale(), translation, rotation, null, x - 25, y - 35, x + 25, y + 35);
        }
        finally {
            entity.yBodyRot = yBodyRotBU;
            entity.setYRot(yRotBU);
            entity.yHeadRot = yHeadRotBU;
        }
    }

    public boolean drawArmourBar(Minecraft mc, GuiGraphics guiGraphics, EntityInfoSession session, LivingEntity e, int x, int y, boolean flip) {
        int armorValue = e.getArmorValue();
        if (armorValue > 0) {
            if (session.getEntityInfoArmourNumbers()) {
                guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, ARMOR_FULL, x - (flip ? 8 : 0), y, 9, 9);
                guiGraphics.drawString(mc.font, armorValue + "/20", x + (flip ? -11 - mc.font.width(armorValue + "/20") : 11), y, -1);
            } else {
                for (int iconIndex = 0; iconIndex < 10; ++iconIndex) {
                    int iconX = x + (flip ? -8 - iconIndex * 8 : iconIndex * 8);
                    if (iconIndex * 2 + 1 < armorValue) {
                        guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, ARMOR_FULL, iconX, y, 9, 9);
                        continue;
                    }
                    if (iconIndex * 2 + 1 == armorValue) {
                        guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, ARMOR_HALF, iconX, y, 9, 9);
                        continue;
                    }
                    if (iconIndex * 2 + 1 <= armorValue) continue;
                    guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, ARMOR_EMPTY, iconX, y, 9, 9);
                }
            }
            return true;
        }
        return false;
    }

    public void drawHealthBar(Minecraft mc, GuiGraphics guiGraphics, EntityInfoSession session, LivingEntity e, int x, int y, boolean flip, boolean vertFlipped) {
        int health = Mth.ceil((float)e.getHealth());
        float maxHealth = Mth.ceil((double)e.getAttributeValue(Attributes.MAX_HEALTH));
        float absorptionAmount = Mth.ceil((float)e.getAbsorptionAmount());
        if (session.getEntityInfoHealthNumbers()) {
            String text = health + "/" + (int)maxHealth;
            if (absorptionAmount > 0.0f) {
                text = text + "+" + absorptionAmount;
                health = 0;
                maxHealth = 0.0f;
                absorptionAmount = 2.0f;
            } else {
                health = 2;
                maxHealth = 2.0f;
                absorptionAmount = 0.0f;
            }
            guiGraphics.drawString(mc.font, text, x + (flip ? -11 - mc.font.width(text) : 11), y, -1);
        }
        int regularHalvesToRender = (int)(maxHealth + 1.0f) / 2 * 2;
        int regularFilledHalves = health;
        int absorptionHalvesToRender = (int)(absorptionAmount + 1.0f) / 2 * 2;
        int absorptionFilledHalves = (int)absorptionAmount;
        int limit = session.getEntityInfoMaxHearts() * 2;
        if (regularHalvesToRender > limit) {
            regularHalvesToRender = limit;
            int n = regularFilledHalves = maxHealth == 0.0f ? 0 : Math.round((float)(health * regularHalvesToRender) / maxHealth);
        }
        if (absorptionHalvesToRender > limit) {
            absorptionHalvesToRender = absorptionFilledHalves = limit;
        }
        int totalHalvesToRender = regularHalvesToRender + absorptionHalvesToRender;
        int rows = Mth.ceil((float)((float)totalHalvesToRender / 20.0f));
        int rowStep = Math.max(10 - (rows - 2), 3);
        boolean shake = maxHealth != 0.0f && (double)health <= (double)maxHealth * 0.4;
        int absorptionLeft = absorptionFilledHalves;
        for (int heartIndex = totalHalvesToRender / 2 - 1; heartIndex >= 0; --heartIndex) {
            int rowIndex = (int)Math.ceil((float)(heartIndex + 1) / 10.0f) - 1;
            int xcoord = heartIndex % 10 * 8;
            int heartX = x + (flip ? -xcoord - 9 : xcoord);
            int heartY = y + rowIndex * rowStep * (vertFlipped ? -1 : 1);
            if (shake) {
                heartY += this.random.nextInt(2);
            }
            this.blitFlippable(mc, guiGraphics, HEART_CONTANER, heartX, heartY, 9, 9, flip);
            if (absorptionLeft > 0) {
                if (absorptionLeft == absorptionFilledHalves && absorptionFilledHalves % 2 == 1) {
                    this.blitFlippable(mc, guiGraphics, ABSORBING_HEART_HALF, heartX, heartY, 9, 9, flip);
                } else {
                    this.blitFlippable(mc, guiGraphics, ABSORBING_HEART_FULL, heartX, heartY, 9, 9, flip);
                }
                absorptionLeft -= 2;
                continue;
            }
            if (heartIndex * 2 + 1 < regularFilledHalves) {
                this.blitFlippable(mc, guiGraphics, NORMAL_HEART_FULL, heartX, heartY, 9, 9, flip);
            }
            if (heartIndex * 2 + 1 != regularFilledHalves) continue;
            this.blitFlippable(mc, guiGraphics, NORMAL_HEART_HALF, heartX, heartY, 9, 9, flip);
        }
    }

    public double drawPotionEffects(Minecraft mc, GuiGraphics guiGraphics, EntityInfoSession session, LivingEntity e, int x, int y, int h, boolean flippedHor, boolean flippedVer, double scale) {
        Collection effects = e.getActiveEffects();
        if (effects.isEmpty()) {
            return -1.0;
        }
        effects = Ordering.natural().sortedCopy((Iterable)effects);
        Matrix3x2fStack matrixStack = guiGraphics.pose();
        matrixStack.pushMatrix();
        matrixStack.translate((float)x, (float)y);
        double pixelSize = (double)session.getEntityInfoEffectsScale() / scale * session.getAutoUIScale() / 2.0;
        double effectSize = 25.0 * pixelSize;
        int perColumn = (int)((double)h / effectSize);
        int place = 0;
        for (MobEffectInstance pe : effects) {
            ResourceLocation sprite;
            if (pe == null || (sprite = Gui.getMobEffectSprite((Holder)pe.getEffect())) == null) continue;
            matrixStack.pushMatrix();
            matrixStack.scale((float)pixelSize, (float)pixelSize);
            int column = place / perColumn;
            int row = place % perColumn;
            matrixStack.translate(flippedHor ? (float)(-18 - 25 * column) : (float)(25 * column), flippedVer ? (float)(-18 - 25 * row) : (float)(25 * row));
            int color = -1;
            if (!pe.isInfiniteDuration() && pe.getDuration() <= 200 && !session.getEffectBlink()) {
                color = 0x66FFFFFF;
            }
            guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, sprite, 0, 0, 18, 18, color);
            ++place;
            matrixStack.popMatrix();
        }
        matrixStack.popMatrix();
        int rows = (effects.size() + perColumn - 1) / perColumn;
        return effectSize * (double)rows - 7.0 * pixelSize;
    }

    public void blitFlippable(Minecraft mc, GuiGraphics guiGraphics, ResourceLocation sprite, int x, int y, int width, int height, boolean flip) {
        TextureAtlasSprite textureAtlasSprite = mc.getAtlasManager().getAtlasOrThrow(AtlasIds.GUI).getSprite(sprite);
        ResourceLocation textureLocation = textureAtlasSprite.atlasLocation();
        GpuTextureView texture = mc.getTextureManager().getTexture(textureLocation).getTextureView();
        float u0 = flip ? textureAtlasSprite.getU1() : textureAtlasSprite.getU0();
        float u1 = flip ? textureAtlasSprite.getU0() : textureAtlasSprite.getU1();
        GuiRenderUtil.submitBlit(guiGraphics, RenderPipelines.GUI_TEXTURED, texture, x, y, x + width, y + height, u0, u1, textureAtlasSprite.getV0(), textureAtlasSprite.getV1(), -1);
    }
}

