/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.graphics;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.VertexFormat;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import xaero.common.core.ICompositeRenderType;
import xaero.common.core.ICompositeState;
import xaero.hud.render.util.ImmediateRenderUtil;

public class ImprovedCompositeRenderType
extends RenderType
implements ICompositeRenderType {
    private final RenderType vanillaCompositeRenderType;
    private final RenderPipeline renderPipeline;
    private final RenderType.CompositeState compositeState;
    private final RenderStateShard.OutputStateShard outputStateShard;

    public ImprovedCompositeRenderType(String name, int bufferSize, boolean affectsCrumbling, boolean sortOnUpload, RenderPipeline renderPipeline, RenderStateShard.OutputStateShard outputStateShard, RenderType.CompositeState compositeState, RenderType vanillaCompositeRenderType) {
        super(name, bufferSize, affectsCrumbling, sortOnUpload, () -> ((RenderType)vanillaCompositeRenderType).setupRenderState(), () -> ((RenderType)vanillaCompositeRenderType).clearRenderState());
        this.renderPipeline = renderPipeline;
        this.outputStateShard = outputStateShard;
        this.compositeState = compositeState;
        this.vanillaCompositeRenderType = vanillaCompositeRenderType;
    }

    public void draw(@Nonnull MeshData meshData) {
        this.setupRenderState();
        ImmediateRenderUtil.drawImmediateMeshData(meshData, this.renderPipeline, this.outputStateShard.getRenderTarget());
        this.clearRenderState();
    }

    @Nonnull
    public VertexFormat format() {
        return this.vanillaCompositeRenderType.format();
    }

    @Nonnull
    public VertexFormat.Mode mode() {
        return this.vanillaCompositeRenderType.mode();
    }

    public RenderPipeline pipeline() {
        return this.renderPipeline;
    }

    @Override
    public ICompositeState xaero_mm_getState() {
        return (ICompositeState)this.compositeState;
    }
}

