/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.pvp.module.tooltip;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.world.item.ItemStack;
import xaero.common.gui.GuiEditMode;
import xaero.hud.pvp.module.tooltip.ItemTooltipSession;
import xaero.hud.pvp.module.tooltip.TooltipScreenInstance;
import xaero.hud.render.module.IModuleRenderer;
import xaero.hud.render.module.ModuleRenderContext;

public class ItemTooltipRenderer
implements IModuleRenderer<ItemTooltipSession> {
    @Override
    public void render(ItemTooltipSession session, ModuleRenderContext c, GuiGraphics guiGraphics, float partialTicks) {
        Minecraft mc = Minecraft.getInstance();
        ItemStack currentStack = mc.player.getInventory().getSelectedItem();
        if (currentStack != session.getPreviousStack()) {
            session.setItemSwitchTime(System.currentTimeMillis());
            session.setPreviousStack(currentStack);
        }
        if (currentStack == null) {
            return;
        }
        if (currentStack.isEmpty()) {
            return;
        }
        if (!(mc.screen instanceof GuiEditMode) && System.currentTimeMillis() - session.getItemSwitchTime() > (long)((int)(session.getItemTooltipTime() * 1000.0))) {
            return;
        }
        TooltipScreenInstance screenInstance = session.getScreenInstance();
        screenInstance.setNecessaryFields(session.isCentered(), c.flippedHorizontally, c.flippedVertically);
        screenInstance.width = c.screenWidth;
        screenInstance.height = c.screenHeight;
        List<ClientTooltipComponent> textLines = session.getTooltipHelper().getTooltipLines(mc, currentStack, c.screenWidth, c.screenHeight);
        if (textLines.size() >= session.getItemTooltipMinLines()) {
            int border = 5;
            int renderX = c.x + border;
            int renderY = c.y + border;
            int renderW = c.w - 2 * border;
            int renderH = c.h - 2 * border;
            if (session.isCentered()) {
                renderX += renderW / 2 - 3;
            } else if (c.flippedHorizontally) {
                renderX += renderW - 7;
            }
            if (c.flippedVertically) {
                renderY += renderH - 8;
            }
            int renderXWithOffset = renderX + 3;
            int renderYWithOffset = renderY + 4;
            guiGraphics.renderTooltip(mc.font, textLines, renderXWithOffset, renderYWithOffset, (ClientTooltipPositioner)screenInstance, null);
        }
    }
}

