/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.info;

import java.util.function.Consumer;
import java.util.function.Supplier;
import xaero.common.HudMod;
import xaero.hud.minimap.common.config.info.config.InfoDisplayManagerConfigData;
import xaero.hud.minimap.common.config.option.MinimapProfiledConfigOptions;
import xaero.hud.minimap.info.BuiltInInfoDisplays;
import xaero.hud.minimap.info.InfoDisplay;
import xaero.hud.minimap.info.InfoDisplayIO;
import xaero.hud.minimap.info.InfoDisplayManager;
import xaero.hud.minimap.info.render.InfoDisplayRenderer;
import xaero.lib.client.config.ClientConfigManager;

public class InfoDisplays {
    private final InfoDisplayManager manager;
    private final InfoDisplayIO io;
    private final InfoDisplayRenderer renderer;

    public InfoDisplays(InfoDisplayIO io) {
        final ClientConfigManager configManager = HudMod.INSTANCE.getHudConfigs().getClientConfigManager();
        this.manager = InfoDisplayManager.Builder.begin().setLocalConfigSupplier(new Supplier<InfoDisplayManagerConfigData>(){

            @Override
            public InfoDisplayManagerConfigData get() {
                return (InfoDisplayManagerConfigData)configManager.getCurrentProfile().get(MinimapProfiledConfigOptions.INFO_DISPLAY_CONFIG);
            }
        }).setLocalConfigSetter(new Consumer<InfoDisplayManagerConfigData>(){

            @Override
            public void accept(InfoDisplayManagerConfigData config) {
                configManager.getCurrentProfile().set(MinimapProfiledConfigOptions.INFO_DISPLAY_CONFIG, (Object)config);
            }
        }).setEnforcedConfigSupplier(new Supplier<InfoDisplayManagerConfigData>(){

            @Override
            public InfoDisplayManagerConfigData get() {
                if (configManager.shouldIgnoreServerEnforcement(MinimapProfiledConfigOptions.INFO_DISPLAY_CONFIG)) {
                    return null;
                }
                return (InfoDisplayManagerConfigData)configManager.getServerSynced().getConfig().get(MinimapProfiledConfigOptions.INFO_DISPLAY_CONFIG);
            }
        }).build();
        BuiltInInfoDisplays.forEach(new Consumer<InfoDisplay<?>>(){

            @Override
            public void accept(InfoDisplay<?> d) {
                InfoDisplays.this.manager.add(d);
            }
        });
        this.io = io;
        this.renderer = InfoDisplayRenderer.Builder.begin().build();
    }

    public InfoDisplayManager getManager() {
        return this.manager;
    }

    public InfoDisplayIO getIo() {
        return this.io;
    }

    public InfoDisplayRenderer getRenderer() {
        return this.renderer;
    }

    public void clearStateCache() {
        this.manager.clearStateCache();
    }
}

