/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.player.tracker.synced;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import xaero.common.server.radar.tracker.SyncedTrackedPlayer;

public abstract class ClientSyncedTrackedPlayerManager {
    private final Map<UUID, SyncedTrackedPlayer> trackedPlayers = new HashMap<UUID, SyncedTrackedPlayer>();

    protected ClientSyncedTrackedPlayerManager() {
    }

    public void remove(UUID id) {
        this.trackedPlayers.remove(id);
    }

    public void update(UUID id, double x, double y, double z, int dim) {
        SyncedTrackedPlayer current = this.trackedPlayers.get(id);
        if (current != null) {
            current.setPos(x, y, z).setDimension(dim);
            return;
        }
        this.trackedPlayers.put(id, new SyncedTrackedPlayer(id, x, y, z, dim));
    }

    public Iterable<SyncedTrackedPlayer> getPlayers() {
        return this.trackedPlayers.values();
    }

    public void reset() {
        this.trackedPlayers.clear();
    }

    public static final class Builder {
        private Builder() {
        }

        public Builder setDefault() {
            return this;
        }

        public ClientSyncedTrackedPlayerManager build() {
            return new xaero.common.minimap.radar.tracker.synced.ClientSyncedTrackedPlayerManager();
        }

        public static Builder begin() {
            return new Builder().setDefault();
        }
    }
}

