/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.world;

import net.minecraft.client.Minecraft;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import xaero.common.misc.Misc;
import xaero.hud.minimap.world.MinimapWorld;
import xaero.hud.minimap.world.container.MinimapWorldRootContainer;

public class MinimapDimensionHelper {
    public double getDimensionDivision(MinimapWorld minimapWorld) {
        if (Minecraft.func_71410_x().field_71441_e == null) {
            return 1.0;
        }
        double dimCoordinateScale = this.getDimCoordinateScale(minimapWorld);
        return Misc.getDimensionTypeScale((World)Minecraft.func_71410_x().field_71441_e) / dimCoordinateScale;
    }

    public double getDimCoordinateScale(MinimapWorld minimapWorld) {
        if (minimapWorld == null) {
            return 1.0;
        }
        MinimapWorldRootContainer rootContainer = minimapWorld.getContainer().getRoot();
        int dimKey = minimapWorld.getDimId();
        return rootContainer.getDimensionScale(dimKey);
    }

    public String getDimensionDirectoryName(int dim) {
        return "dim%" + dim;
    }

    public DimensionType findDimensionType(String validatedName) {
        DimensionType[] allDimensionTypes;
        for (DimensionType dt : allDimensionTypes = DimensionType.values()) {
            if (!validatedName.equals(dt.func_186065_b().replaceAll("[^a-zA-Z0-9_]+", ""))) continue;
            return dt;
        }
        return null;
    }

    public Integer getDimensionKeyForDirectoryName(String dirName) {
        int dimId;
        String dimIdPart = dirName.substring(4);
        if (!dimIdPart.matches("-{0,1}[0-9]+")) {
            return null;
        }
        try {
            dimId = Integer.parseInt(dimIdPart);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        return dimId;
    }
}

