/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.radar.icon.creator.render.form.model.part;

import it.unimi.dsi.fastutil.objects.ObjectList;
import java.lang.reflect.Field;
import net.minecraft.client.renderer.model.ModelRenderer;
import xaero.lib.common.reflection.util.ReflectionUtils;

public class ModelPartUtil {
    private static final Field CUBES_FIELD = ReflectionUtils.getFieldReflection(ModelRenderer.class, (String)"cubes", (String)"field_3663", (String)"Lit/unimi/dsi/fastutil/objects/ObjectList;", (String)"field_78804_l");
    private static final Field CHILDREN_FIELD = ReflectionUtils.getFieldReflection(ModelRenderer.class, (String)"children", (String)"field_3661", (String)"Lit/unimi/dsi/fastutil/objects/ObjectList;", (String)"field_78805_m");

    public static ObjectList<ModelRenderer.ModelBox> getCubes(ModelRenderer modelRenderer) {
        return (ObjectList)ReflectionUtils.getReflectFieldValue((Object)modelRenderer, (Field)CUBES_FIELD);
    }

    public static ObjectList<ModelRenderer> getChildren(ModelRenderer modelRenderer) {
        return (ObjectList)ReflectionUtils.getReflectFieldValue((Object)modelRenderer, (Field)CHILDREN_FIELD);
    }

    public static boolean hasDirectCubes(ModelRenderer part) {
        ObjectList<ModelRenderer.ModelBox> cubes = ModelPartUtil.getCubes(part);
        return cubes != null && !cubes.isEmpty();
    }

    public static boolean hasCubes(ModelRenderer part) {
        if (ModelPartUtil.hasDirectCubes(part)) {
            return true;
        }
        ObjectList<ModelRenderer> children = ModelPartUtil.getChildren(part);
        for (ModelRenderer child : children) {
            if (!ModelPartUtil.hasCubes(child)) continue;
            return true;
        }
        return false;
    }

    public static ModelRenderer.ModelBox getBiggestCuboid(ModelRenderer part) {
        ObjectList<ModelRenderer.ModelBox> mainCubeList = ModelPartUtil.getCubes(part);
        if (mainCubeList == null) {
            return null;
        }
        if (mainCubeList.isEmpty()) {
            return null;
        }
        float biggestSize = 0.0f;
        ModelRenderer.ModelBox biggestCuboid = null;
        for (ModelRenderer.ModelBox cuboid : mainCubeList) {
            float size = Math.abs((cuboid.field_78248_d - cuboid.field_78252_a) * (cuboid.field_78249_e - cuboid.field_78250_b) * (cuboid.field_78246_f - cuboid.field_78251_c));
            if (!(size >= biggestSize)) continue;
            biggestCuboid = cuboid;
            biggestSize = size;
        }
        return biggestCuboid;
    }
}

