/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.waypoint;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.ChatVisibility;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.World;
import xaero.common.HudMod;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.hud.minimap.common.config.option.MinimapProfiledConfigOptions;
import xaero.hud.minimap.config.primary.option.MinimapPrimaryClientConfigOptions;
import xaero.hud.minimap.module.MinimapSession;
import xaero.hud.minimap.waypoint.WaypointSession;
import xaero.hud.minimap.world.MinimapWorld;
import xaero.hud.minimap.world.container.MinimapWorldRootContainer;
import xaero.hud.minimap.world.container.config.RootConfig;
import xaero.hud.path.XaeroPath;
import xaero.lib.client.config.ClientConfigManager;
import xaero.lib.common.config.option.ConfigOption;
import xaero.lib.common.config.single.SingleConfigManager;

public class WaypointTeleport {
    public static final String TELEPORT_ANYWAY_COMMAND = "xaero_tp_anyway";
    public static final String SLASH_TELEPORT_ANYWAY_COMMAND = "/xaero_tp_anyway";
    private final HudMod modMain;
    private final Minecraft mc;
    private final WaypointSession session;
    private final MinimapSession minimapSession;
    private Waypoint teleportAnywayWP;
    private MinimapWorld teleportAnywayWorld;

    public WaypointTeleport(HudMod modMain, WaypointSession session, MinimapSession minimapSession) {
        this.modMain = modMain;
        this.session = session;
        this.minimapSession = minimapSession;
        this.mc = Minecraft.func_71410_x();
    }

    public boolean canTeleport(boolean displayingTeleportableWorld, MinimapWorld displayedWorld) {
        ClientConfigManager configManager = this.modMain.getHudConfigs().getClientConfigManager();
        SingleConfigManager primaryConfigManager = configManager.getPrimaryConfigManager();
        return ((Boolean)primaryConfigManager.getEffective((ConfigOption)MinimapPrimaryClientConfigOptions.WRONG_WORLD_TELEPORT) != false || displayingTeleportableWorld) && displayedWorld.getRootConfig().isTeleportationEnabled();
    }

    public void teleportAnyway() {
        if (this.teleportAnywayWP == null) {
            return;
        }
        Screen dummyScreen = new Screen((ITextComponent)new StringTextComponent("")){};
        Minecraft minecraft = Minecraft.func_71410_x();
        dummyScreen.func_231158_b_(minecraft, minecraft.func_228018_at_().func_198107_o(), minecraft.func_228018_at_().func_198087_p());
        this.teleportToWaypoint(this.teleportAnywayWP, this.teleportAnywayWorld, dummyScreen, false);
    }

    public void teleportToWaypoint(Waypoint waypoint, MinimapWorld world, Screen screen) {
        this.teleportToWaypoint(waypoint, world, screen, true);
    }

    public void teleportToWaypoint(Waypoint waypoint, MinimapWorld world, Screen screen, boolean respectHiddenCoords) {
        String tpCommand;
        this.minimapSession.getWorldStateUpdater().update();
        boolean isTeleportableWorld = this.isWorldTeleportable(world);
        if (waypoint == null || !this.canTeleport(isTeleportableWorld, world)) {
            return;
        }
        this.mc.func_147108_a(null);
        if (!waypoint.isYIncluded() && this.mc.field_71442_b.func_78755_b()) {
            StringTextComponent messageComponent = new StringTextComponent(I18n.func_135052_a((String)"gui.xaero_teleport_y_unknown", (Object[])new Object[0]));
            messageComponent.func_230530_a_(messageComponent.func_150256_b().func_240712_a_(TextFormatting.RED));
            this.mc.field_71456_v.func_146158_b().func_146227_a((ITextComponent)messageComponent);
            return;
        }
        String fullCommand = "";
        boolean crossDimension = false;
        MinimapWorldRootContainer rootContainer = world.getContainer().getRoot();
        MinimapWorld autoWorld = this.minimapSession.getWorldManager().getAutoWorld();
        if (isTeleportableWorld && world != autoWorld) {
            if (!this.isTeleportationSafe(world)) {
                StringTextComponent messageComponent = new StringTextComponent(I18n.func_135052_a((String)"gui.xaero_teleport_not_connected", (Object[])new Object[0]));
                messageComponent.func_230530_a_(messageComponent.func_150256_b().func_240712_a_(TextFormatting.RED));
                this.mc.field_71456_v.func_146158_b().func_146227_a((ITextComponent)messageComponent);
                return;
            }
            boolean reachableDimension = true;
            if (autoWorld == null || autoWorld.getContainer() != world.getContainer()) {
                crossDimension = true;
                XaeroPath containerPath = world.getContainer().getPath();
                if (containerPath.getNodeCount() > 1) {
                    String dimensionNode = containerPath.getAtIndex(1).getLastNode();
                    if (!dimensionNode.startsWith("dim%")) {
                        this.mc.field_71456_v.func_146158_b().func_146227_a((ITextComponent)new TranslationTextComponent("gui.xaero_visit_needed"));
                        return;
                    }
                    RegistryKey<World> dimensionId = this.minimapSession.getDimensionHelper().getDimensionKeyForDirectoryName(dimensionNode);
                    if (dimensionId != null) {
                        this.minimapSession.getWorldState().setCustomWorldPath(null);
                        fullCommand = "/execute in " + dimensionId.func_240901_a_() + " run ";
                    } else {
                        reachableDimension = false;
                    }
                } else {
                    reachableDimension = false;
                }
            }
            if (!reachableDimension) {
                this.mc.field_71456_v.func_146158_b().func_146227_a((ITextComponent)new StringTextComponent(I18n.func_135052_a((String)"gui.xaero_unreachable_dimension", (Object[])new Object[0])).func_240699_a_(TextFormatting.RED));
                return;
            }
        }
        ClientConfigManager configManager = this.modMain.getHudConfigs().getClientConfigManager();
        boolean hideWaypointCoordinatesConfig = (Boolean)configManager.getEffective((ConfigOption)MinimapProfiledConfigOptions.HIDE_WAYPOINT_COORDINATES);
        if (respectHiddenCoords && hideWaypointCoordinatesConfig && this.mc.field_71474_y.field_74343_n != ChatVisibility.HIDDEN) {
            StringTextComponent messageComponent = new StringTextComponent(I18n.func_135052_a((String)"gui.xaero_teleport_coordinates_hidden", (Object[])new Object[0]));
            messageComponent.func_230530_a_(messageComponent.func_150256_b().func_240712_a_(TextFormatting.AQUA));
            this.mc.field_71456_v.func_146158_b().func_146227_a((ITextComponent)messageComponent);
            StringTextComponent clickableQuestion = new StringTextComponent("\u00a7e[" + I18n.func_135052_a((String)"gui.xaero_teleport_anyway", (Object[])new Object[0]) + "]");
            clickableQuestion.func_230530_a_(clickableQuestion.func_150256_b().func_240715_a_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, SLASH_TELEPORT_ANYWAY_COMMAND)).func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new StringTextComponent(I18n.func_135052_a((String)"gui.xaero_teleport_shows_coordinates", (Object[])new Object[0])).func_240699_a_(TextFormatting.RED))));
            this.teleportAnywayWP = waypoint;
            this.teleportAnywayWorld = world;
            this.mc.field_71456_v.func_146158_b().func_146227_a((ITextComponent)clickableQuestion);
            return;
        }
        int x = waypoint.getX();
        int z = waypoint.getZ();
        double dimDiv = this.minimapSession.getDimensionHelper().getDimensionDivision(world);
        if (!crossDimension && dimDiv != 1.0) {
            x = (int)Math.floor((double)x / dimDiv);
            z = (int)Math.floor((double)z / dimDiv);
        }
        RootConfig config = rootContainer.getConfig();
        String serverTpCommand = waypoint.isRotation() ? config.getServerTeleportCommandRotationFormat() : config.getServerTeleportCommandFormat();
        String defaultTpCommand = (String)configManager.getEffective(waypoint.isRotation() ? MinimapProfiledConfigOptions.WAYPOINT_DEFAULT_TELEPORT_ROTATION_FORMAT : MinimapProfiledConfigOptions.WAYPOINT_DEFAULT_TELEPORT_FORMAT);
        String string = tpCommand = config.isUsingDefaultTeleportCommand() || serverTpCommand == null ? defaultTpCommand : serverTpCommand;
        if (!fullCommand.isEmpty()) {
            if (tpCommand.startsWith("/")) {
                tpCommand = tpCommand.substring(1);
            }
            if (tpCommand.startsWith("minecraft:")) {
                tpCommand = tpCommand.substring(10);
            }
        }
        boolean partialYConfig = (Boolean)configManager.getEffective((ConfigOption)MinimapProfiledConfigOptions.WAYPOINT_PARTIAL_Y_TELEPORT);
        String yString = !waypoint.isYIncluded() ? "~" : (partialYConfig ? (double)waypoint.getY() + 0.5 + "" : waypoint.getY() + "");
        tpCommand = tpCommand.replace("{x}", "" + x).replace("{y}", yString).replace("{z}", "" + z).replace("{name}", waypoint.getLocalizedName());
        if (waypoint.isRotation()) {
            tpCommand = tpCommand.replace("{yaw}", "" + waypoint.getYaw());
        }
        fullCommand = fullCommand + tpCommand;
        screen.func_231159_b_(fullCommand, false);
    }

    public boolean isWorldTeleportable(MinimapWorld displayedWorld) {
        MinimapWorld autoWorld = this.minimapSession.getWorldManager().getAutoWorld();
        MinimapWorldRootContainer rootContainer = displayedWorld.getContainer().getRoot();
        if (!rootContainer.getPath().equals(this.minimapSession.getWorldState().getAutoRootContainerPath())) {
            return false;
        }
        if (autoWorld == displayedWorld) {
            return true;
        }
        if (autoWorld == null) {
            return false;
        }
        if (autoWorld.getContainer() == displayedWorld.getContainer()) {
            return true;
        }
        return (Boolean)this.modMain.getHudConfigs().getClientConfigManager().getEffective((ConfigOption)MinimapProfiledConfigOptions.WAYPOINT_TELEPORT_CROSS_DIMENSION);
    }

    public boolean isTeleportationSafe(MinimapWorld displayedWorld) {
        if (!Minecraft.func_71410_x().field_71442_b.func_78755_b()) {
            return true;
        }
        MinimapWorld autoWorld = this.minimapSession.getWorldManager().getAutoWorld();
        MinimapWorldRootContainer rootContainer = displayedWorld.getContainer().getRoot();
        return rootContainer.getSubWorldConnections().isConnected(autoWorld, displayedWorld);
    }
}

