/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.ResourceLocationException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import xaero.common.HudMod;
import xaero.common.IXaeroMinimap;
import xaero.common.anim.MultiplyAnimationHelper;
import xaero.common.graphics.CustomVertexConsumers;
import xaero.common.minimap.MinimapInterface;
import xaero.common.minimap.mcworld.MinimapClientWorldData;
import xaero.common.minimap.mcworld.MinimapClientWorldDataHelper;
import xaero.common.minimap.radar.MinimapRadar;
import xaero.common.minimap.radar.tracker.synced.ClientSyncedTrackedPlayerManager;
import xaero.common.minimap.write.MinimapWriter;
import xaero.common.misc.Misc;
import xaero.hud.minimap.BuiltInHudModules;
import xaero.hud.minimap.MinimapLogs;
import xaero.hud.minimap.common.config.option.MinimapProfiledConfigOptions;
import xaero.hud.minimap.config.util.MinimapConfigClientUtils;
import xaero.hud.minimap.module.MinimapSession;
import xaero.hud.minimap.radar.RadarSession;
import xaero.hud.minimap.radar.category.EntityRadarCategoryManager;
import xaero.lib.client.config.ClientConfigManager;
import xaero.lib.common.config.option.ConfigOption;

public class MinimapProcessor {
    public static final boolean DEBUG = false;
    public static final int FRAME = 9;
    private IXaeroMinimap modMain;
    private MinimapSession minimapSession;
    private MinimapWriter minimapWriter;
    private RadarSession radarSession;
    private MinimapInterface minimapInterface;
    private EntityRadarCategoryManager entityCategoryManager;
    private xaero.hud.minimap.player.tracker.synced.ClientSyncedTrackedPlayerManager syncedTrackedPlayerManager;
    private double minimapZoom;
    private boolean toResetImage;
    private boolean enlargedMap;
    private boolean manualCaveMode;
    private boolean noMinimapMessageReceived;
    private boolean fairPlayOnlyMessageReceived;
    private boolean consideringNetherFairPlayMessage;
    private double lastMapDimensionScale = 1.0;
    private ResourceKey<Level> lastMapDimension;
    private double lastPlayerDimDiv = 1.0;
    private Item minimapItem;

    public MinimapProcessor(IXaeroMinimap modMain, MinimapSession minimapSession, MinimapWriter minimapWriter, RadarSession radarSession, xaero.hud.minimap.player.tracker.synced.ClientSyncedTrackedPlayerManager syncedTrackedPlayerManager) {
        this.modMain = modMain;
        this.minimapSession = minimapSession;
        this.minimapWriter = minimapWriter;
        this.radarSession = radarSession;
        this.minimapZoom = 1.0;
        this.toResetImage = true;
        this.minimapInterface = modMain.getInterfaces().getMinimapInterface();
        this.syncedTrackedPlayerManager = syncedTrackedPlayerManager;
        this.updateMinimapItem();
    }

    public int getMinimapSize() {
        int minimapSizeConfig = MinimapConfigClientUtils.getEffectiveMinimapSize();
        return this.enlargedMap ? 500 : minimapSizeConfig * 2;
    }

    public int getMinimapBufferSize(int minimapSize) {
        int bufferSize = 128 * (int)Math.pow(2.0, Math.ceil(Math.log((double)minimapSize / 128.0) / Math.log(2.0)));
        if (bufferSize < 128) {
            return 128;
        }
        if (bufferSize > 512) {
            return 512;
        }
        return bufferSize;
    }

    public boolean isEnlargedMap() {
        return this.enlargedMap;
    }

    public void setEnlargedMap(boolean enlargedMap) {
        this.enlargedMap = enlargedMap;
    }

    public double getMinimapZoom() {
        return this.minimapZoom;
    }

    public boolean isCaveModeDisplayed() {
        return this.minimapWriter.getLoadedCaving() != Integer.MAX_VALUE;
    }

    public double getTargetZoom() {
        int enlargedZoomConfig;
        ClientConfigManager configManager = HudMod.INSTANCE.getHudConfigs().getClientConfigManager();
        float target = ((Integer)configManager.getEffective((ConfigOption)MinimapProfiledConfigOptions.ZOOM)).intValue();
        if (this.enlargedMap && (enlargedZoomConfig = ((Integer)configManager.getEffective((ConfigOption)MinimapProfiledConfigOptions.ZOOM_ENLARGED)).intValue()) > 0) {
            target = enlargedZoomConfig;
        }
        if (this.isCaveModeDisplayed()) {
            target *= (float)((Integer)configManager.getEffective((ConfigOption)MinimapProfiledConfigOptions.CAVE_ZOOM)).intValue();
        }
        if (target > 5.0f) {
            target = 5.0f;
        }
        return target;
    }

    public void instantZoom() {
        this.minimapZoom = this.getTargetZoom();
    }

    public void updateZoom() {
        double target = this.getTargetZoom();
        double off = target - this.minimapZoom;
        off = off > 0.01 || off < -0.01 ? (double)((float)MultiplyAnimationHelper.animate(off, 0.8)) : 0.0;
        this.minimapZoom = target - off;
    }

    public MinimapWriter getMinimapWriter() {
        return this.minimapWriter;
    }

    public boolean canUseFrameBuffer() {
        return true;
    }

    public int getFBOBufferSize() {
        return 512;
    }

    public void onClientTick() {
        Level world = null;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && player.f_19853_ instanceof ClientLevel) {
            world = player.f_19853_;
        }
        Entity renderEntity = Minecraft.m_91087_().m_91288_();
        this.radarSession.update((ClientLevel)world, renderEntity, (Player)player);
    }

    public void onPlayerTick() {
    }

    public void checkFBO() {
        if (this.minimapInterface.getMinimapFBORenderer().isLoadedFBO() && !this.canUseFrameBuffer()) {
            this.minimapInterface.getMinimapFBORenderer().setLoadedFBO(false);
            this.minimapInterface.getMinimapFBORenderer().deleteFramebuffers();
            this.toResetImage = true;
        }
        boolean mapSafeMode = (Boolean)HudMod.INSTANCE.getHudConfigs().getClientConfigManager().getEffective((ConfigOption)MinimapProfiledConfigOptions.SAFE_MODE);
        if (!(this.minimapInterface.getMinimapFBORenderer().isLoadedFBO() || mapSafeMode || this.minimapInterface.getMinimapFBORenderer().isTriedFBO())) {
            if (Minecraft.m_91087_().m_91265_() != null) {
                return;
            }
            this.minimapInterface.getMinimapFBORenderer().loadFrameBuffer(this);
        }
    }

    public void onRender(PoseStack matrixStack, int x, int y, int width, int height, double scale, int size, int boxSize, float partial, CustomVertexConsumers cvc) {
        try {
            if (this.enlargedMap && ((Boolean)HudMod.INSTANCE.getHudConfigs().getClientConfigManager().getEffective((ConfigOption)MinimapProfiledConfigOptions.CENTERED_ENLARGED)).booleanValue()) {
                x = (width - boxSize) / 2;
                y = (height - boxSize) / 2;
            }
            if (this.minimapInterface.usingFBO()) {
                this.minimapInterface.getMinimapFBORenderer().renderMinimap(this.minimapSession, matrixStack, this, x, y, width, height, scale, size, partial, cvc);
            } else {
                this.minimapInterface.getMinimapSafeModeRenderer().renderMinimap(this.minimapSession, matrixStack, this, x, y, width, height, scale, size, partial, cvc);
            }
        }
        catch (Throwable e) {
            this.minimapInterface.setCrashedWith(e);
        }
    }

    public static boolean hasMinimapItem(Player player) {
        MinimapSession session = BuiltInHudModules.MINIMAP.getCurrentSession();
        if (session == null) {
            return true;
        }
        MinimapProcessor processor = session.getProcessor();
        return processor.minimapItem == null || Misc.hasItem(player, processor.minimapItem);
    }

    public boolean isToResetImage() {
        return this.toResetImage;
    }

    public void setToResetImage(boolean toResetImage) {
        this.toResetImage = toResetImage;
    }

    @Deprecated
    public MinimapRadar getEntityRadar() {
        return (MinimapRadar)this.radarSession;
    }

    public RadarSession getRadarSession() {
        return this.radarSession;
    }

    public void cleanup() {
        this.minimapWriter.cleanup();
    }

    public boolean isManualCaveMode() {
        return this.manualCaveMode || this.modMain.getSupportMods().shouldUseWorldMapCaveChunks() && this.modMain.getSupportMods().worldmapSupport.getManualCaveStart() != Integer.MAX_VALUE;
    }

    public void toggleManualCaveMode() {
        this.manualCaveMode = !this.isManualCaveMode();
    }

    public MinimapInterface getMinimapInterface() {
        return this.minimapInterface;
    }

    public boolean getNoMinimapMessageReceived() {
        if (HudMod.INSTANCE.getHudConfigs().getClientConfigManager().getServerSynced().isChannelPresentOnServer()) {
            return false;
        }
        return this.noMinimapMessageReceived;
    }

    public void setNoMinimapMessageReceived(boolean noMinimapMessageReceived) {
        this.noMinimapMessageReceived = noMinimapMessageReceived;
    }

    public boolean getForcedFairPlay() {
        return this.fairPlayOnlyMessageReceived;
    }

    public void setFairPlayOnlyMessageReceived(boolean fairPlayOnlyMessageReceived) {
        this.fairPlayOnlyMessageReceived = fairPlayOnlyMessageReceived;
    }

    @Deprecated
    public ClientSyncedTrackedPlayerManager getClientSyncedTrackedPlayerManager() {
        return (ClientSyncedTrackedPlayerManager)this.syncedTrackedPlayerManager;
    }

    public xaero.hud.minimap.player.tracker.synced.ClientSyncedTrackedPlayerManager getSyncedTrackedPlayerManager() {
        return this.syncedTrackedPlayerManager;
    }

    public boolean serverHasMod() {
        MinimapClientWorldData worldData = MinimapClientWorldDataHelper.getCurrentWorldData();
        return worldData != null && worldData.serverLevelId != null;
    }

    public void setServerModNetworkVersion(int networkVersion) {
        MinimapClientWorldData worldData = MinimapClientWorldDataHelper.getCurrentWorldData();
        if (worldData == null) {
            return;
        }
        worldData.setServerModNetworkVersion(networkVersion);
    }

    public int getServerModNetworkVersion() {
        MinimapClientWorldData worldData = MinimapClientWorldDataHelper.getCurrentWorldData();
        if (worldData == null) {
            return 0;
        }
        return worldData.getServerModNetworkVersion();
    }

    public double getLastMapDimensionScale() {
        return this.lastMapDimensionScale;
    }

    public void setLastMapDimensionScale(double lastMapDimensionScale) {
        this.lastMapDimensionScale = lastMapDimensionScale;
    }

    public ResourceKey<Level> getLastMapDimension() {
        return this.lastMapDimension;
    }

    public void setLastMapDimension(ResourceKey<Level> lastMapDimension) {
        this.lastMapDimension = lastMapDimension;
    }

    @Deprecated
    public double getLastPlayerDimDiv() {
        return this.lastPlayerDimDiv;
    }

    @Deprecated
    public void setLastPlayerDimDiv(double lastPlayerDimDiv) {
        this.lastPlayerDimDiv = lastPlayerDimDiv;
    }

    public MinimapSession getSession() {
        return this.minimapSession;
    }

    public void updateMinimapItem() {
        ResourceLocation minimapItemRL;
        String minimapItemString = ((String)HudMod.INSTANCE.getHudConfigs().getClientConfigManager().getEffective(MinimapProfiledConfigOptions.MINIMAP_ITEM)).trim();
        if (minimapItemString.isEmpty() || minimapItemString.equals("-")) {
            this.minimapItem = null;
            MinimapLogs.LOGGER.info("Minimap required item set to nothing.");
            return;
        }
        try {
            minimapItemRL = new ResourceLocation(minimapItemString);
        }
        catch (ResourceLocationException rle) {
            this.minimapItem = null;
            MinimapLogs.LOGGER.error("Tried setting the minimap required item to a misformatted ID: {}; Error: {}", (Object)minimapItemString, (Object)rle.getMessage());
            return;
        }
        this.minimapItem = (Item)Registry.f_122827_.m_7745_(minimapItemRL);
        if (this.minimapItem == Items.f_41852_) {
            this.minimapItem = null;
            MinimapLogs.LOGGER.error("Tried setting the minimap required item to an invalid ID: {}", (Object)minimapItemString);
            return;
        }
        MinimapLogs.LOGGER.info("Minimap item set: " + this.minimapItem.m_41466_().getString());
    }

    public Item getMinimapItem() {
        return this.minimapItem;
    }

    public void setConsideringNetherFairPlayMessage(boolean consideringNetherFairPlay) {
        this.consideringNetherFairPlayMessage = consideringNetherFairPlay;
    }

    public boolean isConsideringNetherFairPlayMessage() {
        return this.consideringNetherFairPlayMessage;
    }
}

