/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.pvp.module.armor;

import net.minecraft.ChatFormatting;
import net.minecraft.core.Registry;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.enchantment.Enchantment;
import xaero.common.gui.component.CachedComponentSupplier;

public class ArmorStatusCachedComponents {
    static final CachedComponentSupplier ARROW_COUNT;
    static final CachedComponentSupplier[] FOOD_RESTORES;
    static final CachedComponentSupplier[] DURABILITY;
    static final CachedComponentSupplier[] LABEL_WITH_COUNT;
    static final CachedComponentSupplier[] ENCHANTS;

    private static void translateEchant(StringBuilder lineBuilder, String name, int count) {
        if (name == null || name.isEmpty()) {
            return;
        }
        if (count <= 1) {
            lineBuilder.append(name);
            return;
        }
        String[] words = name.split(" ");
        for (int i = 0; i < words.length; ++i) {
            String s1 = words[i];
            if (i == words.length - 1 || s1.length() <= 2) {
                lineBuilder.append(s1);
                continue;
            }
            lineBuilder.append(s1.substring(0, 1).toUpperCase()).append(s1.substring(1, 2).toLowerCase()).append("-");
        }
    }

    static {
        int i;
        ARROW_COUNT = new CachedComponentSupplier(args -> {
            int count = (Integer)args[0];
            int totalCount = (Integer)args[1];
            return new TextComponent(count + "/" + totalCount);
        });
        FOOD_RESTORES = new CachedComponentSupplier[32];
        DURABILITY = new CachedComponentSupplier[32];
        LABEL_WITH_COUNT = new CachedComponentSupplier[32];
        ENCHANTS = new CachedComponentSupplier[32];
        for (i = 0; i < FOOD_RESTORES.length; ++i) {
            ArmorStatusCachedComponents.FOOD_RESTORES[i] = new CachedComponentSupplier(args -> {
                double restoreValue = (Double)args[0];
                TranslatableComponent result = new TranslatableComponent("gui.xaero_restores");
                result.m_7360_().add(new TextComponent(" " + restoreValue));
                return result;
            });
        }
        for (i = 0; i < DURABILITY.length; ++i) {
            ArmorStatusCachedComponents.DURABILITY[i] = new CachedComponentSupplier(args -> {
                int type = (Integer)args[0];
                if (type == 3) {
                    return new TextComponent("");
                }
                int maxDamage = (Integer)args[1];
                int currentDamage = (Integer)args[2];
                int durabilityLeft = maxDamage - currentDamage;
                int percent = durabilityLeft * 100 / maxDamage;
                TextComponent result = type == 0 ? new TextComponent(percent + "%") : (type == 1 ? new TextComponent(durabilityLeft + "/" + maxDamage) : new TextComponent(durabilityLeft + "/" + maxDamage + " (" + percent + "%)"));
                if (percent <= 5) {
                    result = result.m_130940_(ChatFormatting.LIGHT_PURPLE);
                } else if (percent <= 25) {
                    result = result.m_130940_(ChatFormatting.RED);
                } else if (percent <= 50) {
                    result = result.m_130940_(ChatFormatting.GOLD);
                } else if (percent <= 75) {
                    result = result.m_130940_(ChatFormatting.YELLOW);
                }
                return result;
            });
        }
        for (i = 0; i < LABEL_WITH_COUNT.length; ++i) {
            ArmorStatusCachedComponents.LABEL_WITH_COUNT[i] = new CachedComponentSupplier(args -> {
                Component label = (Component)args[0];
                int count = (Integer)args[1];
                boolean flipped = (Boolean)args[2];
                TranslatableComponent result = flipped ? new TranslatableComponent("(" + count + ") ") : new TextComponent("");
                result.m_7360_().add(label);
                if (!flipped) {
                    result.m_7360_().add(new TextComponent(" (" + count + ")"));
                }
                return result;
            });
        }
        for (int j = 0; j < ENCHANTS.length; ++j) {
            ArmorStatusCachedComponents.ENCHANTS[j] = new CachedComponentSupplier(args -> {
                ListTag enchants = (ListTag)args[0];
                int color = (Integer)args[1];
                int count = enchants.size();
                StringBuilder lineBuilder = new StringBuilder();
                for (int i = 0; i < count; ++i) {
                    String id = enchants.m_128728_(i).m_128461_("id");
                    short lvl = enchants.m_128728_(i).m_128448_("lvl");
                    String name = "";
                    Enchantment enchantment = (Enchantment)Registry.f_122825_.m_7745_(ResourceLocation.m_135820_((String)id));
                    if (enchantment != null) {
                        name = enchantment.m_44700_((int)lvl).getString();
                    }
                    if (i > 0) {
                        lineBuilder.append(", ");
                    }
                    ArmorStatusCachedComponents.translateEchant(lineBuilder, name, count);
                }
                String labelString = lineBuilder.toString();
                return new TextComponent(labelString).m_130938_(style -> style.m_178520_(color));
            });
        }
    }
}

