/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.radar.icon.creator;

import com.mojang.blaze3d.ProjectionType;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.AddressMode;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.textures.TextureFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.CachedOrthoProjectionMatrixBuffer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.LivingEntityRenderState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import xaero.common.exception.OpenGLException;
import xaero.common.graphics.ImprovedFramebuffer;
import xaero.common.icon.XaeroIcon;
import xaero.common.icon.XaeroIconAtlas;
import xaero.common.icon.XaeroIconAtlasManager;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.hud.compat.mods.ImmediatelyFastHelper;
import xaero.hud.minimap.MinimapLogs;
import xaero.hud.minimap.element.render.MinimapElementGraphics;
import xaero.hud.minimap.radar.icon.RadarIconManager;
import xaero.hud.minimap.radar.icon.creator.render.form.IRadarIconFormPrerenderer;
import xaero.hud.minimap.radar.icon.creator.render.trace.EntityRenderTracer;
import xaero.hud.minimap.radar.icon.creator.render.trace.ModelRenderTrace;
import xaero.hud.minimap.radar.icon.definition.form.RadarIconForm;
import xaero.hud.minimap.radar.icon.definition.form.model.config.RadarIconModelConfig;
import xaero.lib.client.graphics.XaeroRenderType;
import xaero.lib.client.graphics.shader.PositionTexAlphaTestShaderHelper;
import xaero.lib.client.graphics.util.ImmediateRenderUtil;
import xaero.lib.client.graphics.util.TextureUtils;

public class RadarIconCreator {
    private static final int PREFERRED_ATLAS_WIDTH = 1024;
    public static final int ICON_WIDTH = 64;
    public static final int FAR_PLANE = 500;
    private ImprovedFramebuffer formRenderFramebuffer;
    private ImprovedFramebuffer iconRenderFramebuffer;
    private ImprovedFramebuffer atlasRenderFramebuffer;
    private final EntityRenderTracer renderTracer = new EntityRenderTracer();
    private final XaeroIconAtlasManager iconAtlasManager;
    private GpuBufferSlice projectionMatrixBackup;
    private ProjectionType projectionTypeBackup;
    private final CachedOrthoProjectionMatrixBuffer iconOrthoProjectionCache;
    private final CachedOrthoProjectionMatrixBuffer atlasOrthoProjectionCache;

    public RadarIconCreator() {
        int maxTextureSize = RenderSystem.getDevice().getMaxTextureSize();
        int atlasTextureSize = Math.min(maxTextureSize, 1024) / 64 * 64;
        this.iconAtlasManager = new XaeroIconAtlasManager(64, atlasTextureSize, new ArrayList<XaeroIconAtlas>());
        this.initFramebuffers(atlasTextureSize);
        this.iconOrthoProjectionCache = new CachedOrthoProjectionMatrixBuffer("icon creator ortho", -1.0f, 500.0f, true);
        this.atlasOrthoProjectionCache = new CachedOrthoProjectionMatrixBuffer("icon creator atlas ortho", -1.0f, 500.0f, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S extends EntityRenderState> XaeroIcon create(MinimapElementGraphics guiGraphics, EntityRenderer<?, ? super S> entityRenderer, S entityRenderState, Entity entity, RenderTarget defaultFramebuffer, Parameters parameters) {
        IRadarIconFormPrerenderer formPrerenderer = parameters.form.getPrerenderer();
        if (formPrerenderer == null) {
            MinimapLogs.LOGGER.error("Tried prerendering radar icon for {} variant {} but the icon form used doesn't have a prerenderer!", (Object)EntityType.getKey((EntityType)entity.getType()), parameters.variant);
            return RadarIconManager.FAILED;
        }
        OpenGLException.checkGLError();
        PoseStack matrixStack = guiGraphics.pose();
        guiGraphics.flush();
        ImmediatelyFastHelper.triggerBatchingBuffersFlush(matrixStack);
        this.formRenderFramebuffer.bindAsMainTarget(true);
        this.setupMatrices(matrixStack, 64, 500);
        OpenGLException.checkGLError();
        if (entityRenderState instanceof LivingEntityRenderState) {
            LivingEntityRenderState livingEntityRenderState = (LivingEntityRenderState)entityRenderState;
            livingEntityRenderState.isBaby = false;
        }
        List<ModelRenderTrace> traceResult = null;
        EntityModel<? super S> entityModel = null;
        if (formPrerenderer.requiresEntityModel()) {
            if (Minecraft.getInstance().getEntityRenderDispatcher().camera != null) {
                traceResult = this.renderTracer.trace(matrixStack, entity, entityRenderer, entityRenderState);
                this.formRenderFramebuffer.bindAsMainTarget(true);
            } else {
                MinimapLogs.LOGGER.info("Render info was null for entity " + entity.getScoreboardName());
            }
            entityModel = this.renderTracer.getEntityRendererModel(entityRenderer);
            if (entityModel == null) {
                this.endFormRendering();
                this.bindDefaultFramebuffer(defaultFramebuffer);
                this.restoreMatrices(matrixStack);
                return RadarIconManager.FAILED;
            }
        }
        boolean formRenderResult = false;
        PoseStack.Pose matrixEntryToRestore = matrixStack.last();
        matrixStack.pushPose();
        try {
            TextureUtils.clearRenderTarget((RenderTarget)this.formRenderFramebuffer, (int)0, (float)1.0f);
            formRenderResult = formPrerenderer.prerender(guiGraphics, entityRenderer, entityRenderState, entityModel, entity, traceResult, parameters);
        }
        catch (Throwable t) {
            MinimapLogs.LOGGER.error("Exception using the radar icon form prerenderer for entity {} variant {}!", (Object)EntityType.getKey((EntityType)entity.getType()), parameters.variant, (Object)t);
        }
        finally {
            guiGraphics.flush();
            while (matrixStack.last() != matrixEntryToRestore) {
                matrixStack.popPose();
            }
        }
        this.endFormRendering();
        XaeroIcon icon = parameters.form.getFailureResult();
        if (formRenderResult) {
            icon = this.getFinalIcon(matrixStack, entity, formPrerenderer, parameters);
        }
        this.restoreMatrices(matrixStack);
        this.bindDefaultFramebuffer(defaultFramebuffer);
        return icon;
    }

    private XaeroIcon getFinalIcon(PoseStack matrixStack, Entity entity, IRadarIconFormPrerenderer formPrerenderer, Parameters parameters) {
        this.iconRenderFramebuffer.bindAsMainTarget(true);
        TextureUtils.clearRenderTarget((RenderTarget)this.iconRenderFramebuffer, (int)0, (float)1.0f);
        if (parameters.debug) {
            matrixStack.pushPose();
            matrixStack.translate(18.0f, 10.0f, -10.0f);
            matrixStack.scale(1.0f, 1.0f, 1.0f);
            ImmediateRenderUtil.coloredRectangle((PoseStack)matrixStack, (float)0.0f, (float)0.0f, (float)9.0f, (float)9.0f, (int)-16776961);
            matrixStack.popPose();
        }
        this.formRenderFramebuffer.bindRead();
        boolean outlined = formPrerenderer.isOutlined();
        boolean flipped = formPrerenderer.isFlipped();
        if (outlined) {
            this.renderOutline(matrixStack);
        }
        ImmediateRenderUtil.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        PositionTexAlphaTestShaderHelper.setDiscardAlpha((float)0.05f);
        ImmediateRenderUtil.texturedRect((PoseStack)matrixStack, (float)0.0f, (float)0.0f, (int)0, (int)0, (float)64.0f, (float)64.0f, (float)64.0f, (float)64.0f, (RenderPipeline)XaeroRenderType.RP_POSITION_TEX_ALPHA_NO_BLEND);
        if (parameters.debug) {
            matrixStack.pushPose();
            matrixStack.translate(27.0f, 10.0f, -10.0f);
            matrixStack.scale(1.0f, 1.0f, 1.0f);
            ImmediateRenderUtil.coloredRectangle((PoseStack)matrixStack, (float)0.0f, (float)0.0f, (float)9.0f, (float)9.0f, (int)-16711681);
            matrixStack.popPose();
        }
        this.iconRenderFramebuffer.bindRead();
        this.iconRenderFramebuffer.generateMipmaps();
        XaeroIcon icon = null;
        try {
            XaeroIconAtlas atlas = this.getCurrentAtlas();
            icon = atlas.createIcon();
            this.atlasRenderFramebuffer.bindAsMainTarget(false);
            TextureUtils.clearRenderTargetDepth((RenderTarget)this.atlasRenderFramebuffer, (float)1.0f);
            GpuBufferSlice ortho = this.atlasOrthoProjectionCache.getBuffer((float)this.atlasRenderFramebuffer.width, (float)this.atlasRenderFramebuffer.height);
            RenderSystem.setProjectionMatrix((GpuBufferSlice)ortho, (ProjectionType)ProjectionType.ORTHOGRAPHIC);
            matrixStack.translate((float)icon.getOffsetX(), (float)(this.atlasRenderFramebuffer.height - 64 - icon.getOffsetY()), 0.0f);
            this.atlasRenderFramebuffer.setColorTexture(atlas);
            this.iconRenderFramebuffer.bindRead();
            if (flipped) {
                ImmediateRenderUtil.texturedRect((PoseStack)matrixStack, (float)0.0f, (float)0.0f, (int)0, (int)64, (float)64.0f, (float)64.0f, (float)-64.0f, (float)64.0f, (RenderPipeline)XaeroRenderType.RP_POSITION_TEX_NO_ALPHA_NO_BLEND);
            } else {
                ImmediateRenderUtil.texturedRect((PoseStack)matrixStack, (float)0.0f, (float)0.0f, (int)0, (int)0, (float)64.0f, (float)64.0f, (float)64.0f, (float)64.0f, (RenderPipeline)XaeroRenderType.RP_POSITION_TEX_NO_ALPHA_NO_BLEND);
            }
            if (parameters.debug) {
                matrixStack.pushPose();
                matrixStack.translate(36.0f, 10.0f, -10.0f);
                matrixStack.scale(1.0f, 1.0f, 1.0f);
                ImmediateRenderUtil.coloredRectangle((PoseStack)matrixStack, (float)0.0f, (float)0.0f, (float)9.0f, (float)9.0f, (int)-256);
                matrixStack.popPose();
            }
        }
        catch (Throwable t) {
            MinimapLogs.LOGGER.error("Exception rendering to a entity icon atlas for {} {}!", (Object)EntityType.getKey((EntityType)entity.getType()), parameters.variant, (Object)t);
        }
        MinimapRendererHelper.restoreDefaultShaderBlendState();
        return icon;
    }

    private void renderOutline(PoseStack matrixStack) {
        ImmediateRenderUtil.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        for (int shadowOffsetX = -1; shadowOffsetX < 2; ++shadowOffsetX) {
            for (int shadowOffsetY = -1; shadowOffsetY < 2; ++shadowOffsetY) {
                if (shadowOffsetX == 0 && shadowOffsetY == 0) continue;
                ImmediateRenderUtil.drawOutlineLayer((PoseStack)matrixStack, (float)shadowOffsetX, (float)shadowOffsetY, (int)0, (int)0, (float)64.0f, (float)64.0f, (float)64.0f, (float)64.0f, (float)0.05f);
            }
        }
    }

    private void setupMatrices(PoseStack matrixStack, int finalIconSize, int farPlane) {
        this.projectionMatrixBackup = RenderSystem.getProjectionMatrixBuffer();
        this.projectionTypeBackup = RenderSystem.getProjectionType();
        matrixStack.pushPose();
        matrixStack.setIdentity();
        GpuBufferSlice ortho = this.iconOrthoProjectionCache.getBuffer((float)finalIconSize, (float)finalIconSize);
        RenderSystem.setProjectionMatrix((GpuBufferSlice)ortho, (ProjectionType)ProjectionType.ORTHOGRAPHIC);
        RenderSystem.getModelViewStack().pushMatrix();
        RenderSystem.getModelViewStack().identity();
    }

    private void restoreMatrices(PoseStack matrixStack) {
        matrixStack.popPose();
        RenderSystem.setProjectionMatrix((GpuBufferSlice)this.projectionMatrixBackup, (ProjectionType)this.projectionTypeBackup);
        RenderSystem.getModelViewStack().popMatrix();
    }

    private void endFormRendering() {
        Minecraft.getInstance().gameRenderer.getLighting().setupFor(Lighting.Entry.ITEMS_FLAT);
    }

    private void bindDefaultFramebuffer(RenderTarget defaultFramebuffer) {
        if (defaultFramebuffer != null) {
            if (defaultFramebuffer instanceof ImprovedFramebuffer) {
                ((ImprovedFramebuffer)defaultFramebuffer).bindAsMainTarget(true);
                return;
            }
            ImprovedFramebuffer.restoreMainRenderTarget();
            return;
        }
        this.atlasRenderFramebuffer.bindDefaultFramebuffer(Minecraft.getInstance());
    }

    public void reset() {
        this.iconAtlasManager.clearAtlases();
        this.atlasRenderFramebuffer.setColorTexture(null, null);
        this.renderTracer.reset();
    }

    public EntityRenderTracer getRenderTracer() {
        return this.renderTracer;
    }

    private XaeroIconAtlas getCurrentAtlas() {
        return this.iconAtlasManager.getCurrentAtlas();
    }

    private void initFramebuffers(int atlasTextureSize) {
        this.formRenderFramebuffer = new ImprovedFramebuffer(512, 512, true);
        this.iconRenderFramebuffer = new ImprovedFramebuffer(512, 512, true);
        this.formRenderFramebuffer.getColorTexture().setTextureFilter(FilterMode.NEAREST, false);
        this.formRenderFramebuffer.getColorTexture().setAddressMode(AddressMode.CLAMP_TO_EDGE);
        String iconRenderColorTextureName = this.iconRenderFramebuffer.getColorTexture().getLabel();
        this.iconRenderFramebuffer.closeColorTexture();
        GpuTexture iconRenderColorTexture = RenderSystem.getDevice().createTexture(iconRenderColorTextureName, 15, TextureFormat.RGBA8, 512, 512, 1, 4);
        iconRenderColorTexture.setTextureFilter(FilterMode.NEAREST, true);
        iconRenderColorTexture.setAddressMode(AddressMode.CLAMP_TO_EDGE);
        GpuTextureView iconRenderColorTextureView = RenderSystem.getDevice().createTextureView(iconRenderColorTexture);
        this.iconRenderFramebuffer.setColorTexture(iconRenderColorTexture, iconRenderColorTextureView);
        this.atlasRenderFramebuffer = new ImprovedFramebuffer(atlasTextureSize, atlasTextureSize, true);
        this.atlasRenderFramebuffer.closeColorTexture();
        this.atlasRenderFramebuffer.setColorTexture(null, null);
    }

    public static class Parameters {
        public final Object variant;
        public final float scale;
        public final RadarIconModelConfig defaultModelConfig;
        public final RadarIconForm form;
        public final boolean debug;

        public Parameters(Object variant, RadarIconModelConfig defaultModelConfig, RadarIconForm form, float scale, boolean debug) {
            this.variant = variant;
            this.scale = scale;
            this.defaultModelConfig = defaultModelConfig;
            this.form = form;
            this.debug = debug;
        }
    }
}

