/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.pvp.module.effect;

import com.google.common.collect.Ordering;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collection;
import net.minecraft.class_1058;
import net.minecraft.class_1074;
import net.minecraft.class_1291;
import net.minecraft.class_1292;
import net.minecraft.class_1293;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4074;
import net.minecraft.class_4493;
import net.minecraft.class_4587;
import xaero.hud.pvp.module.effect.StatusEffectSession;
import xaero.hud.render.module.IModuleRenderer;
import xaero.hud.render.module.ModuleRenderContext;

public class StatusEffectRenderer
implements IModuleRenderer<StatusEffectSession> {
    @Override
    public void render(StatusEffectSession session, ModuleRenderContext c, class_4587 matrixStack, float partialTicks) {
        class_310 mc = class_310.method_1551();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        class_4493.method_22021();
        if (!mc.field_1724.method_6026().isEmpty()) {
            this.renderEffects(session, matrixStack, c, mc);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private void renderEffects(StatusEffectSession session, class_4587 matrixStack, ModuleRenderContext c, class_310 mc) {
        Collection effects;
        if (c.flippedVertically) {
            c.y = c.y + c.h - 30;
        }
        if ((effects = mc.field_1724.method_6026()).isEmpty()) {
            return;
        }
        effects = Ordering.natural().sortedCopy((Iterable)effects);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableLighting();
        RenderSystem.enableBlend();
        if (session.isBlinkEnabled() && System.currentTimeMillis() - session.getLastBlink() > 500L) {
            session.setLastBlink(System.currentTimeMillis());
            session.setBlink(!session.getBlink());
        }
        if (session.isCentered()) {
            this.renderCentered(session, matrixStack, c, mc, effects);
            return;
        }
        this.renderNormal(session, matrixStack, c, mc, effects);
    }

    private void renderCentered(StatusEffectSession session, class_4587 matrixStack, ModuleRenderContext c, class_310 mc, Collection<class_1293> effects) {
        class_4074 potionspriteuploader = mc.method_18505();
        int columnWidth = 27;
        int defaultEffectAmount = 182 / columnWidth;
        if (effects.size() > defaultEffectAmount) {
            columnWidth = 182 / effects.size();
        }
        int totalSize = effects.size() * columnWidth;
        int firstColumn = c.x + c.w / 2 + totalSize / 2 * (c.flippedHorizontally ? 1 : -1);
        if (c.flippedHorizontally) {
            firstColumn -= columnWidth;
        }
        int currentX = firstColumn + (columnWidth - 18) / 2;
        int currentY = c.y + 7;
        for (class_1293 effectInstance : effects) {
            int duration = effectInstance.method_5584();
            if (duration <= 200 && !session.getBlink() && session.isBlinkEnabled()) {
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.2f);
            } else {
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            class_1291 effect = effectInstance.method_5579();
            class_1058 effectSprite = potionspriteuploader.method_18663(effect);
            if (effectSprite != null) {
                mc.method_1531().method_22813(effectSprite.method_24119().method_24106());
                class_332.method_25298((class_4587)matrixStack, (int)currentX, (int)currentY, (int)0, (int)18, (int)18, (class_1058)effectSprite);
            }
            String durationString = class_1292.method_5577((class_1293)effectInstance, (float)1.0f);
            int amplifier = effectInstance.method_5578();
            String levelString = amplifier > 0 ? "" + (effectInstance.method_5578() + 1) : "";
            class_332.method_25303((class_4587)matrixStack, (class_327)mc.field_1772, (String)levelString, (int)currentX, (int)currentY, (int)0xFFFFFF);
            class_332.method_25303((class_4587)matrixStack, (class_327)mc.field_1772, (String)durationString, (int)(currentX + 10 - mc.field_1772.method_1727(durationString) / 2), (int)(currentY + 15), (int)0xFFFFFF);
            RenderSystem.enableBlend();
            currentX += columnWidth * (c.flippedHorizontally ? -1 : 1);
        }
    }

    private void renderNormal(StatusEffectSession session, class_4587 matrixStack, ModuleRenderContext c, class_310 mc, Collection<class_1293> effects) {
        int rowHeight = 25;
        if (effects.size() > 6) {
            rowHeight = 135 / (effects.size() - 1);
        }
        class_4074 potionspriteuploader = mc.method_18505();
        for (class_1293 effectInstance : effects) {
            String potionName;
            int duration = effectInstance.method_5584();
            if (duration <= 200 && !session.getBlink() && session.isBlinkEnabled()) {
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.2f);
            } else {
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            class_1291 effect = effectInstance.method_5579();
            class_1058 effectSprite = potionspriteuploader.method_18663(effect);
            if (effectSprite != null) {
                mc.method_1531().method_22813(effectSprite.method_24119().method_24106());
                class_332.method_25298((class_4587)matrixStack, (int)(c.flippedHorizontally ? c.x + c.w - 24 : c.x + 6), (int)(c.y + 7), (int)0, (int)18, (int)18, (class_1058)effectSprite);
            }
            String durationString = class_1292.method_5577((class_1293)effectInstance, (float)1.0f);
            if (!session.shouldShowNames()) {
                potionName = durationString;
                durationString = null;
            } else {
                potionName = class_1074.method_4662((String)effect.method_5567(), (Object[])new Object[0]);
                if (effectInstance.method_5578() >= 1 && effectInstance.method_5578() <= 9) {
                    potionName = potionName + ' ' + class_1074.method_4662((String)("enchantment.level." + (effectInstance.method_5578() + 1)), (Object[])new Object[0]);
                }
            }
            int amplifier = effectInstance.method_5578();
            String levelString = amplifier > 0 ? "" + (effectInstance.method_5578() + 1) : "";
            class_332.method_25303((class_4587)matrixStack, (class_327)mc.field_1772, (String)levelString, (int)(c.flippedHorizontally ? c.x + c.w - 24 : c.x + 6), (int)(c.y + 7), (int)0xFFFFFF);
            class_332.method_25303((class_4587)matrixStack, (class_327)mc.field_1772, (String)potionName, (int)(c.flippedHorizontally ? c.x + c.w - 28 - mc.field_1772.method_1727(potionName) : c.x + 10 + 18), (int)(c.y + 7), (int)0xFFFFFF);
            if (durationString != null) {
                class_332.method_25303((class_4587)matrixStack, (class_327)mc.field_1772, (String)durationString, (int)(c.flippedHorizontally ? c.x + c.w - 28 - mc.field_1772.method_1727(durationString) : c.x + 10 + 18), (int)(c.y + 7 + 10), (int)0xFFFFFF);
            }
            RenderSystem.enableBlend();
            c.y = c.y + (c.flippedVertically ? -rowHeight : rowHeight);
        }
    }
}

