/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.pvp.module.entityinfo;

import com.google.common.collect.Ordering;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collection;
import java.util.Random;
import net.minecraft.class_1058;
import net.minecraft.class_1160;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_327;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3966;
import net.minecraft.class_4074;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5134;
import net.minecraft.class_898;
import xaero.common.misc.Misc;
import xaero.hud.pvp.module.entityinfo.EntityInfoSession;
import xaero.hud.render.module.IModuleRenderer;
import xaero.hud.render.module.ModuleRenderContext;
import xaero.pvp.BetterPVP;

public class EntityInfoRenderer
implements IModuleRenderer<EntityInfoSession> {
    private final Random random = new Random();

    @Override
    public void render(EntityInfoSession session, ModuleRenderContext c, class_4587 matrixStack, float partialTicks) {
        class_1309 displayedEntity;
        class_310 mc = class_310.method_1551();
        long time = System.currentTimeMillis();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        class_3966 objectMouseOver = session.getDetector().getMouseOver(mc, (class_1937)mc.field_1687, session.getEntityInfoDistance(), partialTicks);
        if (objectMouseOver != null && objectMouseOver.method_17782() instanceof class_1309) {
            class_3218 serverWorld;
            session.setDisplayedEntity((class_1309)objectMouseOver.method_17782());
            if (mc.method_1576() != null && (serverWorld = mc.method_1576().method_3847(mc.field_1687.method_27983())) != null) {
                session.setDisplayedServerEntity((class_1309)serverWorld.method_14190(objectMouseOver.method_17782().method_5667()));
            }
            session.setLastDetection(time);
        }
        if ((displayedEntity = session.getDisplayedEntity()) == null) {
            return;
        }
        if (time - session.getLastDetection() > 1000L * (long)session.getEntityInfoStay()) {
            return;
        }
        if (System.currentTimeMillis() - session.getLastEffectBlink() > 500L) {
            session.setLastEffectBlink(System.currentTimeMillis());
            session.setEffectBlink(!session.getEffectBlink());
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        try {
            int healthOff;
            boolean flippedVer = c.flippedVertically;
            boolean flippedHor = c.flippedHorizontally;
            float resize = 1.0f;
            if (displayedEntity.method_17681() > resize) {
                resize = displayedEntity.method_17681();
            }
            if (displayedEntity.method_17682() > resize * 2.0f) {
                resize = displayedEntity.method_17682() / 2.0f;
            }
            if (session.getEntityInfoShowEntityModel()) {
                RenderSystem.translatef((float)0.0f, (float)0.0f, (float)-500.0f);
                RenderSystem.enableDepthTest();
                this.drawEntityOnScreen(mc, c.x + (flippedHor ? c.w - 25 : 25), c.y + 35, (int)(30.0f / resize), displayedEntity, flippedHor);
                RenderSystem.disableDepthTest();
                RenderSystem.translatef((float)0.0f, (float)0.0f, (float)500.0f);
            }
            class_1309 displayedServerEntity = session.getDisplayedServerEntity();
            int n = healthOff = session.getEntityInfoShowEntityModel() ? 55 : 5;
            if (mc.method_1576() != null && session.getEntityInfoEffects() && displayedServerEntity != null) {
                int effectsOffset = (int)this.drawPotionEffects(mc, matrixStack, session, displayedServerEntity, c.x + (flippedHor ? c.w - 3 : 3), c.y + (flippedVer ? c.h - 5 : 5), flippedVer ? c.y + c.h : c.screenHeight - c.y, flippedHor, flippedVer, c.screenScale);
                if (!session.getEntityInfoShowEntityModel() && effectsOffset != -1) {
                    healthOff += 3 + effectsOffset;
                }
            }
            boolean renderedArmor = session.getEntityInfoShowArmour() && this.drawArmourBar(mc, matrixStack, session, displayedEntity, c.x + (flippedHor ? c.w - healthOff : healthOff), c.y + 15 + (flippedVer ? 31 : 0), flippedHor);
            this.drawHealthBar(mc, matrixStack, session, displayedEntity, c.x + (flippedHor ? c.w - healthOff : healthOff), c.y + 15 + (flippedVer ? 31 : 0) + (renderedArmor ? 10 : 0) * (flippedVer ? -1 : 1), flippedHor, flippedVer);
            class_2561 component = Misc.getFixedDisplayName((class_1297)displayedEntity);
            if (component != null) {
                String name = component.getString();
                int xCoord = c.x + (flippedHor ? c.w - healthOff - mc.field_1772.method_1727(name) : healthOff);
                class_332.method_25303((class_4587)matrixStack, (class_327)mc.field_1772, (String)name, (int)xCoord, (int)(c.y + 5 + (flippedVer ? 52 : 0)), (int)0xFFFFFF);
            }
        }
        catch (Exception e) {
            BetterPVP.LOGGER.error("Please report this to Xaero96 on PlanetMinecraft/MinecraftForums/CurseForge!", (Throwable)e);
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawEntityOnScreen(class_310 mc, int x, int y, int scale, class_1309 entity, boolean flip) {
        double cos;
        if (entity == null) {
            return;
        }
        class_898 rendermanager = mc.method_1561();
        if (rendermanager.field_4686 == null) {
            return;
        }
        float yBodyRotBU = entity.field_6283;
        float yRotBU = entity.field_6031;
        float yHeadRotBU = entity.field_6241;
        entity.field_6283 = 0.0f;
        entity.field_6031 = 0.0f;
        entity.field_6241 = yHeadRotBU - yBodyRotBU;
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)x, (float)y, (float)50.0f);
        RenderSystem.scaled((double)(-scale), (double)scale, (double)scale);
        RenderSystem.rotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        class_4587 matrixStack = new class_4587();
        matrixStack.method_22907(class_1160.field_20703.method_23214(30.0f));
        float width = entity.method_17681() * (float)scale / 30.0f;
        if (width < 1.0f) {
            width = 1.0f;
        }
        if ((cos = Math.sqrt(2.0) / 2.0 / (double)width) > 1.0) {
            cos = 1.0;
        }
        float rotation = (float)Math.toDegrees(Math.acos(cos));
        matrixStack.method_22907(class_1160.field_20705.method_23214(flip ? -rotation : rotation));
        matrixStack.method_22904(0.0, (double)(-entity.method_17682() / 2.0f), 0.0);
        rendermanager.method_3948(false);
        boolean hideGUIBU = mc.field_1690.field_1842;
        mc.field_1690.field_1842 = true;
        try {
            RenderSystem.enableRescaleNormal();
            class_4597.class_4598 irendertypebuffer$impl = class_310.method_1551().method_22940().method_23000();
            rendermanager.method_3954((class_1297)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, matrixStack, (class_4597)irendertypebuffer$impl, 0xF000F0);
            irendertypebuffer$impl.method_22993();
        }
        finally {
            mc.field_1690.field_1842 = hideGUIBU;
            rendermanager.method_3948(true);
            RenderSystem.disableBlend();
            entity.field_6283 = yBodyRotBU;
            entity.field_6031 = yRotBU;
            entity.field_6241 = yHeadRotBU;
            RenderSystem.popMatrix();
        }
    }

    public boolean drawArmourBar(class_310 mc, class_4587 matrixStack, EntityInfoSession session, class_1309 e, int x, int y, boolean flip) {
        int armorValue = e.method_6096();
        mc.method_1531().method_22813(class_329.field_22737);
        if (armorValue > 0) {
            if (session.getEntityInfoArmourNumbers()) {
                mc.field_1705.method_25302(matrixStack, x - (flip ? 8 : 0), y, 34, 9, 9, 9);
                class_332.method_25303((class_4587)matrixStack, (class_327)mc.field_1772, (String)(armorValue + "/20"), (int)(x + (flip ? -11 - mc.field_1772.method_1727(armorValue + "/20") : 11)), (int)y, (int)0xFFFFFF);
            } else {
                for (int iconIndex = 0; iconIndex < 10; ++iconIndex) {
                    int iconX = x + (flip ? -8 - iconIndex * 8 : iconIndex * 8);
                    if (iconIndex * 2 + 1 < armorValue) {
                        mc.field_1705.method_25302(matrixStack, iconX, y, 34, 9, 9, 9);
                        continue;
                    }
                    if (iconIndex * 2 + 1 == armorValue) {
                        mc.field_1705.method_25302(matrixStack, iconX, y, 25, 9, 9, 9);
                        continue;
                    }
                    if (iconIndex * 2 + 1 <= armorValue) continue;
                    mc.field_1705.method_25302(matrixStack, iconX, y, 16, 9, 9, 9);
                }
            }
            return true;
        }
        return false;
    }

    public void drawHealthBar(class_310 mc, class_4587 matrixStack, EntityInfoSession session, class_1309 e, int x, int y, boolean flip, boolean vertFlipped) {
        int health = class_3532.method_15386((float)e.method_6032());
        float maxHealth = class_3532.method_15384((double)e.method_26825(class_5134.field_23716));
        float absorptionAmount = class_3532.method_15386((float)e.method_6067());
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (session.getEntityInfoHealthNumbers()) {
            String text = health + "/" + (int)maxHealth;
            if (absorptionAmount > 0.0f) {
                text = text + "+" + absorptionAmount;
                health = 0;
                maxHealth = 0.0f;
                absorptionAmount = 2.0f;
            } else {
                health = 2;
                maxHealth = 2.0f;
                absorptionAmount = 0.0f;
            }
            class_332.method_25303((class_4587)matrixStack, (class_327)mc.field_1772, (String)text, (int)(x + (flip ? -11 - mc.field_1772.method_1727(text) : 11)), (int)y, (int)-1);
        }
        RenderSystem.enableBlend();
        mc.method_1531().method_22813(class_329.field_22737);
        int regularHalvesToRender = (int)(maxHealth + 1.0f) / 2 * 2;
        int regularFilledHalves = health;
        int absorptionHalvesToRender = (int)(absorptionAmount + 1.0f) / 2 * 2;
        int absorptionFilledHalves = (int)absorptionAmount;
        int limit = (int)session.getEntityInfoMaxHearts() * 2;
        if (regularHalvesToRender > limit) {
            regularHalvesToRender = limit;
            int n = regularFilledHalves = maxHealth == 0.0f ? 0 : Math.round((float)(health * regularHalvesToRender) / maxHealth);
        }
        if (absorptionHalvesToRender > limit) {
            absorptionHalvesToRender = absorptionFilledHalves = limit;
        }
        int totalHalvesToRender = regularHalvesToRender + absorptionHalvesToRender;
        int rows = class_3532.method_15386((float)((float)totalHalvesToRender / 20.0f));
        int rowStep = Math.max(10 - (rows - 2), 3);
        boolean shake = maxHealth != 0.0f && (double)health <= (double)maxHealth * 0.4;
        int absorptionLeft = absorptionFilledHalves;
        for (int heartIndex = totalHalvesToRender / 2 - 1; heartIndex >= 0; --heartIndex) {
            int rowIndex = (int)Math.ceil((float)(heartIndex + 1) / 10.0f) - 1;
            int xcoord = heartIndex % 10 * 8;
            int heartX = x + (flip ? -xcoord - 9 : xcoord);
            int heartY = y + rowIndex * rowStep * (vertFlipped ? -1 : 1);
            if (shake) {
                heartY += this.random.nextInt(2);
            }
            this.blitFlippable(heartX, heartY, 25, 0, 9, 9, flip);
            if (absorptionLeft > 0) {
                if (absorptionLeft == absorptionFilledHalves && absorptionFilledHalves % 2 == 1) {
                    this.blitFlippable(heartX, heartY, 169, 0, 9, 9, flip);
                } else {
                    this.blitFlippable(heartX, heartY, 160, 0, 9, 9, flip);
                }
                absorptionLeft -= 2;
                continue;
            }
            if (heartIndex * 2 + 1 < regularFilledHalves) {
                this.blitFlippable(heartX, heartY, 52, 0, 9, 9, flip);
            }
            if (heartIndex * 2 + 1 != regularFilledHalves) continue;
            this.blitFlippable(heartX, heartY, 61, 0, 9, 9, flip);
        }
        RenderSystem.disableBlend();
    }

    public double drawPotionEffects(class_310 mc, class_4587 matrixStack, EntityInfoSession session, class_1309 e, int x, int y, int h, boolean flippedHor, boolean flippedVer, double scale) {
        Collection effects = e.method_6026();
        if (effects.isEmpty()) {
            return -1.0;
        }
        effects = Ordering.natural().sortedCopy((Iterable)effects);
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)x, (float)y, (float)0.0f);
        RenderSystem.enableBlend();
        class_4074 effectSprites = mc.method_18505();
        double pixelSize = (double)session.getEntityInfoEffectsScale() / scale * session.getAutoUIScale() / 2.0;
        double effectSize = 25.0 * pixelSize;
        int perColumn = (int)((double)h / effectSize);
        int place = 0;
        for (class_1293 pe : effects) {
            class_1058 sprite;
            if (pe == null || (sprite = effectSprites.method_18663(pe.method_5579())) == null) continue;
            RenderSystem.pushMatrix();
            RenderSystem.scaled((double)pixelSize, (double)pixelSize, (double)1.0);
            int column = place / perColumn;
            int row = place % perColumn;
            RenderSystem.translatef((float)(flippedHor ? (float)(-18 - 25 * column) : (float)(25 * column)), (float)(flippedVer ? (float)(-18 - 25 * row) : (float)(25 * row)), (float)0.0f);
            if (pe.method_5584() <= 200 && !session.getEffectBlink()) {
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.4f);
            }
            mc.method_1531().method_22813(sprite.method_24119().method_24106());
            class_332.method_25298((class_4587)matrixStack, (int)0, (int)0, (int)0, (int)18, (int)18, (class_1058)sprite);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            ++place;
            RenderSystem.popMatrix();
        }
        RenderSystem.popMatrix();
        int rows = (effects.size() + perColumn - 1) / perColumn;
        return effectSize * (double)rows - 7.0 * pixelSize;
    }

    public void blitFlippable(int x, int y, int textureX, int textureY, int width, int height, boolean flip) {
        class_289 tessellator = class_289.method_1348();
        class_287 vertexbuffer = tessellator.method_1349();
        vertexbuffer.method_1328(7, class_290.field_1585);
        vertexbuffer.method_22912((double)(x + 0), (double)(y + height), 0.0).method_22913((float)(textureX + (flip ? width : 0)) * 0.00390625f, (float)(textureY + height) * 0.00390625f).method_1344();
        vertexbuffer.method_22912((double)(x + width), (double)(y + height), 0.0).method_22913((float)(textureX + (flip ? 0 : width)) * 0.00390625f, (float)(textureY + height) * 0.00390625f).method_1344();
        vertexbuffer.method_22912((double)(x + width), (double)(y + 0), 0.0).method_22913((float)(textureX + (flip ? 0 : width)) * 0.00390625f, (float)(textureY + 0) * 0.00390625f).method_1344();
        vertexbuffer.method_22912((double)(x + 0), (double)(y + 0), 0.0).method_22913((float)(textureX + (flip ? width : 0)) * 0.00390625f, (float)(textureY + 0) * 0.00390625f).method_1344();
        tessellator.method_1350();
    }
}

