/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.pvp.module.entityinfo;

import com.google.common.collect.Ordering;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collection;
import java.util.Random;
import net.minecraft.class_10142;
import net.minecraft.class_10156;
import net.minecraft.class_1058;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3966;
import net.minecraft.class_4074;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5134;
import net.minecraft.class_5365;
import net.minecraft.class_898;
import net.minecraft.class_9801;
import org.joml.Matrix4f;
import org.joml.Vector3fc;
import xaero.common.misc.Misc;
import xaero.common.misc.OptimizedMath;
import xaero.hud.pvp.module.entityinfo.EntityInfoSession;
import xaero.hud.render.module.IModuleRenderer;
import xaero.hud.render.module.ModuleRenderContext;
import xaero.pvp.BetterPVP;

public class EntityInfoRenderer
implements IModuleRenderer<EntityInfoSession> {
    public static final class_2960 HEART_CONTANER = class_2960.method_60654((String)"hud/heart/container_blinking");
    public static final class_2960 NORMAL_HEART_FULL = class_2960.method_60654((String)"hud/heart/full");
    public static final class_2960 NORMAL_HEART_HALF = class_2960.method_60654((String)"hud/heart/half");
    public static final class_2960 ABSORBING_HEART_FULL = class_2960.method_60654((String)"hud/heart/absorbing_full");
    public static final class_2960 ABSORBING_HEART_HALF = class_2960.method_60654((String)"hud/heart/absorbing_half");
    public static final class_2960 ARMOR_EMPTY = class_2960.method_60654((String)"hud/armor_empty");
    public static final class_2960 ARMOR_HALF = class_2960.method_60654((String)"hud/armor_half");
    public static final class_2960 ARMOR_FULL = class_2960.method_60654((String)"hud/armor_full");
    private final Random random = new Random();

    @Override
    public void render(EntityInfoSession session, ModuleRenderContext c, class_332 guiGraphics, float partialTicks) {
        class_1309 displayedEntity;
        class_310 mc = class_310.method_1551();
        long time = System.currentTimeMillis();
        class_3966 objectMouseOver = session.getDetector().getMouseOver(mc, (class_1937)mc.field_1687, session.getEntityInfoDistance(), partialTicks);
        if (objectMouseOver != null && objectMouseOver.method_17782() instanceof class_1309) {
            class_3218 serverWorld;
            session.setDisplayedEntity((class_1309)objectMouseOver.method_17782());
            if (mc.method_1576() != null && (serverWorld = mc.method_1576().method_3847(mc.field_1687.method_27983())) != null) {
                session.setDisplayedServerEntity((class_1309)serverWorld.method_14190(objectMouseOver.method_17782().method_5667()));
            }
            session.setLastDetection(time);
        }
        if ((displayedEntity = session.getDisplayedEntity()) == null) {
            return;
        }
        if (time - session.getLastDetection() > 1000L * (long)session.getEntityInfoStay()) {
            return;
        }
        if (System.currentTimeMillis() - session.getLastEffectBlink() > 500L) {
            session.setLastEffectBlink(System.currentTimeMillis());
            session.setEffectBlink(!session.getEffectBlink());
        }
        class_4587 matrixStack = guiGraphics.method_51448();
        try {
            int healthOff;
            boolean flippedVer = c.flippedVertically;
            boolean flippedHor = c.flippedHorizontally;
            float resize = 1.0f;
            if (displayedEntity.method_17681() > resize) {
                resize = displayedEntity.method_17681();
            }
            if (displayedEntity.method_17682() > resize * 2.0f) {
                resize = displayedEntity.method_17682() / 2.0f;
            }
            if (session.getEntityInfoShowEntityModel()) {
                matrixStack.method_46416(0.0f, 0.0f, -500.0f);
                RenderSystem.enableDepthTest();
                this.drawEntityOnScreen(mc, matrixStack, c.x + (flippedHor ? c.w - 25 : 25), c.y + 35, (int)(30.0f / resize), displayedEntity, flippedHor);
                RenderSystem.disableDepthTest();
                matrixStack.method_46416(0.0f, 0.0f, 500.0f);
            }
            class_1309 displayedServerEntity = session.getDisplayedServerEntity();
            int n = healthOff = session.getEntityInfoShowEntityModel() ? 55 : 5;
            if (mc.method_1576() != null && session.getEntityInfoEffects() && displayedServerEntity != null) {
                int effectsOffset = (int)this.drawPotionEffects(mc, guiGraphics, session, displayedServerEntity, c.x + (flippedHor ? c.w - 3 : 3), c.y + (flippedVer ? c.h - 5 : 5), flippedVer ? c.y + c.h : c.screenHeight - c.y, flippedHor, flippedVer, c.screenScale);
                if (!session.getEntityInfoShowEntityModel() && effectsOffset != -1) {
                    healthOff += 3 + effectsOffset;
                }
            }
            boolean renderedArmor = session.getEntityInfoShowArmour() && this.drawArmourBar(mc, guiGraphics, session, displayedEntity, c.x + (flippedHor ? c.w - healthOff : healthOff), c.y + 15 + (flippedVer ? 31 : 0), flippedHor);
            this.drawHealthBar(mc, guiGraphics, session, displayedEntity, c.x + (flippedHor ? c.w - healthOff : healthOff), c.y + 15 + (flippedVer ? 31 : 0) + (renderedArmor ? 10 : 0) * (flippedVer ? -1 : 1), flippedHor, flippedVer);
            class_2561 component = Misc.getFixedDisplayName((class_1297)displayedEntity);
            if (component != null) {
                String name = component.getString();
                int xCoord = c.x + (flippedHor ? c.w - healthOff - mc.field_1772.method_1727(name) : healthOff);
                guiGraphics.method_25303(mc.field_1772, name, xCoord, c.y + 5 + (flippedVer ? 52 : 0), 0xFFFFFF);
            }
        }
        catch (Exception e) {
            BetterPVP.LOGGER.error("Please report this to Xaero96 on PlanetMinecraft/MinecraftForums/CurseForge!", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawEntityOnScreen(class_310 mc, class_4587 matrixStack, int x, int y, int scale, class_1309 entity, boolean flip) {
        double cos;
        if (entity == null) {
            return;
        }
        class_898 rendermanager = mc.method_1561();
        if (rendermanager.field_4686 == null) {
            return;
        }
        float yBodyRotBU = entity.field_6283;
        float yRotBU = entity.method_36454();
        float yHeadRotBU = entity.field_6241;
        entity.field_6283 = 0.0f;
        entity.method_36456(0.0f);
        entity.field_6241 = yHeadRotBU - yBodyRotBU;
        matrixStack.method_22903();
        matrixStack.method_46416((float)x, (float)y, 50.0f);
        matrixStack.method_22905((float)(-scale), (float)scale, (float)scale);
        OptimizedMath.rotatePose(matrixStack, 180.0f, (Vector3fc)OptimizedMath.ZP);
        OptimizedMath.rotatePose(matrixStack, 30.0f, (Vector3fc)OptimizedMath.XP);
        float width = entity.method_17681() * (float)scale / 30.0f;
        if (width < 1.0f) {
            width = 1.0f;
        }
        if ((cos = Math.sqrt(2.0) / 2.0 / (double)width) > 1.0) {
            cos = 1.0;
        }
        float rotation = (float)Math.toDegrees(Math.acos(cos));
        OptimizedMath.rotatePose(matrixStack, flip ? -rotation : rotation, (Vector3fc)OptimizedMath.YP);
        matrixStack.method_46416(0.0f, -entity.method_17682() / 2.0f, 0.0f);
        rendermanager.method_3948(false);
        class_308.method_24211();
        boolean hideGUIBU = mc.field_1690.field_1842;
        mc.field_1690.field_1842 = true;
        try {
            class_4597.class_4598 bufferSource = class_310.method_1551().method_22940().method_23000();
            class_5365 graphicsModeBU = (class_5365)mc.field_1690.method_42534().method_41753();
            mc.field_1690.method_42534().method_41748((Object)class_5365.field_25428);
            rendermanager.method_62424((class_1297)entity, 0.0, 0.0, 0.0, 1.0f, matrixStack, (class_4597)bufferSource, 0xF000F0);
            mc.field_1690.method_42534().method_41748((Object)graphicsModeBU);
            bufferSource.method_22993();
        }
        finally {
            mc.field_1690.field_1842 = hideGUIBU;
            rendermanager.method_3948(true);
            RenderSystem.disableBlend();
            entity.field_6283 = yBodyRotBU;
            entity.method_36456(yRotBU);
            entity.field_6241 = yHeadRotBU;
            matrixStack.method_22909();
        }
    }

    public boolean drawArmourBar(class_310 mc, class_332 guiGraphics, EntityInfoSession session, class_1309 e, int x, int y, boolean flip) {
        int armorValue = e.method_6096();
        if (armorValue > 0) {
            if (session.getEntityInfoArmourNumbers()) {
                guiGraphics.method_52706(class_1921::method_62277, ARMOR_FULL, x - (flip ? 8 : 0), y, 9, 9);
                guiGraphics.method_25303(mc.field_1772, armorValue + "/20", x + (flip ? -11 - mc.field_1772.method_1727(armorValue + "/20") : 11), y, 0xFFFFFF);
            } else {
                for (int iconIndex = 0; iconIndex < 10; ++iconIndex) {
                    int iconX = x + (flip ? -8 - iconIndex * 8 : iconIndex * 8);
                    if (iconIndex * 2 + 1 < armorValue) {
                        guiGraphics.method_52706(class_1921::method_62277, ARMOR_FULL, iconX, y, 9, 9);
                        continue;
                    }
                    if (iconIndex * 2 + 1 == armorValue) {
                        guiGraphics.method_52706(class_1921::method_62277, ARMOR_HALF, iconX, y, 9, 9);
                        continue;
                    }
                    if (iconIndex * 2 + 1 <= armorValue) continue;
                    guiGraphics.method_52706(class_1921::method_62277, ARMOR_EMPTY, iconX, y, 9, 9);
                }
            }
            return true;
        }
        return false;
    }

    public void drawHealthBar(class_310 mc, class_332 guiGraphics, EntityInfoSession session, class_1309 e, int x, int y, boolean flip, boolean vertFlipped) {
        class_4587 matrixStack = guiGraphics.method_51448();
        int health = class_3532.method_15386((float)e.method_6032());
        float maxHealth = class_3532.method_15384((double)e.method_45325(class_5134.field_23716));
        float absorptionAmount = class_3532.method_15386((float)e.method_6067());
        if (session.getEntityInfoHealthNumbers()) {
            String text = health + "/" + (int)maxHealth;
            if (absorptionAmount > 0.0f) {
                text = text + "+" + absorptionAmount;
                health = 0;
                maxHealth = 0.0f;
                absorptionAmount = 2.0f;
            } else {
                health = 2;
                maxHealth = 2.0f;
                absorptionAmount = 0.0f;
            }
            guiGraphics.method_25303(mc.field_1772, text, x + (flip ? -11 - mc.field_1772.method_1727(text) : 11), y, -1);
        }
        RenderSystem.enableBlend();
        int regularHalvesToRender = (int)(maxHealth + 1.0f) / 2 * 2;
        int regularFilledHalves = health;
        int absorptionHalvesToRender = (int)(absorptionAmount + 1.0f) / 2 * 2;
        int absorptionFilledHalves = (int)absorptionAmount;
        int limit = (int)session.getEntityInfoMaxHearts() * 2;
        if (regularHalvesToRender > limit) {
            regularHalvesToRender = limit;
            int n = regularFilledHalves = maxHealth == 0.0f ? 0 : Math.round((float)(health * regularHalvesToRender) / maxHealth);
        }
        if (absorptionHalvesToRender > limit) {
            absorptionHalvesToRender = absorptionFilledHalves = limit;
        }
        int totalHalvesToRender = regularHalvesToRender + absorptionHalvesToRender;
        int rows = class_3532.method_15386((float)((float)totalHalvesToRender / 20.0f));
        int rowStep = Math.max(10 - (rows - 2), 3);
        boolean shake = maxHealth != 0.0f && (double)health <= (double)maxHealth * 0.4;
        int absorptionLeft = absorptionFilledHalves;
        Matrix4f modelMatrix = matrixStack.method_23760().method_23761();
        for (int heartIndex = totalHalvesToRender / 2 - 1; heartIndex >= 0; --heartIndex) {
            int rowIndex = (int)Math.ceil((float)(heartIndex + 1) / 10.0f) - 1;
            int xcoord = heartIndex % 10 * 8;
            int heartX = x + (flip ? -xcoord - 9 : xcoord);
            int heartY = y + rowIndex * rowStep * (vertFlipped ? -1 : 1);
            if (shake) {
                heartY += this.random.nextInt(2);
            }
            this.blitFlippable(mc, modelMatrix, HEART_CONTANER, heartX, heartY, 9, 9, flip);
            if (absorptionLeft > 0) {
                if (absorptionLeft == absorptionFilledHalves && absorptionFilledHalves % 2 == 1) {
                    this.blitFlippable(mc, modelMatrix, ABSORBING_HEART_HALF, heartX, heartY, 9, 9, flip);
                } else {
                    this.blitFlippable(mc, modelMatrix, ABSORBING_HEART_FULL, heartX, heartY, 9, 9, flip);
                }
                absorptionLeft -= 2;
                continue;
            }
            if (heartIndex * 2 + 1 < regularFilledHalves) {
                this.blitFlippable(mc, modelMatrix, NORMAL_HEART_FULL, heartX, heartY, 9, 9, flip);
            }
            if (heartIndex * 2 + 1 != regularFilledHalves) continue;
            this.blitFlippable(mc, modelMatrix, NORMAL_HEART_HALF, heartX, heartY, 9, 9, flip);
        }
        RenderSystem.disableBlend();
    }

    public double drawPotionEffects(class_310 mc, class_332 guiGraphics, EntityInfoSession session, class_1309 e, int x, int y, int h, boolean flippedHor, boolean flippedVer, double scale) {
        Collection effects = e.method_6026();
        if (effects.isEmpty()) {
            return -1.0;
        }
        effects = Ordering.natural().sortedCopy((Iterable)effects);
        class_4587 matrixStack = guiGraphics.method_51448();
        matrixStack.method_22903();
        matrixStack.method_46416((float)x, (float)y, 0.0f);
        RenderSystem.enableBlend();
        class_4074 effectSprites = mc.method_18505();
        double pixelSize = (double)session.getEntityInfoEffectsScale() / scale * session.getAutoUIScale() / 2.0;
        double effectSize = 25.0 * pixelSize;
        int perColumn = (int)((double)h / effectSize);
        int place = 0;
        for (class_1293 pe : effects) {
            class_1058 sprite;
            if (pe == null || (sprite = effectSprites.method_18663(pe.method_5579())) == null) continue;
            matrixStack.method_22903();
            matrixStack.method_22905((float)pixelSize, (float)pixelSize, 1.0f);
            int column = place / perColumn;
            int row = place % perColumn;
            matrixStack.method_46416(flippedHor ? (float)(-18 - 25 * column) : (float)(25 * column), flippedVer ? (float)(-18 - 25 * row) : (float)(25 * row), 0.0f);
            int color = -1;
            if (!pe.method_48559() && pe.method_5584() <= 200 && !session.getEffectBlink()) {
                color = 0x66FFFFFF;
            }
            guiGraphics.method_52710(class_1921::method_62277, sprite, 0, 0, 18, 18, color);
            ++place;
            matrixStack.method_22909();
        }
        matrixStack.method_22909();
        int rows = (effects.size() + perColumn - 1) / perColumn;
        return effectSize * (double)rows - 7.0 * pixelSize;
    }

    public void blitFlippable(class_310 mc, Matrix4f matrix, class_2960 sprite, int x, int y, int width, int height, boolean flip) {
        class_1058 textureAtlasSprite = mc.method_52699().method_18667(sprite);
        RenderSystem.setShaderTexture((int)0, (class_2960)textureAtlasSprite.method_45852());
        RenderSystem.setShader((class_10156)class_10142.field_53879);
        class_289 tessellator = class_289.method_1348();
        class_287 vertexbuffer = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1585);
        vertexbuffer.method_22918(matrix, (float)(x + 0), (float)(y + height), 0.0f).method_22913(flip ? textureAtlasSprite.method_4577() : textureAtlasSprite.method_4594(), textureAtlasSprite.method_4575());
        vertexbuffer.method_22918(matrix, (float)(x + width), (float)(y + height), 0.0f).method_22913(flip ? textureAtlasSprite.method_4594() : textureAtlasSprite.method_4577(), textureAtlasSprite.method_4575());
        vertexbuffer.method_22918(matrix, (float)(x + width), (float)(y + 0), 0.0f).method_22913(flip ? textureAtlasSprite.method_4594() : textureAtlasSprite.method_4577(), textureAtlasSprite.method_4593());
        vertexbuffer.method_22918(matrix, (float)(x + 0), (float)(y + 0), 0.0f).method_22913(flip ? textureAtlasSprite.method_4577() : textureAtlasSprite.method_4594(), textureAtlasSprite.method_4593());
        class_286.method_43433((class_9801)vertexbuffer.method_60794());
    }
}

