/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.category.serialization.data;

import java.util.function.Supplier;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import xaero.hud.category.rule.ExcludeListMode;
import xaero.hud.category.serialization.data.FilterObjectCategoryData;
import xaero.hud.category.serialization.data.ObjectCategoryDataNbtSerializer;

public class FilterObjectCategoryDataNbtSerializer<D extends FilterObjectCategoryData<D>, DB extends FilterObjectCategoryData.Builder<D, DB>>
extends ObjectCategoryDataNbtSerializer<D, DB> {
    protected FilterObjectCategoryDataNbtSerializer(Supplier<DB> builderSupplier) {
        super(builderSupplier);
    }

    @Override
    public CompoundNBT serialize(D data) {
        CompoundNBT resultTag = super.serialize(data);
        resultTag.func_74778_a("h", ((FilterObjectCategoryData)data).getHardInclude());
        resultTag.func_74757_a("i", ((FilterObjectCategoryData)data).getIncludeListInSuperCategory());
        resultTag.func_74778_a("m", ((FilterObjectCategoryData)data).getExcludeMode().name());
        ListNBT includeListTag = new ListNBT();
        ((FilterObjectCategoryData)data).getIncludeListIterator().forEachRemaining(includeEntry -> includeListTag.add((Object)StringNBT.func_229705_a_((String)includeEntry)));
        resultTag.func_218657_a("l", (INBT)includeListTag);
        ListNBT excludeListTag = new ListNBT();
        ((FilterObjectCategoryData)data).getExcludeListIterator().forEachRemaining(excludeEntry -> excludeListTag.add((Object)StringNBT.func_229705_a_((String)excludeEntry)));
        resultTag.func_218657_a("e", (INBT)excludeListTag);
        return resultTag;
    }

    @Override
    protected DB getConfiguredBuilder(CompoundNBT serializedData) {
        FilterObjectCategoryData.Builder builder = (FilterObjectCategoryData.Builder)super.getConfiguredBuilder(serializedData);
        builder.setHardInclude(serializedData.func_74779_i("h"));
        builder.setIncludeListInSuperCategory(serializedData.func_74767_n("i"));
        builder.setExcludeMode(ExcludeListMode.valueOf(serializedData.func_74779_i("m")));
        ListNBT includeListTag = serializedData.func_150295_c("l", 8);
        for (INBT includeEntryTag : includeListTag) {
            builder.addToIncludeList(includeEntryTag.func_150285_a_());
        }
        ListNBT excludeListTag = serializedData.func_150295_c("e", 8);
        for (INBT excludeEntryTag : excludeListTag) {
            builder.addToExcludeList(excludeEntryTag.func_150285_a_());
        }
        return (DB)builder;
    }

    public static final class FinalBuilder<D extends FilterObjectCategoryData<D>, DB extends FilterObjectCategoryData.Builder<D, DB>>
    extends Builder<D, DB, FinalBuilder<D, DB>> {
        private FinalBuilder() {
        }

        @Override
        protected FilterObjectCategoryDataNbtSerializer<D, DB> buildInternally() {
            return new FilterObjectCategoryDataNbtSerializer(this.builderSupplier);
        }

        public static <D extends FilterObjectCategoryData<D>, DB extends FilterObjectCategoryData.Builder<D, DB>> FinalBuilder<D, DB> begin() {
            return (FinalBuilder)new FinalBuilder<D, DB>().setDefault();
        }
    }

    public static abstract class Builder<D extends FilterObjectCategoryData<D>, DB extends FilterObjectCategoryData.Builder<D, DB>, B extends Builder<D, DB, B>>
    extends ObjectCategoryDataNbtSerializer.Builder<D, DB, B> {
        protected Builder() {
        }

        @Override
        public FilterObjectCategoryDataNbtSerializer<D, DB> build() {
            return (FilterObjectCategoryDataNbtSerializer)super.build();
        }
    }
}

