/*
 * Decompiled with CFR 0.152.
 */
package xaero.pvp;

import java.io.IOException;
import java.nio.file.Path;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import xaero.common.HudClientOnlyBase;
import xaero.common.HudMod;
import xaero.common.XaeroMinimapSession;
import xaero.common.events.ClientEvents;
import xaero.common.gui.GuiHelper;
import xaero.common.mods.SupportMods;
import xaero.common.platform.Services;
import xaero.common.settings.ModSettings;
import xaero.hud.common.config.channel.register.HudModConfigCommonRegistryHandler;
import xaero.hud.controls.ControlsRegister;
import xaero.hud.pvp.common.config.channel.register.BetterPVPConfigCommonRegistryHandler;
import xaero.hud.pvp.config.register.BetterPVPConfigClientRegistryHandler;
import xaero.hud.pvp.controls.BetterPVPControlsRegister;
import xaero.hud.pvp.controls.key.BetterPVPKeyMappings;
import xaero.hud.pvp.module.tooltip.IItemTooltipHelper;
import xaero.lib.client.config.channel.register.handler.IConfigChannelClientRegistryHandler;
import xaero.lib.patreon.Patreon;
import xaero.pvp.BetterPVPClientOnly;
import xaero.pvp.BetterPVPSession;
import xaero.pvp.events.BPVPEvents;
import xaero.pvp.gui.BPVPGuiHelper;
import xaero.pvp.settings.BPVPModSettings;

public abstract class BetterPVP
extends HudMod {
    public static final Logger LOGGER = LogManager.getLogger();
    public static BetterPVP instance;
    public static final String MOD_ID = "xaerobetterpvp";

    public BetterPVP(boolean enabled) {
        super(enabled);
        if (!enabled) {
            return;
        }
        instance = this;
    }

    @Override
    protected void loadClient() throws IOException {
        super.loadClient();
    }

    @Override
    protected void loadCommon() {
        SupportMods.checkForMinimapDuplicates();
        super.loadCommon();
    }

    @Override
    protected String getCommonConfigFileName() {
        return "xaerobetterpvp-common.txt";
    }

    @Override
    public String getModId() {
        return MOD_ID;
    }

    @Override
    protected ModSettings createModSettings() {
        return new BPVPModSettings(this);
    }

    @Override
    protected GuiHelper createGuiHelper() {
        return new BPVPGuiHelper(this);
    }

    @Override
    public String getOldConfigFileName() {
        return "pvpsettings.txt";
    }

    @Override
    protected HudClientOnlyBase createClientOnly() {
        return new BetterPVPClientOnly();
    }

    @Override
    protected String getModName() {
        return "Better PVP";
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    public BPVPModSettings getBPVPSettings() {
        return (BPVPModSettings)this.getSettings();
    }

    public abstract IItemTooltipHelper createItemTooltipHelper();

    @Override
    public String getVersionsURL() {
        return "http://data.chocolateminecraft.com/Versions_" + Patreon.getKEY_VERSION2() + "/BetterPvPMod.dat";
    }

    @Override
    public String getUpdateLink() {
        return "http://chocolateminecraft.com/update/bpvp.html";
    }

    @Override
    protected ControlsRegister createControlsRegister() {
        return new BetterPVPControlsRegister();
    }

    @Override
    public XaeroMinimapSession createSession() {
        return new BetterPVPSession(this);
    }

    @Override
    public Object getSettingsKey() {
        return BetterPVPKeyMappings.SETTINGS;
    }

    @Override
    public ClientEvents createClientEvents() {
        return new BPVPEvents(this);
    }

    @Override
    public Object getServerSettingsKey() {
        return BetterPVPKeyMappings.SERVER_PROFILES;
    }

    @Override
    public Path getConfigSubFolder() {
        return Services.PLATFORM.getConfigDir().resolve("xaero").resolve("betterpvp");
    }

    @Override
    public Path getDefaultConfigsSubFolder() {
        return Services.PLATFORM.getConfigDir().resolveSibling("defaultconfigs").resolve("xaero").resolve("betterpvp");
    }

    @Override
    protected HudModConfigCommonRegistryHandler createConfigCommonRegistryHandler() {
        return new BetterPVPConfigCommonRegistryHandler();
    }

    @Override
    protected Supplier<IConfigChannelClientRegistryHandler> createConfigClientRegistryHandlerSupplier() {
        return BetterPVPConfigClientRegistryHandler::new;
    }
}

