/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.radar.icon.creator.render.form.model;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import xaero.common.exception.OpenGLException;
import xaero.common.graphics.CustomRenderTypes;
import xaero.hud.minimap.MinimapLogs;
import xaero.hud.minimap.radar.icon.creator.RadarIconCreator;
import xaero.hud.minimap.radar.icon.creator.entity.LivingEntityPoseResetter;
import xaero.hud.minimap.radar.icon.creator.render.form.IRadarIconFormPrerenderer;
import xaero.hud.minimap.radar.icon.creator.render.form.model.RadarIconModelPrerenderer;
import xaero.hud.minimap.radar.icon.creator.render.form.model.custom.RadarIconCustomPrerenderer;
import xaero.hud.minimap.radar.icon.creator.render.form.model.part.RadarIconModelPartPrerenderer;
import xaero.hud.minimap.radar.icon.creator.render.trace.ModelRenderTrace;
import xaero.hud.minimap.radar.icon.definition.BuiltInRadarIconDefinitions;
import xaero.hud.minimap.radar.icon.definition.form.model.RadarIconModelForm;
import xaero.hud.minimap.radar.icon.definition.form.model.config.RadarIconModelConfig;
import xaero.lib.client.graphics.util.ImmediateRenderUtil;

public class RadarIconModelFormPrerenderer
implements IRadarIconFormPrerenderer {
    private final LivingEntityPoseResetter livingEntityPoseResetter;
    private ModelRenderTrace mainModelTrace;
    private final ArrayList<ModelPart> mainRenderedModels;
    private final RadarIconModelPrerenderer modelPrerenderer;
    private ModelPart mainPart;
    private List<String> hardcodedMainPartAliases;
    private List<String> hardcodedModelPartsFields;
    private boolean forceFieldCheck;
    private boolean fullModelIcon;
    private MultiBufferSource.BufferSource entityIconRenderTypeBuffer = MultiBufferSource.m_109898_((BufferBuilder)new BufferBuilder(256));

    public RadarIconModelFormPrerenderer() {
        this.livingEntityPoseResetter = new LivingEntityPoseResetter();
        this.mainRenderedModels = new ArrayList();
        this.modelPrerenderer = new RadarIconModelPrerenderer();
    }

    @Override
    public boolean requiresEntityModel() {
        return true;
    }

    @Override
    public boolean isFlipped() {
        return false;
    }

    @Override
    public boolean isOutlined() {
        return true;
    }

    @Override
    public <T extends Entity> boolean prerender(PoseStack matrixStack, EntityRenderer<? super T> entityRenderer, @Nullable EntityModel<T> entityModel, T entity, @Nullable List<ModelRenderTrace> traceList, RadarIconCreator.Parameters parameters) {
        LivingEntity livingEntity;
        RadarIconModelForm modelForm = (RadarIconModelForm)parameters.form;
        GlStateManager.m_84091_();
        MultiBufferSource.BufferSource renderTypeBuffer = this.entityIconRenderTypeBuffer;
        GlStateManager.m_84519_();
        GlStateManager.m_84525_();
        GlStateManager.m_84507_();
        GlStateManager.m_84091_();
        GlStateManager.m_84323_((int)515);
        Lighting.m_84930_();
        if (parameters.debug) {
            matrixStack.m_85836_();
            matrixStack.m_85837_(0.0, 10.0, -10.0);
            matrixStack.m_85841_(1.0f, 1.0f, 1.0f);
            ImmediateRenderUtil.coloredRectangle((PoseStack)matrixStack, (float)0.0f, (float)0.0f, (float)9.0f, (float)9.0f, (int)-65536);
            matrixStack.m_85849_();
            GlStateManager.m_84525_();
            RenderSystem.m_69411_((int)770, (int)771, (int)1, (int)771);
        }
        RadarIconModelConfig config = parameters.defaultModelConfig;
        RadarIconModelConfig variantModelConfig = modelForm.getConfig();
        if (variantModelConfig != null) {
            config = variantModelConfig;
        }
        matrixStack.m_85836_();
        matrixStack.m_85837_(32.0, 32.0, -450.0);
        matrixStack.m_85837_((double)config.offsetX, (double)config.offsetY, 0.0);
        int mainScale = 32;
        matrixStack.m_85841_((float)mainScale, (float)mainScale, (float)(-mainScale));
        float scale = parameters.scale;
        if (scale < 1.0f) {
            matrixStack.m_85841_(scale, scale, scale);
        }
        matrixStack.m_85841_(config.baseScale, config.baseScale, config.baseScale);
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(config.rotationY));
        matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(config.rotationX));
        matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(config.rotationZ));
        BuiltInRadarIconDefinitions.defaultTransformation(matrixStack, entityModel, entity);
        LivingEntity livingEntity2 = livingEntity = entity instanceof LivingEntity ? (LivingEntity)entity : null;
        if (livingEntity != null) {
            this.livingEntityPoseResetter.storeAndReset(livingEntity);
        }
        boolean isChildBU = entityModel.f_102610_;
        entityModel.f_102610_ = false;
        boolean result = this.renderLayers(matrixStack, renderTypeBuffer, entityRenderer, entityModel, traceList, entity, config, parameters.defaultModelConfig);
        entityModel.f_102610_ = isChildBU;
        if (livingEntity != null) {
            this.livingEntityPoseResetter.restore(livingEntity);
        }
        BuiltInRadarIconDefinitions.defaultPostIconModelRender(matrixStack, entityModel, entity);
        matrixStack.m_85849_();
        if (parameters.debug) {
            matrixStack.m_85836_();
            matrixStack.m_85837_(9.0, 10.0, -10.0);
            matrixStack.m_85841_(1.0f, 1.0f, 1.0f);
            ImmediateRenderUtil.coloredRectangle((PoseStack)matrixStack, (float)0.0f, (float)0.0f, (float)9.0f, (float)9.0f, (int)-16711936);
            matrixStack.m_85849_();
            RenderSystem.m_69411_((int)770, (int)771, (int)1, (int)771);
        }
        return result;
    }

    private <T extends Entity> boolean renderLayers(PoseStack matrixStack, MultiBufferSource.BufferSource bufferSource, EntityRenderer<? super T> entityRenderer, EntityModel<T> mainEntityModel, List<ModelRenderTrace> traceList, T entity, RadarIconModelConfig config, RadarIconModelConfig defaultConfig) {
        boolean bl = this.forceFieldCheck = !(config.renderingFullModel != null && config.renderingFullModel != false || config.modelPartsFields == null && !BuiltInRadarIconDefinitions.forceFieldCheck(mainEntityModel));
        this.fullModelIcon = config.renderingFullModel == null ? !this.forceFieldCheck && BuiltInRadarIconDefinitions.fullModelIcon(mainEntityModel) : config.renderingFullModel;
        boolean renderedSomething = false;
        if (traceList.isEmpty()) {
            this.addDefaultLayer(traceList, entityRenderer, mainEntityModel, entity);
        }
        boolean allEmpty = true;
        for (ModelRenderTrace mrt : traceList) {
            if (mrt.isEmpty()) continue;
            allEmpty = false;
            break;
        }
        if (allEmpty) {
            for (ModelRenderTrace mrt : traceList) {
                mrt.allVisible = true;
            }
        }
        this.mainPart = null;
        this.mainModelTrace = null;
        this.hardcodedMainPartAliases = BuiltInRadarIconDefinitions.getMainModelPartFields(entityRenderer, mainEntityModel, entity);
        this.hardcodedModelPartsFields = BuiltInRadarIconDefinitions.getSecondaryModelPartsFields(entityRenderer, mainEntityModel, entity);
        this.mainRenderedModels.clear();
        for (ModelRenderTrace mrt : traceList) {
            if (mrt.isEmpty() || renderedSomething && !config.layersAllowed) continue;
            int result = this.renderLayer(matrixStack, bufferSource, mrt, mainEntityModel, entity, config, defaultConfig);
            if (result == -1) break;
            if (result != 1) continue;
            renderedSomething = true;
        }
        this.hardcodedMainPartAliases = null;
        this.hardcodedModelPartsFields = null;
        if (this.mainRenderedModels.isEmpty() || !config.layersAllowed) {
            return renderedSomething;
        }
        RadarIconCustomPrerenderer extraLayer = BuiltInRadarIconDefinitions.getCustomLayer(entityRenderer, entity);
        RadarIconModelPartPrerenderer partPrerenderer = this.modelPrerenderer.getPartPrerenderer();
        if (extraLayer != null) {
            this.mainPart = extraLayer.render(matrixStack, bufferSource, entityRenderer, entity, mainEntityModel, partPrerenderer, this.mainRenderedModels, this.mainPart, config, this.mainModelTrace);
        }
        return renderedSomething;
    }

    private <T extends Entity> void addDefaultLayer(List<ModelRenderTrace> traceList, EntityRenderer<? super T> entityRenderer, EntityModel<T> mainEntityModel, T entity) {
        ResourceLocation mainEntityTexture = null;
        try {
            mainEntityTexture = entityRenderer.m_5478_(entity);
        }
        catch (Throwable t) {
            MinimapLogs.LOGGER.error("Couldn't fetch main entity texture when prerendering an icon with nothing detected!", t);
        }
        if (mainEntityTexture == null) {
            return;
        }
        traceList.add(new ModelRenderTrace(mainEntityModel, mainEntityTexture, null, CustomRenderTypes.getBasicEntityIconLayerPhases(mainEntityTexture), 1.0f, 1.0f, 1.0f, 1.0f));
    }

    private <T extends Entity> int renderLayer(PoseStack matrixStack, MultiBufferSource.BufferSource bufferSource, ModelRenderTrace mrt, EntityModel<T> mainEntityModel, T entity, RadarIconModelConfig config, RadarIconModelConfig defaultConfig) {
        boolean mainPartsVisibility;
        EntityModel<?> traceModel = mrt.model;
        if (entity instanceof Player && traceModel != mainEntityModel && traceModel instanceof HumanoidModel) {
            return 0;
        }
        ResourceLocation traceTexture = mrt.renderTexture;
        TextureAtlasSprite traceAtlasSprite = mrt.renderAtlasSprite;
        boolean mainModel = traceModel == mainEntityModel;
        boolean bl = mainPartsVisibility = mainModel && this.mainModelTrace != null && mrt.sameVisibility(this.mainModelTrace);
        if (mainModel && !mainPartsVisibility) {
            if (traceTexture == null) {
                return 0;
            }
            if (!this.resetModelRotations(entity, traceModel)) {
                return -1;
            }
            this.mainRenderedModels.clear();
            RadarIconModelPrerenderer.Parameters parameters = new RadarIconModelPrerenderer.Parameters(config, defaultConfig, traceTexture, traceAtlasSprite, mrt, this.forceFieldCheck, this.fullModelIcon, this.hardcodedMainPartAliases, this.hardcodedModelPartsFields, this.mainRenderedModels);
            this.mainPart = this.modelPrerenderer.renderModel(matrixStack, bufferSource, traceModel, entity, this.mainPart, parameters);
            this.mainModelTrace = mrt;
            if (!this.mainRenderedModels.isEmpty()) {
                return 1;
            }
            return 0;
        }
        if (!mainModel) {
            if (traceTexture == null) {
                return 0;
            }
            if (!this.resetModelRotations(entity, traceModel)) {
                return -1;
            }
            ArrayList<ModelPart> renderedModels = new ArrayList<ModelPart>();
            RadarIconModelPrerenderer.Parameters parameters = new RadarIconModelPrerenderer.Parameters(config, defaultConfig, traceTexture, traceAtlasSprite, mrt, this.forceFieldCheck, this.fullModelIcon, this.hardcodedMainPartAliases, this.hardcodedModelPartsFields, renderedModels);
            this.mainPart = this.modelPrerenderer.renderModel(matrixStack, bufferSource, traceModel, entity, this.mainPart, parameters);
            if (!renderedModels.isEmpty()) {
                return 1;
            }
            return 0;
        }
        if (this.mainRenderedModels.isEmpty()) {
            return 0;
        }
        VertexConsumer vertexConsumer = this.modelPrerenderer.getLayerModelVertexConsumer(bufferSource, traceTexture, traceAtlasSprite, mrt);
        RadarIconModelPartPrerenderer.Parameters parameters = new RadarIconModelPartPrerenderer.Parameters(config, mrt, new ArrayList<ModelPart>());
        this.modelPrerenderer.getPartPrerenderer().renderPartsIterable(this.mainRenderedModels, matrixStack, vertexConsumer, this.mainPart, parameters);
        bufferSource.m_109911_();
        return 0;
    }

    private <T extends Entity> boolean resetModelRotations(Entity entity, EntityModel<T> model) {
        try {
            model.m_6839_(entity, 0.0f, 0.0f, 1.0f);
            model.m_6973_(entity, 0.0f, 0.0f, (float)entity.f_19797_, 0.0f, 0.0f);
            OpenGLException.checkGLError();
            return true;
        }
        catch (Throwable t) {
            MinimapLogs.LOGGER.error("suppressed exception", t);
            return false;
        }
    }
}

