/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.radar.state;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.Entity;
import xaero.hud.minimap.radar.category.EntityRadarCategory;
import xaero.hud.minimap.radar.category.setting.EntityRadarCategorySettings;

public final class RadarList
implements Comparable<RadarList> {
    private EntityRadarCategory category;
    private final List<Entity> entities;

    private RadarList(List<Entity> entities) {
        this.entities = entities;
        this.category = null;
    }

    public EntityRadarCategory getCategory() {
        return this.category;
    }

    public RadarList setCategory(EntityRadarCategory category) {
        this.category = category;
        return this;
    }

    public void clearEntities() {
        this.entities.clear();
    }

    public boolean add(Entity entity) {
        return this.entities.add(entity);
    }

    public Entity get(int index) {
        return this.entities.get(index);
    }

    public int size() {
        return this.entities.size();
    }

    public Iterable<Entity> getEntities() {
        return this.entities;
    }

    @Override
    public int compareTo(RadarList o) {
        return this.category.getSettingValue(EntityRadarCategorySettings.RENDER_ORDER).compareTo(o.category.getSettingValue(EntityRadarCategorySettings.RENDER_ORDER));
    }

    public static final class Builder {
        private Builder() {
        }

        public Builder setDefault() {
            return this;
        }

        public RadarList build() {
            return new RadarList(new ArrayList<Entity>());
        }

        public static Builder getDefault() {
            return new Builder().setDefault();
        }
    }
}

