/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.gui;

import java.io.IOException;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import xaero.common.IXaeroMinimap;
import xaero.common.gui.MySmallButton;
import xaero.common.gui.ScreenBase;
import xaero.hud.minimap.MinimapLogs;

public class GuiDefaultTpCommand
extends ScreenBase {
    private MySmallButton confirmButton;
    private EditBox commandFormatTextField;
    private EditBox rotationCommandFormatTextField;
    private String commandFormat;
    private String rotationCommandFormat;

    public GuiDefaultTpCommand(IXaeroMinimap modMain, Screen parent, Screen escape) {
        super(modMain, parent, escape, (Component)Component.translatable((String)"gui.xaero_teleport_default_command"));
    }

    @Override
    public void init() {
        super.init();
        if (this.commandFormat == null) {
            this.commandFormat = this.modMain.getSettings().defaultWaypointTPCommandFormat;
        }
        if (this.rotationCommandFormat == null) {
            this.rotationCommandFormat = this.modMain.getSettings().defaultWaypointTPCommandRotationFormat;
        }
        this.commandFormatTextField = new EditBox(this.font, this.width / 2 - 100, this.height / 7 + 50, 200, 20, (Component)Component.translatable((String)"gui.xaero_teleport_default_command"));
        this.commandFormatTextField.setMaxLength(128);
        this.commandFormatTextField.setValue(this.commandFormat);
        this.rotationCommandFormatTextField = new EditBox(this.font, this.width / 2 - 100, this.height / 7 + 98, 200, 20, (Component)Component.translatable((String)"gui.xaero_teleport_default_command"));
        this.rotationCommandFormatTextField.setMaxLength(128);
        this.rotationCommandFormatTextField.setValue(this.rotationCommandFormat);
        this.addWidget(this.commandFormatTextField);
        this.addWidget(this.rotationCommandFormatTextField);
        this.confirmButton = new MySmallButton(200, this.width / 2 - 155, this.height / 6 + 168, (Component)Component.translatable((String)"gui.xaero_confirm", (Object[])new Object[0]), b -> {
            this.modMain.getSettings().defaultWaypointTPCommandFormat = this.commandFormat;
            this.modMain.getSettings().defaultWaypointTPCommandRotationFormat = this.rotationCommandFormat;
            try {
                this.modMain.getSettings().saveSettings();
            }
            catch (IOException e) {
                MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
            }
            this.goBack();
        });
        this.addRenderableWidget((GuiEventListener)this.confirmButton);
        this.addRenderableWidget((GuiEventListener)new MySmallButton(201, this.width / 2 + 5, this.height / 6 + 168, (Component)Component.translatable((String)"gui.xaero_cancel", (Object[])new Object[0]), b -> this.goBack()));
    }

    public void renderBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        super.renderBackground(guiGraphics, i, j, f);
        guiGraphics.drawCenteredString(this.font, this.title, this.width / 2, 20, -1);
        guiGraphics.drawCenteredString(this.font, "{x} {y} {z} {name}", this.width / 2, this.height / 7 + 36, -5592406);
        guiGraphics.drawCenteredString(this.font, "{x} {y} {z} {name} {yaw}", this.width / 2, this.height / 7 + 84, -5592406);
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partial) {
        super.render(guiGraphics, mouseX, mouseY, partial);
        this.commandFormatTextField.render(guiGraphics, mouseX, mouseY, partial);
        this.rotationCommandFormatTextField.render(guiGraphics, mouseX, mouseY, partial);
    }

    public void tick() {
        this.commandFormat = this.commandFormatTextField.getValue();
        this.rotationCommandFormat = this.rotationCommandFormatTextField.getValue();
        this.confirmButton.active = this.commandFormat != null && this.commandFormat.length() > 0 && this.rotationCommandFormat != null && this.rotationCommandFormat.length() > 0;
    }

    public boolean keyPressed(int par1, int par2, int par3) {
        if (par1 == 257 && this.commandFormat != null && this.commandFormat.length() > 0 && this.rotationCommandFormat != null && this.rotationCommandFormat.length() > 0) {
            this.confirmButton.onClick(0.0, 0.0);
        }
        return super.keyPressed(par1, par2, par3);
    }
}

