/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.category.ui.entry;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import xaero.hud.category.ui.GuiCategoryEditor;
import xaero.hud.category.ui.entry.EditorListEntryWidget;
import xaero.lib.client.gui.widget.Tooltip;

public abstract class EditorListEntry
extends Gui {
    protected final int entryRelativeX;
    protected final int entryRelativeY;
    protected final int entryW;
    protected final int entryH;
    protected final int index;
    protected final GuiCategoryEditor.SettingRowList rowList;
    protected final List<EditorListEntry> subEntries;
    protected final Supplier<Tooltip> tooltipSupplier;
    protected int focusedSubEntryIndex;

    public EditorListEntry(int entryX, int entryY, int entryW, int entryH, int index, GuiCategoryEditor.SettingRowList rowList, Supplier<Tooltip> tooltipSupplier) {
        this.entryRelativeX = entryX;
        this.entryRelativeY = entryY;
        this.entryW = entryW;
        this.entryH = entryH;
        this.index = index;
        this.rowList = rowList;
        this.subEntries = new ArrayList<EditorListEntry>();
        this.focusedSubEntryIndex = -1;
        this.tooltipSupplier = tooltipSupplier;
    }

    public EditorListEntry onSelected() {
        if (!this.subEntries.isEmpty() && this.focusedSubEntryIndex >= 0) {
            EditorListEntry subEntry = this.subEntries.get(this.focusedSubEntryIndex);
            return subEntry.onSelected();
        }
        if (!this.selectAction()) {
            return this;
        }
        if (!(this instanceof EditorListEntryWidget)) {
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
        }
        this.rowList.updateEntries();
        return this;
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    public boolean mouseClicked(GuiCategoryEditor.SettingRowList.Entry entry, int relativeMouseX, int relativeMouseY, int i) {
        for (int subIndex = 0; subIndex < this.subEntries.size(); ++subIndex) {
            EditorListEntry subEntry = this.subEntries.get(subIndex);
            if (!subEntry.isHoveredOver(relativeMouseX, relativeMouseY)) continue;
            int subRelativeMouseX = relativeMouseX - subEntry.entryRelativeX;
            int subRelativeMouseY = relativeMouseY - subEntry.entryRelativeY;
            if (this.focusedSubEntryIndex != subIndex) {
                this.unfocusRecursively();
                this.focusedSubEntryIndex = subIndex;
            }
            if (!subEntry.mouseClicked(entry, subRelativeMouseX, subRelativeMouseY, subIndex)) {
                subEntry.confirmSelection();
            }
            return true;
        }
        return false;
    }

    public EditorListEntry confirmSelection() {
        if (this.focusedSubEntryIndex >= 0) {
            return this.subEntries.get(this.focusedSubEntryIndex).confirmSelection();
        }
        return this.onSelected();
    }

    public boolean mouseReleased(int relativeMouseX, int relativeMouseY, int i) {
        for (EditorListEntry subEntry : this.subEntries) {
            int subRelativeMouseX = relativeMouseX - subEntry.entryRelativeX;
            int subRelativeMouseY = relativeMouseY - subEntry.entryRelativeY;
            subEntry.mouseReleased(subRelativeMouseX, subRelativeMouseY, i);
        }
        return false;
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    public boolean mouseDragged(GuiCategoryEditor.SettingRowList.Entry entry, int relativeMouseX, int relativeMouseY, int i, long timeSinceLastClick) {
        return false;
    }

    public boolean keyTyped(char c, int i, boolean isRoot) {
        if (isRoot) {
            if (i == 203 && this.moveFocus(-1)) {
                return false;
            }
            if (i == 205 && this.moveFocus(1)) {
                return false;
            }
        }
        if (this.subEntries.isEmpty() || this.focusedSubEntryIndex < 0) {
            return false;
        }
        EditorListEntry subEntry = this.subEntries.get(this.focusedSubEntryIndex);
        return subEntry.keyTyped(c, i, false);
    }

    public void tick() {
        if (this.subEntries.isEmpty()) {
            return;
        }
        for (EditorListEntry subEntry : this.subEntries) {
            subEntry.tick();
        }
    }

    public Supplier<Tooltip> getTooltipSupplier() {
        return this.tooltipSupplier;
    }

    public abstract ITextComponent getMessage();

    public void preRender(boolean includesSelected, boolean isRoot) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.entryRelativeX, (float)this.entryRelativeY, (float)0.0f);
        if (!includesSelected || this.focusedSubEntryIndex != -1) {
            return;
        }
        EditorListEntry.func_73734_a((int)0, (int)0, (int)this.entryW, (int)this.entryH, (int)-1);
        EditorListEntry.func_73734_a((int)1, (int)1, (int)(this.entryW - 1), (int)(this.entryH - 1), (int)-16777216);
    }

    public EditorListEntry render(int index, int rowWidth, int rowHeight, int relativeMouseX, int relativeMouseY, boolean isMouseOver, float partialTicks, FontRenderer font, int globalMouseX, int globalMouseY, boolean includesSelected, boolean isRoot) {
        EditorListEntry result = isMouseOver ? this : null;
        for (int i = 0; i < this.subEntries.size(); ++i) {
            EditorListEntry subEntry = this.subEntries.get(i);
            boolean subIsHovered = subEntry.isHoveredOver(relativeMouseX, relativeMouseY);
            boolean subIncludesSelected = includesSelected && this.focusedSubEntryIndex == i;
            subEntry.preRender(subIncludesSelected, false);
            EditorListEntry subResult = subEntry.render(index, rowWidth, rowHeight, relativeMouseX - subEntry.entryRelativeX, relativeMouseY - subEntry.entryRelativeY, subIsHovered, partialTicks, font, globalMouseX, globalMouseY, subIncludesSelected, false);
            subEntry.postRender();
            if (!subIsHovered) continue;
            result = subResult;
        }
        return result;
    }

    public void postRender() {
        GlStateManager.func_179121_F();
    }

    public boolean isHoveredOver(int relativeMouseX, int relativeMouseY) {
        return relativeMouseX >= this.entryRelativeX && relativeMouseX < this.entryRelativeX + this.entryW && relativeMouseY >= this.entryRelativeY && relativeMouseY < this.entryRelativeY + this.entryH;
    }

    protected abstract boolean selectAction();

    public void setFocused(boolean bl) {
    }

    public boolean moveFocus(int direction) {
        return this.moveFocus(direction, true);
    }

    public boolean moveFocus(int direction, boolean isRoot) {
        EditorListEntry focusedSub;
        if (this.subEntries.isEmpty()) {
            return false;
        }
        if (this.focusedSubEntryIndex >= 0 && (focusedSub = this.subEntries.get(this.focusedSubEntryIndex)).moveFocus(direction, false)) {
            return true;
        }
        int potentialValue = this.focusedSubEntryIndex + direction;
        if (potentialValue < 0 || potentialValue >= this.subEntries.size()) {
            if (!isRoot) {
                return false;
            }
            int n = potentialValue = potentialValue < 0 ? this.subEntries.size() - 1 : 0;
        }
        if (this.focusedSubEntryIndex == potentialValue) {
            return false;
        }
        this.focusedSubEntryIndex = potentialValue;
        focusedSub = this.subEntries.get(this.focusedSubEntryIndex);
        if (direction < 0) {
            focusedSub.focusLastRecursively();
            return true;
        }
        focusedSub.focusFirstRecursively();
        return true;
    }

    public void unfocusRecursively() {
        this.setFocused(false);
        if (this.subEntries.isEmpty()) {
            return;
        }
        if (this.focusedSubEntryIndex >= 0) {
            this.subEntries.get(this.focusedSubEntryIndex).unfocusRecursively();
        }
        this.focusedSubEntryIndex = -1;
    }

    public void focusFirstRecursively() {
        this.setFocused(true);
        if (this.subEntries.isEmpty()) {
            return;
        }
        this.focusedSubEntryIndex = 0;
        this.subEntries.get(this.focusedSubEntryIndex).focusFirstRecursively();
    }

    public void focusLastRecursively() {
        this.setFocused(true);
        if (this.subEntries.isEmpty()) {
            return;
        }
        this.focusedSubEntryIndex = this.subEntries.size() - 1;
        this.subEntries.get(this.focusedSubEntryIndex).focusLastRecursively();
    }

    public EditorListEntry withSubEntry(EditorListEntry entry) {
        this.subEntries.add(entry);
        return this;
    }

    public int getEntryRelativeX() {
        return this.entryRelativeX;
    }

    public int getEntryRelativeY() {
        return this.entryRelativeY;
    }
}

