/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.element.render;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.Vec3d;
import xaero.common.HudMod;
import xaero.common.misc.OptimizedMath;
import xaero.hud.minimap.BuiltInHudModules;
import xaero.hud.minimap.element.render.MinimapElementReader;
import xaero.hud.minimap.element.render.MinimapElementRenderInfo;
import xaero.hud.minimap.element.render.MinimapElementRenderLocation;
import xaero.hud.minimap.element.render.MinimapElementRenderProvider;
import xaero.hud.minimap.element.render.MinimapElementRenderer;
import xaero.hud.minimap.module.MinimapSession;

public abstract class MinimapElementRendererHandler {
    private final HudMod modMain;
    private final List<MinimapElementRenderer<?, ?>> renderers;
    protected final MinimapElementRenderLocation location;
    private final int indexLimit;

    protected MinimapElementRendererHandler(HudMod modMain, List<MinimapElementRenderer<?, ?>> renderers, MinimapElementRenderLocation location, int indexLimit) {
        this.modMain = modMain;
        this.renderers = renderers;
        this.location = location;
        this.indexLimit = indexLimit;
    }

    public void add(MinimapElementRenderer<?, ?> renderer) {
        this.renderers.add(renderer);
        Collections.sort(this.renderers);
    }

    public double render(Vec3d renderPos, float partialTicks, Framebuffer framebuffer, ScaledResolution scaledRes, double backgroundCoordinateScale, int mapDimension) {
        Minecraft mc = Minecraft.func_71410_x();
        Entity renderEntity = mc.func_175606_aa();
        EntityPlayerSP player = mc.field_71439_g;
        MinimapSession session = BuiltInHudModules.MINIMAP.getCurrentSession();
        boolean cave = session.getProcessor().isCaveModeDisplayed();
        MinimapElementRenderInfo renderInfo = new MinimapElementRenderInfo(this.location, renderEntity, (EntityPlayer)player, renderPos, cave, partialTicks, framebuffer, scaledRes, backgroundCoordinateScale, mapDimension);
        double resultDepth = 0.0;
        this.beforeRender(renderInfo);
        int indexLimit = this.getIndexLimit();
        for (int i = 0; i < this.renderers.size(); ++i) {
            MinimapElementRenderer<?, ?> renderer = this.renderers.get(i);
            int elementIndex = 0;
            elementIndex = this.renderForRenderer(renderer, elementIndex, indexLimit, renderInfo);
            double depthStep = this.getElementIndexDepth(elementIndex, indexLimit);
            GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)depthStep);
            resultDepth += depthStep;
            if ((indexLimit -= elementIndex) >= 0) continue;
            indexLimit = 0;
        }
        this.afterRender(renderInfo);
        return resultDepth;
    }

    protected <E, RRC, RR extends MinimapElementRenderer<E, RRC>> int renderForRenderer(RR renderer, int elementIndex, int indexLimit, MinimapElementRenderInfo renderInfo) {
        MinimapElementRenderLocation location = this.location;
        if (!renderer.shouldRender(location)) {
            return elementIndex;
        }
        MinimapElementReader elementReader = renderer.elementReader;
        MinimapElementRenderProvider provider = renderer.provider;
        Object context = renderer.context;
        renderer.preRender(renderInfo);
        provider.begin(location, context);
        while (provider.hasNext(location, context)) {
            double optionalDepth;
            Object element = provider.setupContextAndGetNext(location, context);
            if (element == null || elementReader.isHidden(element, context) || !this.transformAndRenderForRenderer(element, renderer, context, elementIndex, optionalDepth = this.getElementIndexDepth(elementIndex, indexLimit), renderInfo)) continue;
            ++elementIndex;
        }
        provider.end(location, context);
        renderer.postRender(renderInfo);
        return elementIndex;
    }

    protected <E, RRC, RR extends MinimapElementRenderer<E, RRC>> boolean transformAndRenderForRenderer(E element, RR renderer, RRC context, int elementIndex, double optionalDepth, MinimapElementRenderInfo renderInfo) {
        MinimapElementReader<E, RRC> elementReader = renderer.elementReader;
        double elementX = elementReader.getRenderX(element, context, renderInfo.partialTicks);
        double elementY = elementReader.getRenderY(element, context, renderInfo.partialTicks);
        double elementZ = elementReader.getRenderZ(element, context, renderInfo.partialTicks);
        double elementCoordinateScale = elementReader.getCoordinateScale(element, context, renderInfo);
        double coordinateMultiplier = elementCoordinateScale / renderInfo.backgroundCoordinateScale;
        if (coordinateMultiplier == 1.0) {
            return this.transformAndRenderForRenderer(element, elementX, elementY, elementZ, renderer, context, elementIndex, optionalDepth, renderInfo);
        }
        if (elementReader.shouldScalePartialCoordinates(element, context, renderInfo)) {
            elementX *= coordinateMultiplier;
            elementZ *= coordinateMultiplier;
        } else {
            int flooredRenderX = OptimizedMath.myFloor(elementX);
            int flooredRenderZ = OptimizedMath.myFloor(elementZ);
            elementX = (double)OptimizedMath.myFloor((double)flooredRenderX * coordinateMultiplier) + (elementX - (double)flooredRenderX);
            elementZ = (double)OptimizedMath.myFloor((double)flooredRenderZ * coordinateMultiplier) + (elementZ - (double)flooredRenderZ);
        }
        return this.transformAndRenderForRenderer(element, elementX, elementY, elementZ, renderer, context, elementIndex, optionalDepth, renderInfo);
    }

    protected double getElementIndexDepth(int elementIndex, int indexLimit) {
        return (double)(elementIndex >= indexLimit ? indexLimit : elementIndex) * 0.1;
    }

    protected int getIndexLimit() {
        return this.indexLimit;
    }

    protected abstract <E, RRC, RR extends MinimapElementRenderer<E, RRC>> boolean transformAndRenderForRenderer(E var1, double var2, double var4, double var6, RR var8, RRC var9, int var10, double var11, MinimapElementRenderInfo var13);

    protected abstract void beforeRender(MinimapElementRenderInfo var1);

    protected abstract void afterRender(MinimapElementRenderInfo var1);

    public static abstract class Builder {
        protected Builder() {
        }

        protected Builder setDefault() {
            return this;
        }

        public MinimapElementRendererHandler build() {
            return this.buildInternally(new ArrayList());
        }

        protected abstract MinimapElementRendererHandler buildInternally(List<MinimapElementRenderer<?, ?>> var1);
    }
}

