/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.core;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Path;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.settings.ToggleableKeyBinding;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.play.server.SChangeBlockPacket;
import net.minecraft.network.play.server.SChunkDataPacket;
import net.minecraft.network.play.server.SJoinGamePacket;
import net.minecraft.network.play.server.SMultiBlockChangePacket;
import net.minecraft.network.play.server.SWorldSpawnChangedPacket;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.storage.SaveFormat;
import xaero.common.HudMod;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.core.IXaeroMinimapClientPlayNetHandler;
import xaero.common.core.IXaeroMinimapSMultiBlockChangePacket;
import xaero.hud.minimap.BuiltInHudModules;
import xaero.hud.minimap.MinimapLogs;
import xaero.hud.minimap.module.MinimapSession;
import xaero.hud.minimap.radar.icon.creator.render.trace.EntityRenderTracer;
import xaero.hud.minimap.world.container.MinimapWorldContainerUtil;
import xaero.hud.pushbox.BuiltInPushBoxes;
import xaero.hud.pushbox.boss.IBossHealthPushBox;
import xaero.hud.pushbox.effect.IPotionEffectsPushBox;
import xaero.lib.common.util.IOUtils;

public class XaeroMinimapCore {
    public static IXaeroMinimap modMain;
    public static Field chunkCleanField;
    public static XaeroMinimapSession currentSession;
    public static Matrix4f waypointsProjection;
    public static Matrix4f waypointModelView;

    public static void ensureField() {
        if (chunkCleanField == null) {
            try {
                chunkCleanField = Chunk.class.getDeclaredField("xaero_chunkClean");
            }
            catch (NoSuchFieldException | SecurityException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void chunkUpdateCallback(int chunkX, int chunkZ) {
        XaeroMinimapCore.ensureField();
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (world != null) {
            try {
                for (int x = chunkX - 1; x < chunkX + 2; ++x) {
                    for (int z = chunkZ - 1; z < chunkZ + 2; ++z) {
                        Chunk chunk = world.func_212866_a_(x, z);
                        if (chunk == null) continue;
                        chunkCleanField.set(chunk, false);
                    }
                }
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void onChunkData(SChunkDataPacket packetIn) {
        XaeroMinimapCore.chunkUpdateCallback(packetIn.func_149273_e(), packetIn.func_149271_f());
    }

    public static void onBlockChange(SChangeBlockPacket packetIn) {
        XaeroMinimapCore.chunkUpdateCallback(packetIn.func_179827_b().func_177958_n() >> 4, packetIn.func_179827_b().func_177952_p() >> 4);
    }

    public static void onMultiBlockChange(SMultiBlockChangePacket packetIn) {
        IXaeroMinimapSMultiBlockChangePacket packetAccess = (IXaeroMinimapSMultiBlockChangePacket)packetIn;
        XaeroMinimapCore.chunkUpdateCallback(packetAccess.xaero_mm_getSectionPos().func_177958_n(), packetAccess.xaero_mm_getSectionPos().func_177952_p());
    }

    public static void onSpawn(SWorldSpawnChangedPacket packetIn) {
        if (!XaeroMinimapCore.isModLoaded()) {
            return;
        }
        modMain.getEvents().handlePlayerSetSpawn((World)Minecraft.func_71410_x().field_71441_e, packetIn.func_240832_b_());
    }

    public static void onPlayNetHandler(ClientPlayNetHandler netHandler, SJoinGamePacket packet) {
        if (!XaeroMinimapCore.isModLoaded()) {
            return;
        }
        try {
            XaeroMinimapSession minimapSession;
            IXaeroMinimapClientPlayNetHandler netHandlerAccess = (IXaeroMinimapClientPlayNetHandler)netHandler;
            if (netHandlerAccess.getXaero_minimapSession() != null) {
                return;
            }
            if (currentSession != null) {
                MinimapLogs.LOGGER.info("Previous hud session still active. Probably using MenuMobs. Forcing it to end...");
                XaeroMinimapCore.cleanupCurrentSession();
            }
            currentSession = minimapSession = modMain.createSession();
            minimapSession.init(netHandler);
            netHandlerAccess.setXaero_minimapSession(minimapSession);
        }
        catch (Throwable e) {
            if (currentSession != null) {
                XaeroMinimapCore.cleanupCurrentSession();
            }
            RuntimeException wrappedException = new RuntimeException("Exception initializing Xaero's Minimap! ", e);
            modMain.getInterfaces().getMinimapInterface().setCrashedWith(wrappedException);
        }
    }

    private static void cleanupCurrentSession() {
        try {
            currentSession.tryCleanup();
        }
        catch (Throwable supressed) {
            MinimapLogs.LOGGER.error("suppressed exception", supressed);
        }
        finally {
            currentSession = null;
        }
    }

    public static void onPlayNetHandlerCleanup(ClientPlayNetHandler netHandler) {
        if (!XaeroMinimapCore.isModLoaded()) {
            return;
        }
        try {
            XaeroMinimapSession netHandlerSession = ((IXaeroMinimapClientPlayNetHandler)netHandler).getXaero_minimapSession();
            if (netHandlerSession == null) {
                return;
            }
            try {
                netHandlerSession.tryCleanup();
            }
            finally {
                if (netHandlerSession == currentSession) {
                    currentSession = null;
                }
                ((IXaeroMinimapClientPlayNetHandler)netHandler).setXaero_minimapSession(null);
            }
        }
        catch (Throwable e) {
            RuntimeException wrappedException = new RuntimeException("Exception finalizing Xaero's Minimap! ", e);
            modMain.getInterfaces().getMinimapInterface().setCrashedWith(wrappedException);
        }
    }

    public static void beforeRespawn(PlayerEntity player) {
        MinimapSession minimapSession;
        if (!XaeroMinimapCore.isModLoaded()) {
            return;
        }
        if (player == Minecraft.func_71410_x().field_71439_g && (minimapSession = BuiltInHudModules.MINIMAP.getCurrentSession()) != null) {
            minimapSession.getWaypointSession().getDeathpointHandler().createDeathpoint(player);
        }
    }

    public static void onProjectionMatrix(Matrix4f matrixIn) {
        waypointsProjection.set(matrixIn);
    }

    public static void onWorldModelViewMatrix(MatrixStack matrixStack) {
        waypointModelView.set(matrixStack.func_227866_c_().func_227870_a_());
    }

    public static void beforeIngameGuiRender(MatrixStack matrixStack, float partialTicks) {
        if (!XaeroMinimapCore.isModLoaded()) {
            return;
        }
        modMain.getEvents().handleRenderGameOverlayEventPreAll(matrixStack, partialTicks);
    }

    public static void onRenderStatusEffectOverlayPost(MatrixStack matrixStack) {
        if (!XaeroMinimapCore.isModLoaded()) {
            return;
        }
        IPotionEffectsPushBox potionEffectsPushBox = BuiltInPushBoxes.getPotionEffectPushBox(modMain);
        if (potionEffectsPushBox != null) {
            potionEffectsPushBox.setActive(true);
        }
    }

    public static void onBossHealthRender(int h) {
        if (!XaeroMinimapCore.isModLoaded()) {
            return;
        }
        IBossHealthPushBox bossHealthPushBox = BuiltInPushBoxes.getBossHealthPushBox(modMain);
        if (bossHealthPushBox != null) {
            bossHealthPushBox.setActive(true);
            bossHealthPushBox.setLastBossHealthHeight(h);
        }
    }

    public static void onEntityIconsModelRenderDetection(EntityModel<?> model, IVertexBuilder vertexConsumer, float red, float green, float blue, float alpha) {
        if (!EntityRenderTracer.TRACING_MODEL_RENDERS) {
            return;
        }
        modMain.getInterfaces().getMinimapInterface().getMinimapFBORenderer().onRadarIconModelRenderTrace(model, vertexConsumer, red, green, blue, alpha);
    }

    public static void onEntityIconsModelPartRenderDetection(ModelRenderer modelRenderer, float red, float green, float blue, float alpha) {
        if (!EntityRenderTracer.TRACING_MODEL_RENDERS) {
            return;
        }
        modMain.getInterfaces().getMinimapInterface().getMinimapFBORenderer().onEntityIconModelPartRenderTrace(modelRenderer, red, green, blue, alpha);
    }

    public static void onDeleteWorld(SaveFormat.LevelSave levelStorageAccess) {
        if (!XaeroMinimapCore.isModLoaded()) {
            return;
        }
        String worldFolder = levelStorageAccess.getWorldDir().getFileName().toString();
        if (!worldFolder.isEmpty()) {
            String minimapWorldFolder = MinimapWorldContainerUtil.convertWorldFolderToContainerNode(worldFolder);
            Path minimapWorldFolderPath = HudMod.INSTANCE.getMinimapFolder().resolve(minimapWorldFolder);
            if (minimapWorldFolderPath.toFile().exists()) {
                try {
                    IOUtils.deleteFile((Path)minimapWorldFolderPath, (int)20);
                    MinimapLogs.LOGGER.info(String.format("Deleted minimap world data at %s", minimapWorldFolderPath));
                }
                catch (IOException e) {
                    MinimapLogs.LOGGER.error(String.format("Failed to delete minimap world data at %s!", minimapWorldFolderPath), (Throwable)e);
                }
            }
        }
    }

    public static boolean isModLoaded() {
        return modMain != null && modMain.isLoadedClient();
    }

    public static boolean onToggleKeyIsDown(ToggleableKeyBinding keyMapping) {
        if (!XaeroMinimapCore.isModLoaded()) {
            return false;
        }
        if (Minecraft.func_71410_x().field_71474_y == null) {
            return false;
        }
        return modMain.getEvents().handleForceToggleKeyMapping(keyMapping);
    }

    static {
        chunkCleanField = null;
        waypointsProjection = new Matrix4f();
        waypointModelView = new Matrix4f();
    }
}

