/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.gui;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import xaero.common.HudMod;
import xaero.common.IXaeroMinimap;
import xaero.common.gui.GuiWaypointContainers;
import xaero.common.gui.GuiWaypointSets;
import xaero.common.gui.GuiWaypointWorlds;
import xaero.common.gui.MySuperTinyButton;
import xaero.common.gui.TooltipButton;
import xaero.common.gui.WaypointEditForm;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointVisibilityType;
import xaero.common.minimap.waypoints.WaypointWorld;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.common.misc.OptimizedMath;
import xaero.common.validator.NumericFieldValidator;
import xaero.hud.minimap.MinimapLogs;
import xaero.hud.minimap.common.config.option.MinimapProfiledConfigOptions;
import xaero.hud.minimap.config.primary.option.MinimapPrimaryClientConfigOptions;
import xaero.hud.minimap.module.MinimapSession;
import xaero.hud.minimap.waypoint.WaypointColor;
import xaero.hud.minimap.waypoint.WaypointPurpose;
import xaero.hud.minimap.waypoint.set.WaypointSet;
import xaero.hud.minimap.world.MinimapWorld;
import xaero.hud.minimap.world.MinimapWorldManager;
import xaero.hud.path.XaeroPath;
import xaero.lib.client.config.ClientConfigManager;
import xaero.lib.client.gui.ScreenBase;
import xaero.lib.client.gui.util.GuiUtils;
import xaero.lib.client.gui.widget.MySmallButton;
import xaero.lib.client.gui.widget.Tooltip;
import xaero.lib.client.gui.widget.dropdown.DropDownWidget;
import xaero.lib.client.gui.widget.dropdown.IDropDownContainer;
import xaero.lib.client.gui.widget.dropdown.IDropDownWidgetCallback;
import xaero.lib.common.config.option.ConfigOption;
import xaero.lib.common.config.single.SingleConfigManager;

public class GuiAddWaypoint
extends ScreenBase
implements IDropDownWidgetCallback {
    private static final Tooltip VISIBILITY_TYPE_TOOLTIP = new Tooltip("gui.xaero_box_visibility_type");
    private static final Tooltip TYPE_TOOLTIP = new Tooltip("gui.xaero_box_waypoint_type");
    private final MinimapSession session;
    private MinimapWorldManager manager;
    protected String screenTitle;
    private Button leftButton;
    private Button rightButton;
    private Button modeSwitchButton;
    private Button resetButton;
    private EditBox nameTextField;
    private EditBox xTextField;
    private EditBox yTextField;
    private EditBox zTextField;
    private EditBox yawTextField;
    private EditBox initialTextField;
    private WaypointEditForm mutualForm;
    private ArrayList<WaypointEditForm> editForms;
    private int selectedWaypointIndex;
    private int defaultContainer;
    private MinimapWorld defaultWorld;
    private GuiWaypointContainers containers;
    private GuiWaypointWorlds worlds;
    private GuiWaypointSets sets;
    private DropDownWidget containersDD;
    private DropDownWidget worldsDD;
    private DropDownWidget setsDD;
    private DropDownWidget colorDD;
    private String fromSet;
    private ArrayList<Waypoint> waypointsEdited;
    private Button disableButton;
    private Button visibilityTypeButton;
    private NumericFieldValidator fieldValidator;
    private NumericFieldValidator fieldYValidator;
    private boolean adding;
    private boolean prefilled;
    private boolean startPrefilled;
    private String namePlaceholder;
    private String xPlaceholder;
    private String yPlaceholder;
    private String zPlaceholder;
    private String yawPlaceholder;
    private String initialPlaceholder;
    private String colorPlaceholder;
    private Button defaultYawButton;
    private Button defaultDisabledButton;
    private Button defaultVisibilityTypeButton;
    protected Button confirmButton;
    private boolean censorCoordsIfNeeded;
    private final XaeroPath frozenAutoWorldPath;
    private BiFunction<String, Integer, String> censoredTextFormatterString;
    private BiFunction<String, Integer, FormattedCharSequence> censoredTextFormatter;
    private boolean hasForcedPlayerPos;
    private int forcedPlayerX;
    private int forcedPlayerY;
    private int forcedPlayerZ;
    private double forcedPlayerScale;
    private MinimapWorld forcedCoordSrcWorld;
    private boolean ignoreEditBoxChanges = true;
    private boolean canBeLabyMod = true;
    private final HudMod modMain;

    @Deprecated
    public GuiAddWaypoint(IXaeroMinimap modMain, WaypointsManager manager, Screen par1GuiScreen, Screen escapeScreen, Waypoint point, String defaultParentContainer, WaypointWorld defaultWorld, String waypointSet) {
        this(modMain, manager, par1GuiScreen, escapeScreen, point, defaultParentContainer, defaultWorld, waypointSet, false, 0, 0, 0);
    }

    @Deprecated
    public GuiAddWaypoint(IXaeroMinimap modMain, WaypointsManager manager, Screen par1GuiScreen, Screen escapeScreen, Waypoint point, String defaultParentContainer, WaypointWorld defaultWorld, String waypointSet, boolean hasForcedPlayerPos, int forcedPlayerX, int forcedPlayerY, int forcedPlayerZ, double forcedPlayerScale, WaypointWorld forcedCoordSrcWorld) {
        this(modMain, manager, par1GuiScreen, escapeScreen, (ArrayList<Waypoint>)(point == null ? Lists.newArrayList() : Lists.newArrayList((Object[])new Waypoint[]{point})), defaultParentContainer, defaultWorld, waypointSet, point == null || point.getActualColor() == -1, hasForcedPlayerPos, forcedPlayerX, forcedPlayerY, forcedPlayerZ, forcedPlayerScale, forcedCoordSrcWorld);
    }

    @Deprecated
    public GuiAddWaypoint(IXaeroMinimap modMain, WaypointsManager manager, Screen par1GuiScreen, ArrayList<Waypoint> waypointsEdited, String defaultParentContainer, WaypointWorld defaultWorld, boolean adding) {
        this(modMain, manager, par1GuiScreen, null, waypointsEdited, defaultParentContainer, defaultWorld, defaultWorld.getCurrentWaypointSetId(), adding);
    }

    @Deprecated
    public GuiAddWaypoint(IXaeroMinimap modMain, WaypointsManager manager, Screen par1GuiScreen, Screen escapeScreen, ArrayList<Waypoint> waypointsEdited, String defaultParentContainer, WaypointWorld defaultWorld, String waypointSet, boolean adding) {
        this(modMain, manager, par1GuiScreen, escapeScreen, waypointsEdited, defaultParentContainer, defaultWorld, waypointSet, adding, false, 0, 0, 0);
    }

    @Deprecated
    public GuiAddWaypoint(IXaeroMinimap modMain, WaypointsManager manager, Screen par1GuiScreen, Screen escapeScreen, ArrayList<Waypoint> waypointsEdited, String defaultParentContainer, WaypointWorld defaultWorld, String waypointSet, boolean adding, boolean hasForcedPlayerPos, int forcedPlayerX, int forcedPlayerY, int forcedPlayerZ, double forcedPlayerScale, WaypointWorld forcedCoordSrcWorld) {
        this((HudMod)modMain, (MinimapSession)manager, par1GuiScreen, escapeScreen, waypointsEdited, XaeroPath.root(defaultParentContainer), (MinimapWorld)defaultWorld, waypointSet, adding, hasForcedPlayerPos, forcedPlayerX, forcedPlayerY, forcedPlayerZ, forcedPlayerScale, (MinimapWorld)forcedCoordSrcWorld);
    }

    @Deprecated
    public GuiAddWaypoint(IXaeroMinimap modMain, WaypointsManager manager, Screen par1GuiScreen, Screen escapeScreen, ArrayList<Waypoint> waypointsEdited, String defaultParentContainer, WaypointWorld defaultWorld, String waypointSet, boolean adding, boolean hasForcedPlayerPos, int forcedPlayerX, int forcedPlayerY, int forcedPlayerZ) {
        this(modMain, manager, par1GuiScreen, escapeScreen, waypointsEdited, defaultParentContainer, defaultWorld, waypointSet, adding, hasForcedPlayerPos, forcedPlayerX, forcedPlayerY, forcedPlayerZ, Minecraft.m_91087_().f_91073_.m_6042_().f_63859_(), null);
    }

    @Deprecated
    public GuiAddWaypoint(IXaeroMinimap modMain, WaypointsManager manager, Screen par1GuiScreen, Screen escapeScreen, Waypoint point, String defaultParentContainer, WaypointWorld defaultWorld, String waypointSet, boolean hasForcedPlayerPos, int forcedPlayerX, int forcedPlayerY, int forcedPlayerZ) {
        this(modMain, manager, par1GuiScreen, escapeScreen, point, defaultParentContainer, defaultWorld, waypointSet, hasForcedPlayerPos, forcedPlayerX, forcedPlayerY, forcedPlayerZ, Minecraft.m_91087_().f_91073_.m_6042_().f_63859_(), null);
    }

    public GuiAddWaypoint(HudMod modMain, MinimapSession session, Screen par1GuiScreen, Screen escapeScreen, ArrayList<Waypoint> waypointsEdited, XaeroPath defaultParentContainer, MinimapWorld defaultWorld, String waypointSet, boolean adding, boolean hasForcedPlayerPos, int forcedPlayerX, int forcedPlayerY, int forcedPlayerZ, double forcedPlayerScale, MinimapWorld forcedCoordSrcWorld) {
        super(par1GuiScreen, escapeScreen, (Component)Component.m_237113_((String)""));
        this.modMain = modMain;
        this.session = session;
        this.hasForcedPlayerPos = hasForcedPlayerPos;
        this.forcedPlayerX = forcedPlayerX;
        this.forcedPlayerY = forcedPlayerY;
        this.forcedPlayerZ = forcedPlayerZ;
        this.forcedPlayerScale = forcedPlayerScale;
        this.forcedCoordSrcWorld = forcedCoordSrcWorld;
        this.waypointsEdited = waypointsEdited;
        this.manager = session.getWorldManager();
        this.fromSet = waypointSet;
        this.defaultWorld = defaultWorld;
        this.frozenAutoWorldPath = session.getWorldState().getAutoWorldPath();
        this.containers = new GuiWaypointContainers(modMain, this.manager, defaultParentContainer, this.frozenAutoWorldPath);
        this.defaultContainer = this.containers.current;
        this.worlds = new GuiWaypointWorlds(this.manager.getRootWorldContainer(defaultParentContainer), session, defaultWorld.getFullPath(), this.frozenAutoWorldPath);
        this.sets = new GuiWaypointSets(false, defaultWorld, this.fromSet);
        this.prefilled = !waypointsEdited.isEmpty();
        this.startPrefilled = this.prefilled;
        this.createForms();
        this.fieldValidator = modMain.getFieldValidators().getNumericFieldValidator();
        this.fieldYValidator = modMain.getFieldValidators().getWpCoordFieldValidator();
        this.adding = adding;
        this.namePlaceholder = "- " + I18n.m_118938_((String)"gui.xaero_waypoint_name", (Object[])new Object[0]);
        this.xPlaceholder = "- x";
        this.yPlaceholder = "- y";
        this.zPlaceholder = "- z";
        this.yawPlaceholder = "- " + I18n.m_118938_((String)"gui.xaero_yaw", (Object[])new Object[0]);
        this.initialPlaceholder = "- " + I18n.m_118938_((String)"gui.xaero_initial", (Object[])new Object[0]);
        this.colorPlaceholder = "\u00a78-";
        this.censorCoordsIfNeeded = true;
        this.censoredTextFormatterString = (p_195610_0_, p_195610_1_) -> {
            if (!this.censorCoordsIfNeeded) {
                return p_195610_0_;
            }
            return p_195610_0_.replaceAll(".", "#");
        };
        Style defaultTextStyle = Style.f_131099_;
        this.censoredTextFormatter = (s, i) -> {
            String censoredString = this.censoredTextFormatterString.apply((String)s, (Integer)i);
            return cc -> {
                for (int j = 0; j < censoredString.length(); ++j) {
                    cc.m_6411_(j, defaultTextStyle, (int)censoredString.charAt(j));
                }
                return true;
            };
        };
        this.canSkipWorldRender = true;
    }

    public GuiAddWaypoint(HudMod modMain, MinimapSession session, Screen par1GuiScreen, Screen escapeScreen, ArrayList<Waypoint> waypointsEdited, XaeroPath defaultParentContainer, MinimapWorld defaultWorld, String waypointSet, boolean adding) {
        this(modMain, session, par1GuiScreen, escapeScreen, waypointsEdited, defaultParentContainer, defaultWorld, waypointSet, adding, false, 0, 0, 0, Minecraft.m_91087_().f_91073_.m_6042_().f_63859_(), null);
    }

    public GuiAddWaypoint(HudMod modMain, MinimapSession session, Screen par1GuiScreen, ArrayList<Waypoint> waypointsEdited, XaeroPath defaultParentContainer, MinimapWorld defaultWorld, boolean adding) {
        this(modMain, session, par1GuiScreen, null, waypointsEdited, defaultParentContainer, defaultWorld, defaultWorld.getCurrentWaypointSetId(), adding);
    }

    private void fillFormWaypoint(WaypointEditForm form, Waypoint w) {
        form.name = w.getLocalizedName();
        form.xText = "" + w.getX();
        form.yText = w.isYIncluded() ? "" + w.getY() : "~";
        form.zText = "" + w.getZ();
        form.yawText = w.isRotation() ? "" + w.getYaw() : "";
        form.initial = w.getInitials();
        form.disabledOrTemporary = w.isDestination() ? 3 : (w.isTemporary() ? 2 : (w.isDisabled() ? 1 : 0));
        form.color = w.getWaypointColor();
        form.visibilityType = w.getVisibility();
        if (form.initial.length() == 0) {
            form.autoInitial = true;
        }
    }

    private double getDimDiv(double waypointDimScale) {
        double playerDimScale = this.hasForcedPlayerPos ? this.forcedPlayerScale : this.f_96541_.f_91075_.m_9236_().m_6042_().f_63859_();
        return playerDimScale / waypointDimScale;
    }

    private int getAutomaticX(double waypointDimScale) {
        int playerX = this.hasForcedPlayerPos ? this.forcedPlayerX : OptimizedMath.myFloor(this.f_96541_.f_91075_.m_20185_());
        return OptimizedMath.myFloor((double)playerX * this.getDimDiv(waypointDimScale));
    }

    private String getAutomaticYInput(MinimapWorld destinationWorld) {
        if (this.hasForcedPlayerPos && (this.forcedPlayerY == Short.MAX_VALUE || this.forcedCoordSrcWorld != null && this.forcedCoordSrcWorld != destinationWorld)) {
            return "~";
        }
        int playerY = this.hasForcedPlayerPos ? this.forcedPlayerY : OptimizedMath.myFloor(this.f_96541_.f_91075_.m_20186_() + 0.0625);
        return "" + OptimizedMath.myFloor(playerY);
    }

    private int getAutomaticZ(double waypointDimScale) {
        int playerZ = this.hasForcedPlayerPos ? this.forcedPlayerZ : OptimizedMath.myFloor(this.f_96541_.f_91075_.m_20189_());
        return OptimizedMath.myFloor((double)playerZ * this.getDimDiv(waypointDimScale));
    }

    private void fillFormAutomatic(WaypointEditForm form) {
        form.xText = "";
        form.yText = "";
        form.zText = "";
        form.color = WaypointColor.getRandom();
        form.autoInitial = true;
    }

    private void createForms() {
        this.editForms = new ArrayList();
        this.mutualForm = new WaypointEditForm();
        for (int i = 0; i < this.waypointsEdited.size(); ++i) {
            Waypoint w = this.waypointsEdited.get(i);
            WaypointEditForm form = new WaypointEditForm();
            this.fillFormWaypoint(form, w);
            this.editForms.add(form);
        }
        if (!this.startPrefilled) {
            WaypointEditForm createdForm = new WaypointEditForm();
            this.fillFormAutomatic(createdForm);
            this.editForms.add(createdForm);
        }
        this.updateMutual();
    }

    private void resetCurrentForm() {
        if (this.selectedWaypointIndex >= this.waypointsEdited.size()) {
            WaypointEditForm freshForm = new WaypointEditForm();
            this.fillFormAutomatic(freshForm);
            this.editForms.set(this.selectedWaypointIndex, freshForm);
        } else {
            Waypoint w = this.waypointsEdited.get(this.selectedWaypointIndex);
            WaypointEditForm freshForm = new WaypointEditForm();
            this.fillFormWaypoint(freshForm, w);
            this.editForms.set(this.selectedWaypointIndex, freshForm);
        }
    }

    private void updateMutual() {
        String nameTextMutual = "";
        String initialMutual = "";
        String yawMutual = "";
        String xTextMutual = "";
        String yTextMutual = "";
        String zTextMutual = "";
        int waypointDisabledOrTemporaryMutual = 0;
        WaypointVisibilityType waypointVisibilityTypeMutual = WaypointVisibilityType.LOCAL;
        WaypointColor colorMutual = null;
        xTextMutual = "";
        yTextMutual = "";
        zTextMutual = "";
        WaypointEditForm firstForm = this.editForms.get(0);
        this.mutualForm.keepName = this.differentValues(WaypointEditForm::getName);
        this.mutualForm.keepXText = this.editForms.size() > 1 && firstForm.xText.isEmpty() || this.differentValues(WaypointEditForm::getxText);
        this.mutualForm.keepYText = this.editForms.size() > 1 && firstForm.yText.isEmpty() || this.differentValues(WaypointEditForm::getyText);
        this.mutualForm.keepZText = this.editForms.size() > 1 && firstForm.zText.isEmpty() || this.differentValues(WaypointEditForm::getzText);
        this.mutualForm.defaultKeepYawText = this.mutualForm.keepYawText = this.differentValues(WaypointEditForm::getYawText);
        this.mutualForm.keepInitial = this.differentValues(WaypointEditForm::getInitial);
        this.mutualForm.autoInitial = this.editForms.size() == 1 && firstForm.autoInitial;
        this.mutualForm.defaultKeepDisabledOrTemporary = this.mutualForm.keepDisabledOrTemporary = this.differentValues(WaypointEditForm::getDisabledOrTemporary);
        this.mutualForm.defaultKeepVisibilityType = this.mutualForm.keepVisibilityType = this.differentValues(WaypointEditForm::getVisibilityType);
        this.mutualForm.defaultKeepColor = this.differentValues(WaypointEditForm::getColor);
        if (!this.mutualForm.keepName) {
            nameTextMutual = firstForm.name;
        }
        if (!this.mutualForm.keepXText) {
            xTextMutual = firstForm.xText;
        }
        if (!this.mutualForm.keepYText) {
            yTextMutual = firstForm.yText;
        }
        if (!this.mutualForm.keepZText) {
            zTextMutual = firstForm.zText;
        }
        if (!this.mutualForm.keepYawText) {
            yawMutual = firstForm.yawText;
        }
        if (!this.mutualForm.keepInitial) {
            initialMutual = firstForm.initial;
        }
        if (!this.mutualForm.keepDisabledOrTemporary) {
            waypointDisabledOrTemporaryMutual = firstForm.disabledOrTemporary;
        }
        if (!this.mutualForm.keepVisibilityType) {
            waypointVisibilityTypeMutual = firstForm.visibilityType;
        }
        if (!this.mutualForm.defaultKeepColor) {
            colorMutual = firstForm.color;
        }
        this.mutualForm.name = nameTextMutual;
        this.mutualForm.xText = xTextMutual;
        this.mutualForm.yText = yTextMutual;
        this.mutualForm.zText = zTextMutual;
        this.mutualForm.yawText = yawMutual;
        this.mutualForm.initial = initialMutual;
        this.mutualForm.disabledOrTemporary = waypointDisabledOrTemporaryMutual;
        this.mutualForm.visibilityType = waypointVisibilityTypeMutual;
        this.mutualForm.color = colorMutual;
    }

    private void confirmMutual() {
        for (int i = 0; i < this.editForms.size(); ++i) {
            WaypointEditForm individualForm = this.editForms.get(i);
            if (!this.mutualForm.keepName) {
                individualForm.name = this.mutualForm.name;
            }
            if (!this.mutualForm.keepXText) {
                individualForm.xText = this.mutualForm.xText;
            }
            if (!this.mutualForm.keepYText) {
                individualForm.yText = this.mutualForm.yText;
            }
            if (!this.mutualForm.keepZText) {
                individualForm.zText = this.mutualForm.zText;
            }
            if (!this.mutualForm.keepYawText) {
                individualForm.yawText = this.mutualForm.yawText;
            }
            if (!this.mutualForm.keepInitial) {
                if (!individualForm.initial.equals(this.mutualForm.initial)) {
                    individualForm.autoInitial = false;
                }
                individualForm.initial = this.mutualForm.initial;
            }
            if (!this.mutualForm.keepDisabledOrTemporary) {
                individualForm.disabledOrTemporary = this.mutualForm.disabledOrTemporary;
            }
            if (!this.mutualForm.keepVisibilityType) {
                individualForm.visibilityType = this.mutualForm.visibilityType;
            }
            if (this.mutualForm.color == null) continue;
            individualForm.color = this.mutualForm.color;
        }
    }

    private boolean differentValues(Function<WaypointEditForm, Object> s) {
        if (this.editForms.size() == 1) {
            return false;
        }
        WaypointEditForm testWaypoint = this.editForms.get(0);
        for (int i = 1; i < this.editForms.size(); ++i) {
            WaypointEditForm w = this.editForms.get(i);
            if (s.apply(w).equals(s.apply(testWaypoint))) continue;
            return true;
        }
        return false;
    }

    public String[] createColorOptions() {
        boolean unchangedOption = this.getCurrent().defaultKeepColor;
        String[] options = new String[WaypointColor.values().length + (unchangedOption ? 1 : 0)];
        if (unchangedOption) {
            options[0] = this.colorPlaceholder;
        }
        for (int i = 0; i < WaypointColor.values().length; ++i) {
            options[i + (unchangedOption ? 1 : 0)] = i == 0 ? WaypointColor.values()[i].getName().getString() : "\u00a7" + WaypointColor.values()[i].getFormat() + WaypointColor.values()[i].getName().getString();
        }
        return options;
    }

    private boolean getMutualEditConfig() {
        SingleConfigManager primaryConfigManager = HudMod.INSTANCE.getHudConfigs().getPrimaryClientConfigManager();
        return (Boolean)primaryConfigManager.getEffective((ConfigOption)MinimapPrimaryClientConfigOptions.WAYPOINT_MUTUAL_EDIT);
    }

    private void setMutualEditConfig(boolean value) {
        SingleConfigManager primaryConfigManager = HudMod.INSTANCE.getHudConfigs().getPrimaryClientConfigManager();
        primaryConfigManager.getConfig().set((ConfigOption)MinimapPrimaryClientConfigOptions.WAYPOINT_MUTUAL_EDIT, (Object)value);
    }

    public void m_7856_() {
        super.m_7856_();
        this.ignoreEditBoxChanges = true;
        String string = this.screenTitle = this.adding ? I18n.m_118938_((String)"gui.xaero_new_waypoint", (Object[])new Object[0]) : I18n.m_118938_((String)"gui.xaero_edit_waypoint", (Object[])new Object[0]);
        if (this.editForms.size() > 1) {
            this.screenTitle = this.screenTitle + (String)(this.editForms.size() > 1 ? " (" + (String)(this.getMutualEditConfig() ? "" : this.selectedWaypointIndex + 1 + "/") + this.editForms.size() + ")" : "");
        }
        this.nameTextField = this.applyEditBoxResponder(new EditBox(this.f_96547_, this.f_96543_ / 2 - 100, 104, 200, 20, (Component)Component.m_237115_((String)"gui.xaero_waypoint_name")));
        this.xTextField = this.applyEditBoxResponder(new EditBox(this.f_96547_, this.f_96543_ / 2 - 109, 134, 50, 20, (Component)Component.m_237113_((String)"x")));
        this.yTextField = this.applyEditBoxResponder(new EditBox(this.f_96547_, this.f_96543_ / 2 - 53, 134, 50, 20, (Component)Component.m_237113_((String)"y")));
        this.zTextField = this.applyEditBoxResponder(new EditBox(this.f_96547_, this.f_96543_ / 2 + 3, 134, 50, 20, (Component)Component.m_237113_((String)"z")));
        ClientConfigManager configManager = this.modMain.getHudConfigs().getClientConfigManager();
        boolean hideWaypointCoordinatesConfig = (Boolean)configManager.getEffective((ConfigOption)MinimapProfiledConfigOptions.HIDE_WAYPOINT_COORDINATES);
        if (hideWaypointCoordinatesConfig) {
            this.xTextField.m_94149_(this.censoredTextFormatter);
            this.yTextField.m_94149_(this.censoredTextFormatter);
            this.zTextField.m_94149_(this.censoredTextFormatter);
        }
        this.yawTextField = this.applyEditBoxResponder(new EditBox(this.f_96547_, this.f_96543_ / 2 + 59, 134, 50, 20, (Component)Component.m_237115_((String)"gui.xaero_yaw")));
        this.initialTextField = this.applyEditBoxResponder(new EditBox(this.f_96547_, this.f_96543_ / 2 - 25, 164, 50, 20, (Component)Component.m_237115_((String)"gui.xaero_initial")));
        this.m_7787_((GuiEventListener)this.nameTextField);
        this.m_7787_((GuiEventListener)this.xTextField);
        this.m_7787_((GuiEventListener)this.yTextField);
        this.m_7787_((GuiEventListener)this.zTextField);
        this.m_7787_((GuiEventListener)this.yawTextField);
        this.m_7787_((GuiEventListener)this.initialTextField);
        this.confirmButton = new MySmallButton(0, this.f_96543_ / 2 - 155, this.f_96544_ / 6 + 168, (Component)Component.m_237115_((String)"gui.xaero_confirm"), b -> {
            if (this.getMutualEditConfig()) {
                this.confirmMutual();
            }
            boolean creatingAWaypoint = this.adding && this.waypointsEdited.size() < this.editForms.size();
            XaeroPath destinationWorldKeys = (XaeroPath)this.worlds.getCurrentKey();
            MinimapWorld destinationWorld = this.manager.getWorld(destinationWorldKeys);
            double waypointDimScale = this.session.getDimensionHelper().getDimCoordinateScale(destinationWorld);
            int initialEditedWaypointsSize = this.waypointsEdited.size();
            for (int i = 0; i < this.editForms.size(); ++i) {
                Waypoint w;
                int z;
                boolean shouldCreate;
                boolean bl = shouldCreate = i >= initialEditedWaypointsSize;
                if (!creatingAWaypoint && shouldCreate) break;
                WaypointEditForm waypointForm = this.editForms.get(i);
                String nameString = waypointForm.name;
                String xString = waypointForm.xText;
                String yString = waypointForm.yText;
                if (yString.equals("-") || yString.isEmpty()) {
                    yString = this.getAutomaticYInput(destinationWorld);
                }
                String zString = waypointForm.zText;
                String initialString = waypointForm.initial;
                WaypointColor color = waypointForm.color;
                boolean yIncluded = !yString.equals("~");
                int x = xString.equals("-") || xString.isEmpty() ? this.getAutomaticX(waypointDimScale) : Integer.parseInt(xString);
                int y = !yIncluded ? 0 : Integer.parseInt(yString);
                int n = z = zString.equals("-") || zString.isEmpty() ? this.getAutomaticZ(waypointDimScale) : Integer.parseInt(zString);
                if (shouldCreate) {
                    w = new Waypoint(x, y, z, nameString, initialString, color, WaypointPurpose.NORMAL, false, yIncluded);
                    this.waypointsEdited.add(w);
                } else {
                    w = this.waypointsEdited.get(i);
                    if (w.getPurpose() != WaypointPurpose.DEATH || !nameString.equals(I18n.m_118938_((String)"gui.xaero_deathpoint", (Object[])new Object[0]))) {
                        w.setName(nameString);
                        if (w.getPurpose() != WaypointPurpose.NORMAL) {
                            w.setPurpose(WaypointPurpose.NORMAL);
                        }
                    }
                    w.setX(x);
                    w.setY(y);
                    w.setZ(z);
                    w.setInitials(initialString);
                    w.setWaypointColor(color);
                    w.setYIncluded(yIncluded);
                }
                String yawText = waypointForm.yawText;
                int disableOrTemporary = waypointForm.disabledOrTemporary;
                boolean yawIsUsable = yawText.length() > 0 && !yawText.equals("-");
                w.setRotation(yawIsUsable);
                if (yawIsUsable) {
                    w.setYaw(Integer.parseInt(yawText));
                }
                if (w.isDestination() != (disableOrTemporary == 3)) {
                    w.setPurpose(disableOrTemporary == 3 ? WaypointPurpose.DESTINATION : WaypointPurpose.NORMAL);
                }
                w.setDisabled(disableOrTemporary == 1);
                if (disableOrTemporary == 2) {
                    w.setTemporary(true);
                }
                w.setVisibility(waypointForm.visibilityType);
            }
            MinimapWorld sourceWorld = this.defaultWorld;
            WaypointSet sourceSet = sourceWorld.getWaypointSet(this.fromSet);
            String destinationSetKey = this.sets.getCurrentSetKey();
            WaypointSet destinationSet = destinationWorld.getWaypointSet(destinationSetKey);
            if (this.adding || sourceSet != destinationSet) {
                if (!((Boolean)configManager.getEffective((ConfigOption)MinimapProfiledConfigOptions.NEW_WAYPOINTS_TO_BOTTOM)).booleanValue()) {
                    destinationSet.addAll(this.waypointsEdited, true);
                } else {
                    destinationSet.addAll(this.waypointsEdited);
                }
            }
            if (sourceSet != destinationSet) {
                sourceSet.removeAll(this.waypointsEdited);
            }
            try {
                this.session.getWorldManagerIO().saveWorld(sourceWorld);
                if (destinationWorld != sourceWorld) {
                    this.session.getWorldManagerIO().saveWorld(destinationWorld);
                }
            }
            catch (IOException e) {
                MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
            }
            this.goBack();
        });
        this.m_142416_((GuiEventListener)this.confirmButton);
        this.m_142416_((GuiEventListener)new MySmallButton(0, this.f_96543_ / 2 + 5, this.f_96544_ / 6 + 168, (Component)Component.m_237110_((String)"gui.xaero_cancel", (Object[])new Object[0]), b -> this.goBack()));
        this.leftButton = Button.m_253074_((Component)Component.m_237113_((String)"<"), b -> {
            --this.selectedWaypointIndex;
            if (this.selectedWaypointIndex < 0) {
                this.selectedWaypointIndex = 0;
            }
            boolean restoreFocus = this.m_7222_() == b;
            this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
            if (restoreFocus) {
                boolean activeBU = this.leftButton.f_93623_;
                this.leftButton.f_93623_ = true;
                this.m_7522_((GuiEventListener)this.leftButton);
                this.leftButton.f_93623_ = activeBU;
            }
        }).m_252987_(this.f_96543_ / 2 - 203, 104, 20, 20).m_253136_();
        this.rightButton = Button.m_253074_((Component)Component.m_237113_((String)">"), b -> {
            ++this.selectedWaypointIndex;
            if (this.selectedWaypointIndex >= this.editForms.size()) {
                this.selectedWaypointIndex = this.editForms.size() - 1;
            }
            boolean restoreFocus = this.m_7222_() == b;
            this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
            if (restoreFocus) {
                boolean activeBU = this.rightButton.f_93623_;
                this.rightButton.f_93623_ = true;
                this.m_7522_((GuiEventListener)this.rightButton);
                this.rightButton.f_93623_ = activeBU;
            }
        }).m_252987_(this.f_96543_ / 2 + 183, 104, 20, 20).m_253136_();
        this.modeSwitchButton = Button.m_253074_((Component)Component.m_237115_((String)(this.getMutualEditConfig() ? "gui.xaero_waypoints_edit_mode_all" : "gui.xaero_waypoints_edit_mode_individually")), b -> {
            this.setMutualEditConfig(!this.getMutualEditConfig());
            HudMod.INSTANCE.getHudConfigs().getPrimaryClientConfigManagerIO().save();
            if (this.getMutualEditConfig()) {
                this.prefilled = true;
                this.updateMutual();
            } else {
                this.confirmMutual();
            }
            boolean restoreFocus = this.m_7222_() == b;
            this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
            if (restoreFocus) {
                boolean activeBU = this.modeSwitchButton.f_93623_;
                this.modeSwitchButton.f_93623_ = true;
                this.m_7522_((GuiEventListener)this.modeSwitchButton);
                this.modeSwitchButton.f_93623_ = activeBU;
            }
        }).m_252987_(this.f_96543_ / 2 + 106, 56, 99, 20).m_253136_();
        if (this.editForms.size() > 1) {
            this.m_142416_((GuiEventListener)this.leftButton);
            this.m_142416_((GuiEventListener)this.rightButton);
            this.m_142416_((GuiEventListener)this.modeSwitchButton);
        }
        this.resetButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.xaero_waypoints_edit_reset"), b -> {
            if (this.getMutualEditConfig()) {
                this.createForms();
                boolean restoreFocus = this.m_7222_() == b;
                this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
                if (restoreFocus) {
                    boolean activeBU = this.resetButton.f_93623_;
                    this.resetButton.f_93623_ = true;
                    this.m_7522_((GuiEventListener)this.resetButton);
                    this.resetButton.f_93623_ = activeBU;
                }
            } else {
                this.resetCurrentForm();
                boolean restoreFocus = this.m_7222_() == b;
                this.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
                if (restoreFocus) {
                    boolean activeBU = this.resetButton.f_93623_;
                    this.resetButton.f_93623_ = true;
                    this.m_7522_((GuiEventListener)this.resetButton);
                    this.resetButton.f_93623_ = activeBU;
                }
            }
        }).m_252987_(this.f_96543_ / 2 - 204, 56, 99, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.resetButton);
        this.nameTextField.m_94144_(this.getCurrent().name);
        this.xTextField.m_94144_(this.getCurrent().xText);
        this.yTextField.m_94144_(this.getCurrent().yText);
        this.zTextField.m_94144_(this.getCurrent().zText);
        this.yawTextField.m_94144_(this.getCurrent().yawText);
        this.initialTextField.m_94144_(this.getCurrent().initial);
        this.disableButton = new TooltipButton(this.f_96543_ / 2 + 31, 164, 79, 20, this.getDisableButtonText(), b -> {
            this.getCurrent().disabledOrTemporary = (this.getCurrent().disabledOrTemporary + 1) % 4;
            this.disableButton.m_93666_(this.getDisableButtonText());
            this.getCurrent().keepDisabledOrTemporary = false;
            if (this.defaultDisabledButton != null) {
                this.defaultDisabledButton.f_93623_ = true;
            }
        }, () -> TYPE_TOOLTIP);
        this.m_142416_((GuiEventListener)this.disableButton);
        this.visibilityTypeButton = new TooltipButton(this.f_96543_ / 2 - 109, 164, 79, 20, this.getCurrent().visibilityType.getTranslation(), b -> {
            this.getCurrent().visibilityType = WaypointVisibilityType.values()[(this.getCurrent().visibilityType.ordinal() + 1) % WaypointVisibilityType.values().length];
            this.visibilityTypeButton.m_93666_(this.getCurrent().visibilityType.getTranslation());
            this.getCurrent().keepVisibilityType = false;
            if (this.defaultVisibilityTypeButton != null) {
                this.defaultVisibilityTypeButton.f_93623_ = true;
            }
        }, () -> VISIBILITY_TYPE_TOOLTIP);
        this.m_142416_((GuiEventListener)this.visibilityTypeButton);
        if (this.getCurrent().defaultKeepYawText) {
            this.defaultYawButton = Button.m_253074_((Component)Component.m_237113_((String)"-"), b -> {
                this.getCurrent().keepYawText = true;
                this.getCurrent().yawText = "";
                this.yawTextField.m_94144_(this.getCurrent().yawText);
                b.f_93623_ = false;
            }).m_252987_(this.f_96543_ / 2 + 111, 134, 20, 20).m_253136_();
            this.m_142416_((GuiEventListener)this.defaultYawButton);
            boolean bl = this.defaultYawButton.f_93623_ = !this.getCurrent().keepYawText;
        }
        if (this.getCurrent().defaultKeepDisabledOrTemporary) {
            this.defaultDisabledButton = Button.m_253074_((Component)Component.m_237113_((String)"-"), b -> {
                this.getCurrent().keepDisabledOrTemporary = true;
                this.getCurrent().disabledOrTemporary = 0;
                this.disableButton.m_93666_(this.getDisableButtonText());
                b.f_93623_ = false;
            }).m_252987_(this.f_96543_ / 2 + 110, 164, 20, 20).m_253136_();
            this.m_142416_((GuiEventListener)this.defaultDisabledButton);
            boolean bl = this.defaultDisabledButton.f_93623_ = !this.getCurrent().keepDisabledOrTemporary;
        }
        if (this.getCurrent().defaultKeepVisibilityType) {
            this.defaultVisibilityTypeButton = Button.m_253074_((Component)Component.m_237113_((String)"-"), b -> {
                this.getCurrent().keepVisibilityType = true;
                this.getCurrent().visibilityType = WaypointVisibilityType.LOCAL;
                this.visibilityTypeButton.m_93666_(this.getCurrent().visibilityType.getTranslation());
                b.f_93623_ = false;
            }).m_252987_(this.f_96543_ / 2 - 130, 164, 20, 20).m_253136_();
            this.m_142416_((GuiEventListener)this.defaultVisibilityTypeButton);
            boolean bl = this.defaultVisibilityTypeButton.f_93623_ = !this.getCurrent().keepVisibilityType;
        }
        if (hideWaypointCoordinatesConfig) {
            this.m_142416_((GuiEventListener)new MySuperTinyButton(this.f_96543_ / 2 + 115, 134, (Component)Component.m_237115_((String)(this.censorCoordsIfNeeded ? "gui.xaero_waypoints_edit_show" : "gui.xaero_waypoints_edit_hide")), b -> {
                this.censorCoordsIfNeeded = !this.censorCoordsIfNeeded;
                b.m_93666_((Component)Component.m_237115_((String)(this.censorCoordsIfNeeded ? "gui.xaero_waypoints_edit_show" : "gui.xaero_waypoints_edit_hide")));
            }));
        }
        WaypointColor currentColor = this.getCurrent().color;
        this.colorDD = DropDownWidget.Builder.begin().setOptions(this.createColorOptions()).setX(this.f_96543_ / 2 - 60).setY(82).setW(120).setSelected(Integer.valueOf((currentColor == null ? -1 : currentColor.ordinal()) + (this.getCurrent().defaultKeepColor ? 1 : 0))).setCallback((IDropDownWidgetCallback)this).setContainer((IDropDownContainer)this).setNarrationTitle((Component)Component.m_237115_((String)"gui.xaero_dropdown_waypoint_color")).build();
        this.m_7787_((GuiEventListener)this.colorDD);
        this.setsDD = this.createSetsDropdown();
        this.m_7787_((GuiEventListener)this.setsDD);
        this.containersDD = this.createContainersDropdown();
        this.m_7787_((GuiEventListener)this.containersDD);
        this.worldsDD = this.createWorldsDropdown();
        this.m_7787_((GuiEventListener)this.worldsDD);
        this.m_7522_((GuiEventListener)this.nameTextField);
        this.nameTextField.m_93692_(true);
        this.updateConfirmButton();
    }

    public EditBox applyEditBoxResponder(EditBox box) {
        box.m_94151_(s -> {
            if (!this.ignoreEditBoxChanges) {
                this.postType((GuiEventListener)box);
            }
        });
        return box;
    }

    private DropDownWidget createSetsDropdown() {
        return DropDownWidget.Builder.begin().setOptions(this.sets.getOptions()).setX(this.f_96543_ / 2 - 101).setY(60).setW(201).setSelected(Integer.valueOf(this.sets.getCurrentSet())).setCallback((IDropDownWidgetCallback)this).setContainer((IDropDownContainer)this).setNarrationTitle((Component)Component.m_237115_((String)"gui.xaero_dropdown_waypoint_set")).build();
    }

    private DropDownWidget createContainersDropdown() {
        return DropDownWidget.Builder.begin().setOptions(this.containers.options).setX(this.f_96543_ / 2 - 203).setY(38).setW(200).setSelected(Integer.valueOf(this.containers.current)).setCallback((IDropDownWidgetCallback)this).setContainer((IDropDownContainer)this).setNarrationTitle((Component)Component.m_237115_((String)"gui.xaero_dropdown_waypoint_container")).build();
    }

    private DropDownWidget createWorldsDropdown() {
        return DropDownWidget.Builder.begin().setOptions(this.worlds.options).setX(this.f_96543_ / 2 + 2).setY(38).setW(200).setSelected(Integer.valueOf(this.worlds.current)).setCallback((IDropDownWidgetCallback)this).setContainer((IDropDownContainer)this).setNarrationTitle((Component)Component.m_237115_((String)"gui.xaero_dropdown_waypoint_world")).build();
    }

    private Component getDisableButtonText() {
        return Component.m_237115_((String)(this.getCurrent().disabledOrTemporary == 3 ? "gui.xaero_destination" : (this.getCurrent().disabledOrTemporary == 1 ? "gui.xaero_toggle_disabled" : (this.getCurrent().disabledOrTemporary == 0 ? "gui.xaero_toggle_enabled" : "gui.xaero_temporary2"))));
    }

    private WaypointEditForm getCurrent() {
        return this.getMutualEditConfig() ? this.mutualForm : this.editForms.get(this.selectedWaypointIndex);
    }

    public boolean m_7933_(int par1, int par2, int par3) {
        GuiEventListener focused = this.m_7222_();
        this.preType(focused);
        this.ignoreEditBoxChanges = false;
        boolean result = super.m_7933_(par1, par2, par3);
        if (this.ignoreEditBoxChanges) {
            this.canBeLabyMod = false;
        }
        if (focused instanceof EditBox && this.canConfirm() && (par1 == 257 || par1 == 335)) {
            this.confirmButton.m_5716_(0.0, 0.0);
            return true;
        }
        return result;
    }

    public boolean m_5534_(char par1, int par2) {
        GuiEventListener focused = this.m_7222_();
        this.preType(focused);
        this.ignoreEditBoxChanges = false;
        boolean result = super.m_5534_(par1, par2);
        if (this.ignoreEditBoxChanges) {
            this.canBeLabyMod = false;
        }
        return result;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.ignoreEditBoxChanges = false;
        boolean result = super.m_6375_(mouseX, mouseY, button);
        if (this.ignoreEditBoxChanges) {
            this.canBeLabyMod = false;
        }
        return result;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.ignoreEditBoxChanges = false;
        boolean result = super.m_6348_(mouseX, mouseY, button);
        if (this.ignoreEditBoxChanges) {
            this.canBeLabyMod = false;
        }
        return result;
    }

    private void preType(GuiEventListener focused) {
        if (focused == null) {
            return;
        }
    }

    private void postType(GuiEventListener focused) {
        this.ignoreEditBoxChanges = true;
        if (focused == null) {
            return;
        }
        if (this.nameTextField == focused) {
            if (!(!this.getCurrent().autoInitial || this.nameTextField.m_94155_().length() <= 0 || this.getCurrent().keepInitial && this.getMutualEditConfig())) {
                this.initialTextField.m_94144_(this.nameTextField.m_94155_().substring(0, 1).toUpperCase());
            }
        } else if (this.initialTextField == focused) {
            this.getCurrent().autoInitial = false;
        }
        this.checkFields(focused);
        this.updateConfirmButton();
    }

    public void m_7522_(GuiEventListener l) {
        this.preType(l);
        GuiEventListener currentFocused = this.m_7222_();
        if (currentFocused != null && currentFocused != l && currentFocused instanceof EditBox) {
            ((EditBox)currentFocused).m_93692_(false);
        }
        super.m_7522_(l);
    }

    private boolean canConfirm() {
        WaypointEditForm current = this.getCurrent();
        return !(!current.keepName && current.name.length() <= 0 || !current.keepInitial && current.initial.length() <= 0);
    }

    private void updateConfirmButton() {
        this.confirmButton.f_93623_ = this.modeSwitchButton.f_93623_ = this.canConfirm();
        this.leftButton.f_93623_ = !this.getMutualEditConfig() && this.canConfirm() && this.selectedWaypointIndex > 0;
        this.rightButton.f_93623_ = !this.getMutualEditConfig() && this.canConfirm() && this.selectedWaypointIndex < this.editForms.size() - 1;
    }

    private void handleCoordinateInputSpaces(EditBox coordinateBox, EditBox nextBox) {
        String startingBoxValue = coordinateBox.m_94155_();
        int indexOfFirstSpace = startingBoxValue.indexOf(32);
        if (indexOfFirstSpace != -1) {
            String subStringToCut = startingBoxValue.substring(indexOfFirstSpace + 1);
            coordinateBox.m_94144_(startingBoxValue.substring(0, indexOfFirstSpace));
            coordinateBox.m_94198_();
            nextBox.m_94144_(nextBox.m_94155_() + subStringToCut);
            if (this.m_7222_() == coordinateBox) {
                coordinateBox.m_93692_(false);
                nextBox.m_93692_(true);
                this.m_7522_((GuiEventListener)nextBox);
                nextBox.m_94201_();
            }
        }
    }

    protected void checkFields(GuiEventListener focused) {
        this.handleCoordinateInputSpaces(this.xTextField, this.yTextField);
        this.handleCoordinateInputSpaces(this.yTextField, this.zTextField);
        this.handleCoordinateInputSpaces(this.zTextField, this.yawTextField);
        this.fieldValidator.validate(this.yawTextField);
        if (this.yawTextField == focused) {
            this.getCurrent().keepYawText = false;
            if (this.defaultYawButton != null) {
                this.defaultYawButton.f_93623_ = true;
            }
        }
        this.fieldValidator.validate(this.xTextField);
        this.fieldYValidator.validate(this.yTextField);
        this.fieldValidator.validate(this.zTextField);
        WaypointEditForm current = this.getCurrent();
        current.name = this.nameTextField.m_94155_();
        current.xText = this.xTextField.m_94155_();
        current.yText = this.yTextField.m_94155_();
        current.zText = this.zTextField.m_94155_();
        current.yawText = this.yawTextField.m_94155_();
        current.initial = this.initialTextField.m_94155_();
        if (current.initial.length() > 2) {
            current.initial = current.initial.substring(0, 2);
            this.initialTextField.m_94144_(current.initial);
        }
        if (current.yawText.length() > 4) {
            current.yawText = current.yawText.substring(0, 4);
            this.yawTextField.m_94144_(current.yawText);
        }
        if (this.prefilled && this.editForms.size() > 1 && this.getMutualEditConfig()) {
            current.keepName = current.name.isEmpty();
            current.keepXText = current.xText.isEmpty();
            current.keepYText = current.yText.isEmpty();
            current.keepZText = current.zText.isEmpty();
            current.keepInitial = current.initial.isEmpty();
        }
    }

    public void m_86600_() {
        if (this.f_96541_.f_91075_ == null) {
            this.f_96541_.m_91152_(null);
            return;
        }
        this.nameTextField.m_94120_();
        this.xTextField.m_94120_();
        this.yTextField.m_94120_();
        this.zTextField.m_94120_();
        this.yawTextField.m_94120_();
        this.initialTextField.m_94120_();
    }

    public void m_88315_(GuiGraphics guiGraphics, int par1, int par2, float par3) {
        this.renderEscapeScreen(guiGraphics, par1, par2, par3);
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, par1, par2, par3);
        super.renderTooltips(guiGraphics, par1, par2, par3);
    }

    protected void renderPreDropdown(GuiGraphics guiGraphics, int mouseX, int mouseY, float partial) {
        super.renderPreDropdown(guiGraphics, mouseX, mouseY, partial);
        guiGraphics.m_280137_(this.f_96547_, this.screenTitle, this.f_96543_ / 2, 20, 0xFFFFFF);
        WaypointEditForm current = this.getCurrent();
        if (!this.canBeLabyMod) {
            this.ignoreEditBoxChanges = true;
        }
        if (this.ignoreEditBoxChanges) {
            if (!this.nameTextField.m_93696_() && current.keepName) {
                GuiUtils.setFieldText((EditBox)this.nameTextField, (String)this.namePlaceholder, (int)-11184811);
                this.nameTextField.m_94192_(0);
            }
            XaeroPath destinationWorldKeys = (XaeroPath)this.worlds.getCurrentKey();
            MinimapWorld destinationWorld = this.manager.getWorld(destinationWorldKeys);
            double waypointDimScale = this.session.getDimensionHelper().getDimCoordinateScale(destinationWorld);
            if (current.keepXText) {
                if (!this.xTextField.m_93696_()) {
                    GuiUtils.setFieldText((EditBox)this.xTextField, (String)this.xPlaceholder, (int)-11184811);
                }
            } else if (current.xText.isEmpty()) {
                GuiUtils.setFieldText((EditBox)this.xTextField, (String)("" + this.getAutomaticX(waypointDimScale)), (int)-11184811);
                this.xTextField.m_94192_(0);
            }
            if (current.keepYText) {
                if (!this.yTextField.m_93696_()) {
                    GuiUtils.setFieldText((EditBox)this.yTextField, (String)this.yPlaceholder, (int)-11184811);
                }
            } else if (current.yText.isEmpty()) {
                GuiUtils.setFieldText((EditBox)this.yTextField, (String)this.getAutomaticYInput(destinationWorld), (int)-11184811);
                this.yTextField.m_94192_(0);
            }
            if (current.keepZText) {
                if (!this.zTextField.m_93696_()) {
                    GuiUtils.setFieldText((EditBox)this.zTextField, (String)this.zPlaceholder, (int)-11184811);
                }
            } else if (current.zText.isEmpty()) {
                GuiUtils.setFieldText((EditBox)this.zTextField, (String)("" + this.getAutomaticZ(waypointDimScale)), (int)-11184811);
                this.zTextField.m_94192_(0);
            }
            if (!this.yawTextField.m_93696_() && current.yawText.isEmpty()) {
                if (current.keepYawText) {
                    GuiUtils.setFieldText((EditBox)this.yawTextField, (String)this.yawPlaceholder, (int)-11184811);
                } else {
                    GuiUtils.setFieldText((EditBox)this.yawTextField, (String)I18n.m_118938_((String)"gui.xaero_yaw", (Object[])new Object[0]), (int)-11184811);
                }
                this.yawTextField.m_94192_(0);
            }
            if (!this.initialTextField.m_93696_() && current.initial.isEmpty()) {
                if (current.keepInitial) {
                    GuiUtils.setFieldText((EditBox)this.initialTextField, (String)this.initialPlaceholder, (int)-11184811);
                } else {
                    GuiUtils.setFieldText((EditBox)this.initialTextField, (String)I18n.m_118938_((String)"gui.xaero_initial", (Object[])new Object[0]), (int)-11184811);
                }
                this.initialTextField.m_94192_(0);
            }
        }
        this.nameTextField.m_88315_(guiGraphics, mouseX, mouseY, partial);
        this.xTextField.m_88315_(guiGraphics, mouseX, mouseY, partial);
        this.yTextField.m_88315_(guiGraphics, mouseX, mouseY, partial);
        this.zTextField.m_88315_(guiGraphics, mouseX, mouseY, partial);
        this.yawTextField.m_88315_(guiGraphics, mouseX, mouseY, partial);
        this.initialTextField.m_88315_(guiGraphics, mouseX, mouseY, partial);
        if (this.ignoreEditBoxChanges) {
            GuiUtils.setFieldText((EditBox)this.nameTextField, (String)current.name);
            GuiUtils.setFieldText((EditBox)this.xTextField, (String)current.xText);
            GuiUtils.setFieldText((EditBox)this.yTextField, (String)current.yText);
            GuiUtils.setFieldText((EditBox)this.zTextField, (String)current.zText);
            GuiUtils.setFieldText((EditBox)this.yawTextField, (String)current.yawText);
            GuiUtils.setFieldText((EditBox)this.initialTextField, (String)current.initial);
        }
        this.ignoreEditBoxChanges = true;
    }

    public boolean onSelected(DropDownWidget menu, int selected) {
        if (menu == this.setsDD) {
            this.sets.setCurrentSet(selected);
            if (this.session.getWorldState().getCurrentWorldPath().equals(this.worlds.getCurrentKey())) {
                this.manager.getCurrentWorld().setCurrentWaypointSetId(this.sets.getCurrentSetKey());
                try {
                    this.session.getWorldManagerIO().saveWorld(this.manager.getCurrentWorld());
                }
                catch (IOException e) {
                    MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
                }
            }
        } else if (menu == this.colorDD) {
            this.getCurrent().color = !this.getCurrent().defaultKeepColor ? WaypointColor.fromIndex(selected) : (selected == 0 ? null : WaypointColor.fromIndex(selected - 1));
        } else if (menu == this.containersDD) {
            this.containers.current = selected;
            MinimapWorld currentWorld = this.containers.current != this.defaultContainer ? this.manager.getRootWorldContainer((String)this.containers.getCurrentKey()).getFirstWorld() : this.defaultWorld;
            this.sets = new GuiWaypointSets(false, currentWorld, this.containers.current == this.defaultContainer ? this.fromSet : currentWorld.getCurrentWaypointSetId());
            this.worlds = new GuiWaypointWorlds(this.manager.getRootWorldContainer((String)this.containers.getCurrentKey()), this.session, currentWorld.getFullPath(), this.frozenAutoWorldPath);
            this.setsDD = this.createSetsDropdown();
            this.replaceWidget((AbstractWidget)this.setsDD, (AbstractWidget)this.setsDD);
            this.worldsDD = this.createWorldsDropdown();
            this.replaceWidget((AbstractWidget)this.worldsDD, (AbstractWidget)this.worldsDD);
        } else if (menu == this.worldsDD) {
            MinimapWorld currentWorld;
            this.worlds.current = selected;
            XaeroPath worldKeys = (XaeroPath)this.worlds.getCurrentKey();
            this.sets = new GuiWaypointSets(false, currentWorld, (currentWorld = this.manager.getWorld(worldKeys)) == this.defaultWorld ? this.fromSet : currentWorld.getCurrentWaypointSetId());
            this.setsDD = this.createSetsDropdown();
            this.replaceWidget((AbstractWidget)this.setsDD, (AbstractWidget)this.setsDD);
        }
        return true;
    }
}

