/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.graphics.renderer.multitexture;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.systems.GpuDevice;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.renderer.RenderType;
import xaero.lib.client.graphics.DynamicImmediateGpuBuffer;
import xaero.lib.client.graphics.ICompositeRenderType;
import xaero.lib.client.graphics.ICompositeState;
import xaero.lib.client.graphics.XaeroRenderType;
import xaero.lib.client.graphics.util.ImmediateRenderUtil;

public class MultiTextureRenderTypeRenderer {
    private static final String RENDER_PASS_NAME = "xaero multitexture render pass";
    private boolean used;
    private ByteBufferBuilder sharedBuffer = new ByteBufferBuilder(16384);
    private BufferBuilder currentBufferBuilder;
    private List<MeshData> buffersForDrawCalls = new ArrayList<MeshData>();
    private List<RenderPass.Draw<MultiTextureRenderTypeRenderer>> drawCallBuilder;
    private DynamicImmediateGpuBuffer immediateVertexBuffer;
    private ArrayList<GpuTexture> texturesForDrawCalls = new ArrayList();
    private Consumer<GpuTexture> textureBinder;
    private Consumer<GpuTexture> textureFinalizer;
    private GpuTexture prevTexture;
    private RenderType renderType;

    MultiTextureRenderTypeRenderer() {
        this.drawCallBuilder = new ArrayList<RenderPass.Draw<MultiTextureRenderTypeRenderer>>();
    }

    void init(Consumer<GpuTexture> textureBinder, Consumer<GpuTexture> textureFinalizer, RenderType renderType) {
        if (this.used) {
            throw new IllegalStateException("Multi-texture renderer already in use!");
        }
        if (!(renderType instanceof ICompositeRenderType)) {
            throw new IllegalArgumentException("Not a usable render type!");
        }
        this.used = true;
        this.textureBinder = textureBinder;
        this.textureFinalizer = textureFinalizer;
        this.prevTexture = null;
        this.renderType = renderType;
    }

    void draw() {
        if (!this.used) {
            throw new IllegalStateException("Multi-texture renderer is not in use!");
        }
        if (!this.texturesForDrawCalls.isEmpty()) {
            GpuTextureView colorTarget;
            Consumer<GpuTexture> textureBinder = this.textureBinder;
            Consumer<GpuTexture> textureFinalizer = this.textureFinalizer;
            boolean hasTextureFinalizer = textureFinalizer != null;
            this.endBuffer(this.currentBufferBuilder);
            RenderPipeline renderPipeline = ((ICompositeRenderType)this.renderType).xaero_lib_getRenderPipeline();
            ICompositeState compositeState = ((ICompositeRenderType)this.renderType).xaero_lib_getState();
            RenderTarget target = XaeroRenderType.getOutputStateTarget((Object)compositeState.xaero_lib_getOutputState());
            for (int i = 0; i < this.texturesForDrawCalls.size(); ++i) {
                GpuTexture texture = this.texturesForDrawCalls.get(i);
                MeshData meshData = this.buffersForDrawCalls.get(i);
                this.drawCallBuilder.add(this.createDrawCall(meshData, texture, renderPipeline));
                meshData.close();
            }
            this.renderType.setupRenderState();
            GpuTextureView gpuTextureView = colorTarget = RenderSystem.outputColorTextureOverride != null ? RenderSystem.outputColorTextureOverride : target.getColorTextureView();
            GpuTextureView depthTarget = target.useDepth ? (RenderSystem.outputDepthTextureOverride != null ? RenderSystem.outputDepthTextureOverride : target.getDepthTextureView()) : null;
            try (RenderPass renderPass = ImmediateRenderUtil.createRenderPass((String)RENDER_PASS_NAME, (RenderPipeline)renderPipeline, (GpuTextureView)colorTarget, (GpuTextureView)depthTarget);){
                renderPass.drawMultipleIndexed(this.drawCallBuilder, null, null, Collections.emptyList(), (Object)this);
            }
            if (hasTextureFinalizer) {
                for (int i = 0; i < this.texturesForDrawCalls.size(); ++i) {
                    GpuTexture texture = this.texturesForDrawCalls.get(i);
                    textureFinalizer.accept(texture);
                }
            }
            textureBinder.accept(null);
            this.renderType.clearRenderState();
        }
        this.drawCallBuilder.clear();
        this.texturesForDrawCalls.clear();
        this.buffersForDrawCalls.clear();
        if (this.immediateVertexBuffer != null) {
            this.immediateVertexBuffer.clear();
        }
        this.used = false;
        this.renderType = null;
    }

    private RenderPass.Draw<MultiTextureRenderTypeRenderer> createDrawCall(MeshData meshData, GpuTexture texture, RenderPipeline renderPipeline) {
        ByteBuffer indexBuffer = meshData.indexBuffer();
        if (indexBuffer != null) {
            throw new IllegalArgumentException();
        }
        GpuBufferSlice gpuVertexBufferSlice = this.uploadImmediateVertexBuffer(meshData.vertexBuffer());
        long sliceOffset = gpuVertexBufferSlice.offset();
        int sliceOffsetInVertices = (int)(sliceOffset / (long)this.renderType.format().getVertexSize());
        int firstIndex = this.renderType.mode().indexCount(sliceOffsetInVertices);
        RenderSystem.AutoStorageIndexBuffer sequentialBuffer = RenderSystem.getSequentialBuffer((VertexFormat.Mode)this.renderType.mode());
        GpuBuffer gpuIndexBuffer = sequentialBuffer.getBuffer(firstIndex + meshData.drawState().indexCount());
        VertexFormat.IndexType gpuIndexType = sequentialBuffer.type();
        return new RenderPass.Draw(0, gpuVertexBufferSlice.buffer(), gpuIndexBuffer, gpuIndexType, firstIndex, meshData.drawState().indexCount(), (context, uu) -> this.textureBinder.accept(texture));
    }

    private GpuBufferSlice uploadImmediateVertexBuffer(ByteBuffer vertexBuffer) {
        GpuDevice gpuDevice = RenderSystem.getDevice();
        if (this.immediateVertexBuffer == null) {
            this.immediateVertexBuffer = new DynamicImmediateGpuBuffer(vertexBuffer.remaining(), 32);
        }
        GpuBufferSlice slice = this.immediateVertexBuffer.allocateSlice(vertexBuffer.remaining());
        gpuDevice.createCommandEncoder().writeToBuffer(slice, vertexBuffer);
        return slice;
    }

    private void endBuffer(BufferBuilder builder) {
        this.buffersForDrawCalls.add(builder.build());
    }

    public BufferBuilder begin(GpuTexture texture) {
        if (!this.used) {
            throw new IllegalStateException("Multi-texture renderer is not in use!");
        }
        if (texture == null) {
            throw new IllegalStateException("Attempted to use the multi-texture renderer with texture null!");
        }
        if (texture != this.prevTexture) {
            if (this.prevTexture != null) {
                this.endBuffer(this.currentBufferBuilder);
            }
            this.currentBufferBuilder = new BufferBuilder(this.sharedBuffer, this.renderType.mode(), this.renderType.format());
            this.prevTexture = texture;
            this.texturesForDrawCalls.add(texture);
        }
        return this.currentBufferBuilder;
    }
}

