/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.radar.icon.creator;

import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import org.lwjgl.opengl.GL11;
import xaero.common.exception.OpenGLException;
import xaero.common.graphics.ImprovedFramebuffer;
import xaero.common.icon.XaeroIcon;
import xaero.common.icon.XaeroIconAtlas;
import xaero.common.icon.XaeroIconAtlasManager;
import xaero.common.misc.Misc;
import xaero.hud.compat.mods.ImmediatelyFastHelper;
import xaero.hud.minimap.MinimapLogs;
import xaero.hud.minimap.radar.icon.RadarIconManager;
import xaero.hud.minimap.radar.icon.creator.render.form.IRadarIconFormPrerenderer;
import xaero.hud.minimap.radar.icon.creator.render.trace.EntityRenderTracer;
import xaero.hud.minimap.radar.icon.creator.render.trace.ModelRenderTrace;
import xaero.hud.minimap.radar.icon.definition.form.RadarIconForm;
import xaero.hud.minimap.radar.icon.definition.form.model.config.RadarIconModelConfig;
import xaero.lib.client.graphics.util.ImmediateRenderUtil;

public class RadarIconCreator {
    private static final int PREFERRED_ATLAS_WIDTH = 1024;
    public static final int ICON_WIDTH = 64;
    public static final int FAR_PLANE = 500;
    private ImprovedFramebuffer formRenderFramebuffer;
    private ImprovedFramebuffer iconRenderFramebuffer;
    private ImprovedFramebuffer atlasRenderFramebuffer;
    private final EntityRenderTracer renderTracer = new EntityRenderTracer();
    private final XaeroIconAtlasManager iconAtlasManager;

    public RadarIconCreator() {
        int maxTextureSize = GlStateManager.func_187397_v((int)3379);
        int atlasTextureSize = Math.min(maxTextureSize, 1024) / 64 * 64;
        this.iconAtlasManager = new XaeroIconAtlasManager(64, atlasTextureSize, new ArrayList<XaeroIconAtlas>());
        this.initFramebuffers(atlasTextureSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Entity> XaeroIcon create(Render<? super T> entityRenderer, T entity, Framebuffer defaultFramebuffer, Parameters parameters, ScaledResolution scaledRes) {
        IRadarIconFormPrerenderer formPrerenderer = parameters.form.getPrerenderer();
        if (formPrerenderer == null) {
            MinimapLogs.LOGGER.error("Tried prerendering radar icon for {} variant {} but the icon form used doesn't have a prerenderer!", (Object)EntityList.func_191301_a(entity), parameters.variant);
            return RadarIconManager.FAILED;
        }
        OpenGLException.checkGLError();
        ImmediatelyFastHelper.triggerBatchingBuffersFlush();
        this.formRenderFramebuffer.func_147610_a(true);
        this.setupMatrices(64, 500);
        OpenGLException.checkGLError();
        List<ModelRenderTrace> traceResult = null;
        ModelBase entityModel = null;
        GlStateManager.func_179097_i();
        if (formPrerenderer.requiresEntityModel()) {
            GlStateManager.func_179126_j();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179129_p();
            if (Minecraft.func_71410_x().func_175598_ae().field_78734_h != null) {
                traceResult = this.renderTracer.trace(entity, entityRenderer);
                this.formRenderFramebuffer.func_147610_a(true);
            } else {
                MinimapLogs.LOGGER.info("Render info was null for entity " + EntityList.func_191301_a(entity));
            }
            GlStateManager.func_179097_i();
            entityModel = this.renderTracer.getEntityRendererModel(entityRenderer);
            if (entityModel == null) {
                GlStateManager.func_179138_g((int)33985);
                GlStateManager.func_179090_x();
                GlStateManager.func_179138_g((int)33984);
                this.endFormRendering();
                this.bindDefaultFramebuffer(defaultFramebuffer);
                this.restoreMatrices(defaultFramebuffer, scaledRes);
                return RadarIconManager.FAILED;
            }
        }
        GlStateManager.func_179138_g((int)33985);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)33984);
        RenderHelper.func_74518_a();
        boolean formRenderResult = false;
        GlStateManager.func_179094_E();
        try {
            GlStateManager.func_179118_c();
            GlStateManager.func_179084_k();
            GlStateManager.func_179082_a((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179086_m((int)16640);
            GlStateManager.func_179126_j();
            formRenderResult = formPrerenderer.prerender(entityRenderer, entityModel, entity, traceResult, parameters);
        }
        catch (Throwable t) {
            MinimapLogs.LOGGER.error("Exception using the radar icon form prerenderer for entity {} variant {}!", (Object)EntityList.func_191301_a(entity), parameters.variant, (Object)t);
        }
        finally {
            GlStateManager.func_179121_F();
        }
        this.endFormRendering();
        XaeroIcon icon = parameters.form.getFailureResult();
        if (formRenderResult) {
            icon = this.getFinalIcon(entity, formPrerenderer, parameters);
        }
        this.restoreMatrices(defaultFramebuffer, scaledRes);
        this.atlasRenderFramebuffer.func_147609_e();
        this.bindDefaultFramebuffer(defaultFramebuffer);
        return icon;
    }

    private XaeroIcon getFinalIcon(Entity entity, IRadarIconFormPrerenderer formPrerenderer, Parameters parameters) {
        this.iconRenderFramebuffer.func_147610_a(true);
        GlStateManager.func_179082_a((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179086_m((int)16384);
        GlStateManager.func_179084_k();
        if (parameters.debug) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)18.0f, (float)10.0f, (float)-10.0f);
            GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)1.0f);
            Gui.func_73734_a((int)0, (int)0, (int)9, (int)9, (int)-16776961);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179121_F();
            GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)771);
        }
        this.formRenderFramebuffer.func_147612_c();
        boolean outlined = formPrerenderer.isOutlined();
        boolean flipped = formPrerenderer.isFlipped();
        if (outlined) {
            this.renderOutline();
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179084_k();
        ImmediateRenderUtil.texturedRect((float)0.0f, (float)0.0f, (int)0, (int)0, (float)64.0f, (float)64.0f, (float)64.0f, (float)64.0f);
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)771);
        if (parameters.debug) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)27.0f, (float)10.0f, (float)-10.0f);
            GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)1.0f);
            Gui.func_73734_a((int)0, (int)0, (int)9, (int)9, (int)-16711681);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179121_F();
            GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)771);
        }
        GlStateManager.func_179147_l();
        this.iconRenderFramebuffer.func_147609_e();
        this.iconRenderFramebuffer.func_147612_c();
        this.iconRenderFramebuffer.generateMipmaps();
        GlStateManager.func_179144_i((int)0);
        XaeroIcon icon = null;
        try {
            XaeroIconAtlas atlas = this.getCurrentAtlas();
            icon = atlas.createIcon();
            this.atlasRenderFramebuffer.func_147610_a(false);
            GlStateManager.func_179083_b((int)icon.getOffsetX(), (int)icon.getOffsetY(), (int)64, (int)64);
            this.atlasRenderFramebuffer.setFramebufferTexture(atlas.getTextureId());
            this.atlasRenderFramebuffer.func_147611_b();
            this.iconRenderFramebuffer.func_147612_c();
            GlStateManager.func_179118_c();
            GlStateManager.func_179084_k();
            if (flipped) {
                ImmediateRenderUtil.texturedRect((float)0.0f, (float)0.0f, (int)0, (int)64, (float)64.0f, (float)64.0f, (float)-64.0f, (float)64.0f);
            } else {
                ImmediateRenderUtil.texturedRect((float)0.0f, (float)0.0f, (int)0, (int)0, (float)64.0f, (float)64.0f, (float)64.0f, (float)64.0f);
            }
            if (parameters.debug) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)36.0f, (float)10.0f, (float)-10.0f);
                GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)1.0f);
                Gui.func_73734_a((int)0, (int)0, (int)9, (int)9, (int)-256);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179121_F();
                GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)771);
            }
        }
        catch (Throwable t) {
            MinimapLogs.LOGGER.error("Exception rendering to a entity icon atlas for {} {}!", (Object)EntityList.func_191301_a((Entity)entity), parameters.variant, (Object)t);
        }
        GlStateManager.func_179141_d();
        GlStateManager.func_179147_l();
        GlStateManager.func_179144_i((int)0);
        return icon;
    }

    private void renderOutline() {
        GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179141_d();
        GlStateManager.func_179092_a((int)516, (float)0.05f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)1);
        for (int shadowOffsetX = -1; shadowOffsetX < 2; ++shadowOffsetX) {
            for (int shadowOffsetY = -1; shadowOffsetY < 2; ++shadowOffsetY) {
                if (shadowOffsetX == 0 && shadowOffsetY == 0) continue;
                ImmediateRenderUtil.drawOutlineLayer((float)shadowOffsetX, (float)shadowOffsetY, (int)0, (int)0, (float)64.0f, (float)64.0f, (float)64.0f, (float)64.0f);
            }
        }
    }

    private void setupMatrices(int finalIconSize, int farPlane) {
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179096_D();
        GlStateManager.func_179130_a((double)0.0, (double)finalIconSize, (double)finalIconSize, (double)0.0, (double)-1.0, (double)farPlane);
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179094_E();
        GlStateManager.func_179096_D();
    }

    private void restoreMatrices(Framebuffer framebuffer, ScaledResolution scaledRes) {
        GlStateManager.func_179121_F();
        GlStateManager.func_179128_n((int)5889);
        Misc.defaultOrtho(framebuffer, scaledRes);
        GlStateManager.func_179128_n((int)5888);
    }

    private void endFormRendering() {
        this.formRenderFramebuffer.func_147609_e();
        GlStateManager.func_179147_l();
        RenderHelper.func_74519_b();
        RenderHelper.func_74518_a();
        GlStateManager.func_179141_d();
        GlStateManager.func_179092_a((int)516, (float)0.0f);
    }

    private void bindDefaultFramebuffer(Framebuffer defaultFramebuffer) {
        if (defaultFramebuffer != null) {
            defaultFramebuffer.func_147610_a(true);
            return;
        }
        Minecraft.func_71410_x().func_147110_a().func_147610_a(false);
        GlStateManager.func_179083_b((int)0, (int)0, (int)Minecraft.func_71410_x().field_71443_c, (int)Minecraft.func_71410_x().field_71440_d);
    }

    public void clearAtlases() {
        this.iconAtlasManager.clearAtlases();
        this.atlasRenderFramebuffer.setFramebufferTexture(0);
    }

    public EntityRenderTracer getRenderTracer() {
        return this.renderTracer;
    }

    private XaeroIconAtlas getCurrentAtlas() {
        return this.iconAtlasManager.getCurrentAtlas();
    }

    private void initFramebuffers(int atlasTextureSize) {
        this.formRenderFramebuffer = new ImprovedFramebuffer(512, 512, true);
        OpenGLException.checkGLError();
        this.iconRenderFramebuffer = new ImprovedFramebuffer(512, 512, false);
        OpenGLException.checkGLError();
        this.formRenderFramebuffer.func_147612_c();
        OpenGLException.checkGLError();
        GL11.glTexParameteri((int)3553, (int)33085, (int)0);
        GL11.glTexParameterf((int)3553, (int)33082, (float)0.0f);
        GL11.glTexParameterf((int)3553, (int)33083, (float)0.0f);
        GL11.glTexParameterf((int)3553, (int)34049, (float)0.0f);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
        GlStateManager.func_187419_a((int)3553, (int)0, (int)32856, (int)this.formRenderFramebuffer.field_147621_c, (int)this.formRenderFramebuffer.field_147618_d, (int)0, (int)32993, (int)32821, (IntBuffer)null);
        OpenGLException.checkGLError();
        GlStateManager.func_179144_i((int)0);
        this.iconRenderFramebuffer.func_147612_c();
        GL11.glTexParameteri((int)3553, (int)33085, (int)3);
        GL11.glTexParameterf((int)3553, (int)33082, (float)0.0f);
        GL11.glTexParameterf((int)3553, (int)33083, (float)3.0f);
        GL11.glTexParameterf((int)3553, (int)34049, (float)0.0f);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9984);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
        GlStateManager.func_187419_a((int)3553, (int)0, (int)32856, (int)this.iconRenderFramebuffer.field_147621_c, (int)this.iconRenderFramebuffer.field_147618_d, (int)0, (int)32993, (int)32821, (IntBuffer)null);
        OpenGLException.checkGLError();
        GlStateManager.func_179144_i((int)0);
        this.atlasRenderFramebuffer = new ImprovedFramebuffer(atlasTextureSize, atlasTextureSize, false);
        OpenGLException.checkGLError();
        GlStateManager.func_179150_h((int)this.atlasRenderFramebuffer.getFramebufferTexture());
        this.atlasRenderFramebuffer.setFramebufferTexture(0);
        OpenGLException.checkGLError();
    }

    public static class Parameters {
        public final Object variant;
        public final float scale;
        public final RadarIconModelConfig defaultModelConfig;
        public final RadarIconForm form;
        public final boolean debug;

        public Parameters(Object variant, RadarIconModelConfig defaultModelConfig, RadarIconForm form, float scale, boolean debug) {
            this.variant = variant;
            this.scale = scale;
            this.defaultModelConfig = defaultModelConfig;
            this.form = form;
            this.debug = debug;
        }
    }
}

