/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.world;

import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import xaero.hud.minimap.world.MinimapWorld;
import xaero.hud.minimap.world.container.MinimapWorldRootContainer;

public class MinimapDimensionHelper {
    public double getDimensionDivision(MinimapWorld minimapWorld) {
        if (Minecraft.m_91087_().f_91073_ == null) {
            return 1.0;
        }
        double dimCoordinateScale = this.getDimCoordinateScale(minimapWorld);
        return Minecraft.m_91087_().f_91073_.m_6042_().m_63959_() / dimCoordinateScale;
    }

    public double getDimCoordinateScale(MinimapWorld minimapWorld) {
        if (minimapWorld == null) {
            return 1.0;
        }
        MinimapWorldRootContainer rootContainer = minimapWorld.getContainer().getRoot();
        ResourceKey<Level> dimKey = minimapWorld.getDimId();
        if (dimKey == null) {
            return 1.0;
        }
        return rootContainer.getDimensionScale(dimKey);
    }

    public String getDimensionDirectoryName(ResourceKey<Level> dimKey) {
        if (dimKey == Level.f_46428_) {
            return "dim%0";
        }
        if (dimKey == Level.f_46429_) {
            return "dim%-1";
        }
        if (dimKey == Level.f_46430_) {
            return "dim%1";
        }
        ResourceLocation identifier = dimKey.m_135782_();
        return "dim%" + identifier.m_135827_() + "$" + identifier.m_135815_().replace('/', '%');
    }

    public ResourceKey<Level> findDimensionKeyForOldName(LocalPlayer player, String oldName) {
        Set allDimensions = player.f_108617_.m_105151_();
        for (ResourceKey dk : allDimensions) {
            if (!oldName.equals(dk.m_135782_().m_135815_().replaceAll("[^a-zA-Z0-9_]+", ""))) continue;
            return dk;
        }
        return null;
    }

    public ResourceKey<Level> getDimensionKeyForDirectoryName(String dirName) {
        String dimIdPart = dirName.substring(4);
        if (dimIdPart.equals("0")) {
            return Level.f_46428_;
        }
        if (dimIdPart.equals("1")) {
            return Level.f_46430_;
        }
        if (dimIdPart.equals("-1")) {
            return Level.f_46429_;
        }
        String[] idArgs = dimIdPart.split("\\$");
        if (idArgs.length < 2) {
            return null;
        }
        return ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(idArgs[0], idArgs[1].replace('%', '/')));
    }
}

