/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.gui;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.input.MouseButtonInfo;
import net.minecraft.network.chat.Component;
import xaero.map.WorldMapSession;
import xaero.map.gui.MySmallButton;
import xaero.map.gui.ScreenBase;
import xaero.map.mods.SupportMods;
import xaero.map.world.MapWorld;

public class GuiMapTpCommand
extends ScreenBase {
    private MySmallButton confirmButton;
    private EditBox commandFormatTextField;
    private EditBox dimensionCommandFormatTextField;
    private String commandFormat;
    private String dimensionCommandFormat;
    private Component waypointCommandHint = Component.translatable((String)"gui.xaero_wm_teleport_command_waypoints_hint");

    public GuiMapTpCommand(Screen parent, Screen escape) {
        super(parent, escape, (Component)Component.translatable((String)"gui.xaero_wm_teleport_command"));
    }

    @Override
    public void init() {
        super.init();
        WorldMapSession session = WorldMapSession.getCurrentSession();
        MapWorld mapWorld = session.getMapProcessor().getMapWorld();
        if (this.commandFormat == null) {
            this.commandFormat = mapWorld.getTeleportCommandFormat();
        }
        if (this.dimensionCommandFormat == null) {
            this.dimensionCommandFormat = mapWorld.getDimensionTeleportCommandFormat();
        }
        this.commandFormatTextField = new EditBox(this.font, this.width / 2 - 100, this.height / 7 + 20, 200, 20, (Component)Component.translatable((String)"gui.xaero_wm_teleport_command"));
        this.commandFormatTextField.setMaxLength(128);
        this.commandFormatTextField.setValue(this.commandFormat);
        this.dimensionCommandFormatTextField = new EditBox(this.font, this.width / 2 - 100, this.height / 7 + 50, 200, 20, (Component)Component.translatable((String)"gui.xaero_wm_dimension_teleport_command"));
        this.dimensionCommandFormatTextField.setMaxLength(256);
        this.dimensionCommandFormatTextField.setValue(this.dimensionCommandFormat);
        this.addWidget(this.commandFormatTextField);
        this.addWidget(this.dimensionCommandFormatTextField);
        if (SupportMods.minimap()) {
            this.addRenderableWidget((GuiEventListener)new MySmallButton(this.width / 2 - 75, this.height / 7 + 118, (Component)Component.translatable((String)"gui.xaero_wm_teleport_command_waypoints"), b -> SupportMods.xaeroMinimap.openWaypointWorldTeleportCommandScreen(this, this.escape)));
        }
        this.confirmButton = new MySmallButton(this.width / 2 - 155, this.height / 6 + 168, (Component)Component.translatable((String)"gui.xaero_confirm"), b -> {
            this.updateFormat();
            if (this.canConfirm()) {
                mapWorld.setTeleportCommandFormat(this.commandFormat);
                mapWorld.setDimensionTeleportCommandFormat(this.dimensionCommandFormat);
                mapWorld.saveConfig();
                this.goBack();
            }
        });
        this.addRenderableWidget((GuiEventListener)this.confirmButton);
        this.addRenderableWidget((GuiEventListener)new MySmallButton(this.width / 2 + 5, this.height / 6 + 168, (Component)Component.translatable((String)"gui.xaero_cancel"), b -> this.goBack()));
    }

    public void renderBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        this.renderEscapeScreen(guiGraphics, 0, 0, f);
        super.renderBackground(guiGraphics, i, j, f);
        guiGraphics.drawCenteredString(this.font, this.title, this.width / 2, 20, -1);
        if (SupportMods.minimap()) {
            guiGraphics.drawCenteredString(this.font, this.waypointCommandHint, this.width / 2, this.height / 7 + 104, -5592406);
        }
        guiGraphics.drawCenteredString(this.font, "{x} {y} {z} {d}", this.width / 2, this.height / 7 + 6, -5592406);
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partial) {
        super.render(guiGraphics, mouseX, mouseY, partial);
        this.commandFormatTextField.render(guiGraphics, mouseX, mouseY, partial);
        this.dimensionCommandFormatTextField.render(guiGraphics, mouseX, mouseY, partial);
    }

    private boolean canConfirm() {
        return this.commandFormat != null && this.commandFormat.length() > 0 && this.dimensionCommandFormat != null && this.dimensionCommandFormat.length() > 0;
    }

    private void updateFormat() {
        this.commandFormat = this.commandFormatTextField.getValue();
        this.dimensionCommandFormat = this.dimensionCommandFormatTextField.getValue();
    }

    public void tick() {
        this.updateFormat();
        this.confirmButton.active = this.canConfirm();
    }

    public boolean keyPressed(KeyEvent event) {
        if (event.key() == 257 && this.commandFormat != null && this.commandFormat.length() > 0) {
            this.confirmButton.onClick(new MouseButtonEvent(0.0, 0.0, new MouseButtonInfo(0, 0)), false);
        }
        return super.keyPressed(event);
    }
}

