/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.message.basic;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import xaero.map.mcworld.WorldMapClientWorldDataHelper;
import xaero.map.message.WorldMapMessage;
import xaero.map.message.client.ClientMessageConsumer;

public class ClientboundRulesPacket
extends WorldMapMessage<ClientboundRulesPacket> {
    public final boolean allowCaveModeOnServer;
    public final boolean allowNetherCaveModeOnServer;

    public ClientboundRulesPacket(boolean allowCaveModeOnServer, boolean allowNetherCaveModeOnServer) {
        this.allowCaveModeOnServer = allowCaveModeOnServer;
        this.allowNetherCaveModeOnServer = allowNetherCaveModeOnServer;
    }

    public void write(FriendlyByteBuf u) {
        CompoundTag nbt = new CompoundTag();
        nbt.putBoolean("cm", this.allowCaveModeOnServer);
        nbt.putBoolean("ncm", this.allowNetherCaveModeOnServer);
        u.writeNbt((Tag)nbt);
    }

    public static ClientboundRulesPacket read(FriendlyByteBuf buffer) {
        CompoundTag nbt = buffer.readNbt();
        return new ClientboundRulesPacket(nbt.getBoolean("cm").orElse(false), nbt.getBoolean("ncm").orElse(false));
    }

    public static class ClientHandler
    implements ClientMessageConsumer<ClientboundRulesPacket> {
        @Override
        public void handle(ClientboundRulesPacket message) {
            WorldMapClientWorldDataHelper.getCurrentWorldData().setSyncedRules(message);
        }
    }
}

