/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.events;

import java.nio.file.Path;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.LevelResource;
import xaero.map.WorldMap;
import xaero.map.common.config.CommonConfig;
import xaero.map.message.basic.ClientboundRulesPacket;
import xaero.map.message.basic.HandshakePacket;
import xaero.map.message.tracker.ClientboundPlayerTrackerResetPacket;
import xaero.map.server.MinecraftServerData;
import xaero.map.server.MineraftServerDataInitializer;
import xaero.map.server.level.LevelMapProperties;
import xaero.map.server.player.IServerPlayer;
import xaero.map.server.player.ServerPlayerData;

public class CommonEvents {
    protected void onPlayerClone(Player oldPlayer, Player newPlayer, boolean alive) {
        if (oldPlayer instanceof ServerPlayer) {
            ServerPlayer oldServerPlayer = (ServerPlayer)oldPlayer;
            ((IServerPlayer)newPlayer).setXaeroWorldMapPlayerData(ServerPlayerData.get(oldServerPlayer));
        }
    }

    public void onServerStarting(MinecraftServer server) {
        new MineraftServerDataInitializer().init(server);
    }

    public void onServerStopped(MinecraftServer server) {
    }

    public void onPlayerLogIn(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            WorldMap.messageHandler.sendToPlayer(serverPlayer, new ClientboundPlayerTrackerResetPacket());
        }
    }

    public void onPlayerWorldJoin(ServerPlayer player) {
        WorldMap.messageHandler.sendToPlayer(player, new HandshakePacket());
        CommonConfig config = WorldMap.commonConfig;
        WorldMap.messageHandler.sendToPlayer(player, new ClientboundRulesPacket(config.allowCaveModeOnServer, config.allowNetherCaveModeOnServer));
        Path propertiesPath = player.level().getServer().getWorldPath(LevelResource.LEVEL_DATA_FILE).getParent().resolve("xaeromap.txt");
        try {
            MinecraftServerData serverData = MinecraftServerData.get(player.level().getServer());
            LevelMapProperties properties = serverData.getLevelProperties(propertiesPath);
            if (properties.isUsable()) {
                WorldMap.messageHandler.sendToPlayer(player, properties);
            }
        }
        catch (Throwable t) {
            WorldMap.LOGGER.error("suppressed exception", t);
            player.connection.disconnect((Component)Component.translatable((String)"gui.xaero_wm_error_loading_properties"));
        }
    }

    public void handlePlayerTickStart(Player player) {
        if (player instanceof ServerPlayer) {
            WorldMap.serverPlayerTickHandler.tick((ServerPlayer)player);
            return;
        }
        if (WorldMap.events != null) {
            WorldMap.events.handlePlayerTickStart(player);
        }
    }
}

