/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.gui;

import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.gui.CursorBox;
import xaero.map.gui.GuiMap;
import xaero.map.gui.TooltipButton;
import xaero.map.settings.ModOptions;
import xaero.map.world.MapDimension;

public class GuiCaveModeOptions {
    private MapDimension dimension;
    private boolean enabled;
    private AbstractWidget caveModeStartSlider;
    private EditBox caveModeStartField;
    private boolean shouldUpdateSlider;

    public void onInit(GuiMap screen, MapProcessor mapProcessor) {
        this.caveModeStartSlider = null;
        this.caveModeStartField = null;
        this.dimension = mapProcessor.getMapWorld().getFutureDimension();
        boolean bl = this.enabled = this.enabled && this.dimension != null;
        if (this.enabled && this.dimension != null) {
            this.updateSlider(screen);
            this.updateField(screen);
            CursorBox caveModeTypeButtonTooltip = new CursorBox("gui.xaero_wm_box_cave_mode_type");
            screen.addButton(new TooltipButton(20, screen.height - 62, 150, 20, this.getCaveModeTypeButtonMessage(), b -> this.onCaveModeTypeButton(b, screen), () -> caveModeTypeButtonTooltip));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onCaveModeTypeButton(Button b, GuiMap screen) {
        this.dimension.toggleCaveModeType(true);
        Object object = screen.getMapProcessor().uiSync;
        synchronized (object) {
            this.dimension.saveConfigUnsynced();
        }
        b.setMessage(this.getCaveModeTypeButtonMessage());
    }

    private EditBox createField(GuiMap screen) {
        EditBox field = new EditBox(Minecraft.getInstance().font, 172, screen.height - 40, 50, 20, (Component)Component.translatable((String)"gui.xaero_wm_cave_mode_start"));
        field.setMaxLength(7);
        field.setValue((String)(WorldMap.settings.caveModeStart == Integer.MAX_VALUE ? "" : "" + WorldMap.settings.caveModeStart));
        field.setResponder(text -> {
            try {
                WorldMap.settings.caveModeStart = text.isEmpty() || text.equalsIgnoreCase("auto") ? Integer.MAX_VALUE : Integer.parseInt(text);
                this.shouldUpdateSlider = true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                WorldMap.settings.saveSettings();
            }
            catch (IOException e) {
                WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
            }
        });
        return field;
    }

    private AbstractWidget createSlider(GuiMap screen) {
        return ModOptions.CAVE_MODE_START.getXOption().createButton(20, screen.height - 40, 150);
    }

    private void updateField(GuiMap screen) {
        if (this.caveModeStartField == null) {
            this.caveModeStartField = this.createField(screen);
            screen.addButton(this.caveModeStartField);
        } else {
            this.caveModeStartField = this.createField(screen);
            screen.replaceRenderableWidget((AbstractWidget)this.caveModeStartField, (AbstractWidget)this.caveModeStartField);
        }
    }

    private void updateSlider(GuiMap screen) {
        if (this.caveModeStartSlider == null) {
            this.caveModeStartSlider = this.createSlider(screen);
            screen.addButton(this.caveModeStartSlider);
        } else {
            this.caveModeStartSlider = this.createSlider(screen);
            screen.replaceRenderableWidget(this.caveModeStartSlider, this.caveModeStartSlider);
        }
    }

    public void toggle(GuiMap screen) {
        this.enabled = WorldMap.settings.isCaveMapsAllowed() && !this.enabled;
        screen.init(Minecraft.getInstance(), screen.width, screen.height);
    }

    public void onCaveModeStartSet(GuiMap screen) {
        if (this.enabled) {
            this.updateField(screen);
        }
    }

    public void tick(GuiMap screen) {
        if (this.shouldUpdateSlider) {
            this.updateSlider(screen);
            this.shouldUpdateSlider = false;
        }
        if (this.enabled) {
            this.caveModeStartField.setSuggestion(this.caveModeStartField.getValue().isEmpty() ? I18n.get((String)"gui.xaero_wm_cave_mode_start_auto", (Object[])new Object[0]) : "");
        }
    }

    public void unfocusAll() {
        if (this.caveModeStartField != null) {
            this.caveModeStartField.setFocused(false);
        }
        if (this.caveModeStartSlider != null) {
            this.caveModeStartSlider.setFocused(false);
        }
    }

    private Component getCaveModeTypeButtonMessage() {
        return Component.literal((String)(I18n.get((String)"gui.xaero_wm_cave_mode_type", (Object[])new Object[0]) + ": " + I18n.get((String)(this.dimension == null ? "N/A" : (this.dimension.getCaveModeType() == 0 ? "gui.xaero_off" : (this.dimension.getCaveModeType() == 1 ? "gui.xaero_wm_cave_mode_type_layered" : "gui.xaero_wm_cave_mode_type_full"))), (Object[])new Object[0])));
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

