/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.core.transformer;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public abstract class ClassNodeTransformer
implements IClassTransformer {
    protected String className;

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (transformedName.equals(this.className)) {
            System.out.println("Transforming class " + transformedName);
            boolean isObfuscated = !name.equals(transformedName);
            return this.transform(basicClass, isObfuscated);
        }
        return basicClass;
    }

    private byte[] transform(byte[] basicClass, boolean isObfuscated) {
        ClassReader classReader = new ClassReader(basicClass);
        ClassNode classNode = new ClassNode(327680);
        classReader.accept((ClassVisitor)classNode, 0);
        this.transformNode(classNode, isObfuscated);
        ClassWriter classWriter = new ClassWriter(0);
        classNode.accept((ClassVisitor)classWriter);
        return classWriter.toByteArray();
    }

    protected void addGetter(ClassNode classNode, String fieldName, String fieldDesc) {
        this.addGetter(classNode, fieldName, "get" + (fieldName.charAt(0) + "").toUpperCase() + fieldName.substring(1), fieldDesc, 176);
    }

    protected void addGetter(ClassNode classNode, String fieldName, String getterName, String fieldDesc, int returnType) {
        List methods = classNode.methods;
        MethodNode getterNode = new MethodNode(1, getterName, "()" + fieldDesc, null, null);
        LabelNode labelNode1 = new LabelNode();
        LabelNode labelNode2 = new LabelNode();
        InsnList instructions = getterNode.instructions;
        instructions.add((AbstractInsnNode)labelNode1);
        instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        instructions.add((AbstractInsnNode)new FieldInsnNode(180, classNode.name, fieldName, fieldDesc));
        instructions.add((AbstractInsnNode)new InsnNode(returnType));
        instructions.add((AbstractInsnNode)labelNode2);
        getterNode.localVariables.add(new LocalVariableNode("this", "L" + classNode.name + ";", null, labelNode1, labelNode2, 0));
        getterNode.maxStack = 2;
        getterNode.maxLocals = 1;
        methods.add(getterNode);
    }

    protected void addSetter(ClassNode classNode, String fieldName, String fieldDesc) {
        List methods = classNode.methods;
        MethodNode setterNode = new MethodNode(1, "set" + (fieldName.charAt(0) + "").toUpperCase() + fieldName.substring(1), "(" + fieldDesc + ")V", null, null);
        LabelNode labelNode1 = new LabelNode();
        LabelNode labelNode2 = new LabelNode();
        InsnList instructions = setterNode.instructions;
        instructions.add((AbstractInsnNode)labelNode1);
        instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
        instructions.add((AbstractInsnNode)new FieldInsnNode(181, classNode.name, fieldName, fieldDesc));
        instructions.add((AbstractInsnNode)new InsnNode(177));
        instructions.add((AbstractInsnNode)labelNode2);
        setterNode.localVariables.add(new LocalVariableNode("this", "L" + classNode.name + ";", null, labelNode1, labelNode2, 0));
        setterNode.localVariables.add(new LocalVariableNode("value", fieldDesc, null, labelNode1, labelNode2, 1));
        setterNode.maxStack = 2;
        setterNode.maxLocals = 2;
        methods.add(setterNode);
    }

    protected void insertBeforeReturn2(MethodNode methodNode, Supplier<InsnList> patchListGetter) {
        InsnList instructions = methodNode.instructions;
        for (int i = 0; i < instructions.size(); ++i) {
            AbstractInsnNode insn = instructions.get(i);
            if (insn.getOpcode() < 172 || insn.getOpcode() > 177) continue;
            InsnList toInsert = patchListGetter.get();
            int patchSize = toInsert.size();
            instructions.insertBefore(insn, toInsert);
            i += patchSize;
        }
    }

    protected void insertBeforeReturn(MethodNode methodNode, final InsnList patchList) {
        Supplier<InsnList> patchListGetter = new Supplier<InsnList>(){

            @Override
            public InsnList get() {
                return patchList;
            }
        };
        this.insertBeforeReturn2(methodNode, patchListGetter);
    }

    protected boolean insertOnInvoke2(MethodNode methodNode, Supplier<InsnList> patchListGetter, boolean before, String invokeOwner, String invokeName, String invokeNameObf, String invokeDesc, boolean firstOnly) {
        InsnList instructions = methodNode.instructions;
        boolean isObfuscated = false;
        for (int i = 0; i < instructions.size(); ++i) {
            AbstractInsnNode insn = instructions.get(i);
            if (!(insn instanceof MethodInsnNode) || insn.getOpcode() < 182 || insn.getOpcode() > 185) continue;
            MethodInsnNode methodInsn = (MethodInsnNode)insn;
            if (!methodInsn.owner.equals(invokeOwner) || !methodInsn.name.equals(invokeName) && !methodInsn.name.equals(invokeNameObf) || !methodInsn.desc.equals(invokeDesc)) continue;
            if (methodInsn.name.equals(invokeNameObf)) {
                isObfuscated = true;
            }
            InsnList toInsert = patchListGetter.get();
            int patchSize = toInsert.size();
            if (before) {
                instructions.insertBefore(insn, toInsert);
            } else {
                instructions.insert(insn, toInsert);
            }
            i += patchSize;
            if (firstOnly) break;
        }
        return isObfuscated;
    }

    protected boolean insertOnInvoke(MethodNode methodNode, final InsnList patchList, boolean before, String invokeOwner, String invokeName, String invokeNameObf, String invokeDesc) {
        Supplier<InsnList> patchListGetter = new Supplier<InsnList>(){

            @Override
            public InsnList get() {
                return patchList;
            }
        };
        return this.insertOnInvoke2(methodNode, patchListGetter, before, invokeOwner, invokeName, invokeNameObf, invokeDesc, true);
    }

    protected abstract void transformNode(ClassNode var1, boolean var2);
}

