/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.gui;

import java.io.IOException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import xaero.lib.client.controls.util.KeyMappingUtils;
import xaero.lib.client.gui.CustomSettingEntry;
import xaero.lib.client.gui.GuiConstants;
import xaero.lib.client.gui.ISettingEntry;
import xaero.lib.client.gui.config.EditConfigScreen;
import xaero.lib.client.gui.config.context.IEditConfigScreenContext;
import xaero.lib.client.gui.widget.Tooltip;
import xaero.lib.common.config.option.BuiltInProfiledConfigOptions;
import xaero.lib.common.config.option.ConfigOption;
import xaero.lib.common.config.util.ConfigConstants;
import xaero.lib.common.gui.widget.TooltipInfo;
import xaero.map.MapFullReloader;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.WorldMapSession;
import xaero.map.common.config.WorldMapConfigConstants;
import xaero.map.common.config.option.WorldMapProfiledConfigOptions;
import xaero.map.config.primary.option.WorldMapPrimaryClientConfigOptions;
import xaero.map.controls.ControlsRegister;
import xaero.map.gui.ConfirmScreenBase;
import xaero.map.gui.GuiMap;
import xaero.map.gui.GuiMapTpCommand;
import xaero.map.gui.GuiPlayerTpCommand;
import xaero.map.gui.GuiTexturedButton;
import xaero.map.gui.ScreenSwitchSettingEntry;
import xaero.map.mods.SupportMods;
import xaero.map.settings.ModSettings;
import xaero.map.world.MapDimension;
import xaero.map.world.MapWorld;

public class GuiWorldMapSettings
extends EditConfigScreen {
    public static final ITextComponent PLAYER_TELEPORT_COMMAND_TOOLTIP = new TextComponentTranslation("gui.xaero_wm_box_player_teleport_command", new Object[0]);
    public static final ITextComponent MAP_TELEPORT_COMMAND_TOOLTIP = new TextComponentTranslation("gui.xaero_wm_box_map_teleport_command", new Object[0]);

    public GuiWorldMapSettings(IEditConfigScreenContext context) {
        this(null, context);
    }

    public GuiWorldMapSettings(GuiScreen parent, IEditConfigScreenContext context) {
        this(parent, null, context);
    }

    public GuiWorldMapSettings(GuiScreen parent, final GuiScreen escapeScreen, final IEditConfigScreenContext context) {
        super((ITextComponent)new TextComponentTranslation("gui.xaero_world_map_settings", new Object[0]), parent, escapeScreen, context, WorldMap.INSTANCE.getConfigs());
        ScreenSwitchSettingEntry minimapEntry = new ScreenSwitchSettingEntry("gui.xaero_wm_minimap_settings", new BiFunction<GuiScreen, GuiScreen, GuiScreen>(){

            @Override
            public GuiScreen apply(GuiScreen current, GuiScreen escape) {
                return SupportMods.xaeroMinimap.getSettingsScreen(current);
            }
        }, !SupportMods.minimap() ? new Tooltip(WorldMapConfigConstants.MINIMAP_TOOLTIP) : null, SupportMods.minimap());
        ScreenSwitchSettingEntry resetEntry = new ScreenSwitchSettingEntry("gui.xaero_wm_reset_config_profile_default", new BiFunction<GuiScreen, GuiScreen, GuiScreen>(){

            @Override
            public GuiScreen apply(GuiScreen current, GuiScreen escape) {
                return new ConfirmScreenBase(current, escape, true, new GuiYesNoCallback(){

                    public void func_73878_a(boolean r, int i) {
                        GuiWorldMapSettings.this.resetConfirmResult(r, (GuiScreen)GuiWorldMapSettings.this, escapeScreen);
                    }
                }, I18n.func_135052_a((String)"gui.xaero_wm_reset_config_profile_default_message", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.xaero_wm_reset_config_profile_default_message2", (Object[])new Object[0]), 0);
            }
        }, null, true, false);
        ScreenSwitchSettingEntry mapTeleportCommandEntry = new ScreenSwitchSettingEntry("gui.xaero_wm_teleport_command", new BiFunction<GuiScreen, GuiScreen, GuiScreen>(){

            @Override
            public GuiScreen apply(GuiScreen current, GuiScreen escape) {
                return new GuiMapTpCommand(current, escape);
            }
        }, new Tooltip(!context.isClientSide() ? GuiConstants.SETTING_ENTRY_WRONG_CONTEXT_COMPONENT : (!ModSettings.canEditIngameSettings() ? WorldMapConfigConstants.INGAME_TOOLTIP : MAP_TELEPORT_COMMAND_TOOLTIP)), context.isClientSide() && ModSettings.canEditIngameSettings());
        ScreenSwitchSettingEntry playerTeleportCommandEntry = new ScreenSwitchSettingEntry("gui.xaero_wm_player_teleport_command", new BiFunction<GuiScreen, GuiScreen, GuiScreen>(){

            @Override
            public GuiScreen apply(GuiScreen current, GuiScreen escape) {
                return new GuiPlayerTpCommand(current, escape);
            }
        }, new Tooltip(!context.isClientSide() ? GuiConstants.SETTING_ENTRY_WRONG_CONTEXT_COMPONENT : (!ModSettings.canEditIngameSettings() ? WorldMapConfigConstants.INGAME_TOOLTIP : PLAYER_TELEPORT_COMMAND_TOOLTIP)), context.isClientSide() && ModSettings.canEditIngameSettings());
        CustomSettingEntry ignoreHeightmapsEntry = new CustomSettingEntry(new BooleanSupplier(){

            @Override
            public boolean getAsBoolean() {
                return false;
            }
        }, (ITextComponent)new TextComponentTranslation("gui.xaero_wm_ignore_heightmaps", new Object[0]), context.isClientSide() ? new TooltipInfo("gui.xaero_wm_box_ignore_heightmaps") : new TooltipInfo(GuiConstants.SETTING_ENTRY_WRONG_CONTEXT_COMPONENT, false, true), false, (Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                WorldMapSession session = WorldMapSession.getCurrentSession();
                if (session == null) {
                    return null;
                }
                return session.getMapProcessor().getMapWorld().isIgnoreHeightmaps();
            }
        }, 0, 1, (IntFunction)new IntFunction<Boolean>(){

            @Override
            public Boolean apply(int i) {
                return i == 1;
            }
        }, (Function)new Function<Boolean, ITextComponent>(){

            @Override
            public ITextComponent apply(Boolean v) {
                return v != false ? ConfigConstants.ON : ConfigConstants.OFF;
            }
        }, (BiConsumer)new BiConsumer<Boolean, Boolean>(){

            @Override
            public void accept(Boolean oldValue, Boolean newValue) {
                WorldMapSession session = WorldMapSession.getCurrentSession();
                if (session == null) {
                    return;
                }
                MapWorld mapWorld = session.getMapProcessor().getMapWorld();
                mapWorld.setIgnoreHeightmaps(newValue);
                mapWorld.saveConfig();
                WorldMap.settings.updateRegionCacheHashCode();
            }
        }, new BooleanSupplier(){

            @Override
            public boolean getAsBoolean() {
                return context.isClientSide() && WorldMapSession.getCurrentSession() != null;
            }
        });
        ISettingEntry fullReloadEntry = this.getEntryForFullReloadOption(false);
        ISettingEntry fullResaveEntry = this.getEntryForFullReloadOption(true);
        CustomSettingEntry pauseRequestsEntry = new CustomSettingEntry(new BooleanSupplier(){

            @Override
            public boolean getAsBoolean() {
                return false;
            }
        }, (ITextComponent)new TextComponentString("Pause Requests"), null, false, (Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return WorldMap.pauseRequests;
            }
        }, 0, 1, (IntFunction)new IntFunction<Boolean>(){

            @Override
            public Boolean apply(int i) {
                return i == 1;
            }
        }, (Function)new Function<Boolean, ITextComponent>(){

            @Override
            public ITextComponent apply(Boolean v) {
                return v != false ? ConfigConstants.ON : ConfigConstants.OFF;
            }
        }, (BiConsumer)new BiConsumer<Boolean, Boolean>(){

            @Override
            public void accept(Boolean o, Boolean n) {
                WorldMap.pauseRequests = n;
            }
        }, new BooleanSupplier(){

            @Override
            public boolean getAsBoolean() {
                return true;
            }
        });
        CustomSettingEntry extraDebugEntry = new CustomSettingEntry(new BooleanSupplier(){

            @Override
            public boolean getAsBoolean() {
                return false;
            }
        }, (ITextComponent)new TextComponentString("Extra Debug"), null, false, (Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return WorldMap.extraDebug;
            }
        }, 0, 1, (IntFunction)new IntFunction<Boolean>(){

            @Override
            public Boolean apply(int i) {
                return i == 1;
            }
        }, (Function)new Function<Boolean, ITextComponent>(){

            @Override
            public ITextComponent apply(Boolean v) {
                return v != false ? ConfigConstants.ON : ConfigConstants.OFF;
            }
        }, (BiConsumer)new BiConsumer<Boolean, Boolean>(){

            @Override
            public void accept(Boolean o, Boolean n) {
                WorldMap.extraDebug = n;
            }
        }, new BooleanSupplier(){

            @Override
            public boolean getAsBoolean() {
                return true;
            }
        });
        this.entries = new ISettingEntry[]{this.createProfileIDEntry(), this.optionEntry(BuiltInProfiledConfigOptions.PROFILE_NAME), this.optionEntry((ConfigOption)WorldMapProfiledConfigOptions.LIGHTING), this.optionEntry((ConfigOption)WorldMapProfiledConfigOptions.BLOCK_COLORS), this.optionEntry((ConfigOption)WorldMapProfiledConfigOptions.LOAD_NEW_CHUNKS), this.optionEntry((ConfigOption)WorldMapProfiledConfigOptions.UPDATE_CHUNKS), this.optionEntry((ConfigOption)WorldMapProfiledConfigOptions.TERRAIN_DEPTH), this.optionEntry((ConfigOption)WorldMapProfiledConfigOptions.TERRAIN_SLOPES), this.optionEntry((ConfigOption)WorldMapProfiledConfigOptions.FOOTSTEPS), this.optionEntry((ConfigOption)WorldMapProfiledConfigOptions.COORDINATES), minimapEntry, this.optionEntry((ConfigOption)WorldMapProfiledConfigOptions.WAYPOINTS), this.optionEntry((ConfigOption)WorldMapProfiledConfigOptions.MINIMAP_RADAR), this.optionEntry((ConfigOption)WorldMapProfiledConfigOptions.RENDER_WAYPOINTS), this.optionEntry((ConfigOption)WorldMapProfiledConfigOptions.WAYPOINT_BACKGROUNDS), this.optionEntry((ConfigOption)WorldMapProfiledConfigOptions.WAYPOINT_SCALE), this.optionEntry((ConfigOption)WorldMapProfiledConfigOptions.BIOME_BLENDING), this.optionEntry((ConfigOption)WorldMapProfiledConfigOptions.BIOME_COLORS_IN_VANILLA), this.optionEntry((ConfigOption)WorldMapProfiledConfigOptions.MIN_ZOOM_LOCAL_WAYPOINTS), this.optionEntry((ConfigOption)WorldMapProfiledConfigOptions.ADJUST_HEIGHT_FOR_SHORT_BLOCKS), this.optionEntry((ConfigOption)WorldMapProfiledConfigOptions.FLOWERS), this.optionEntry((ConfigOption)WorldMapProfiledConfigOptions.STAINED_GLASS), ignoreHeightmapsEntry, this.optionEntry((ConfigOption)WorldMapProfiledConfigOptions.CAVE_MODE_ALLOWED), this.optionEntry(WorldMapProfiledConfigOptions.CAVE_MODE_ALLOWED_DIMENSIONS), this.optionEntry((ConfigOption)WorldMapProfiledConfigOptions.CAVE_MODE_DEPTH), this.optionEntry((ConfigOption)WorldMapProfiledConfigOptions.AUTO_CAVE_MODE), this.optionEntry((ConfigOption)WorldMapProfiledConfigOptions.LEGIBLE_CAVE_MAPS), this.optionEntry((ConfigOption)WorldMapProfiledConfigOptions.CAVE_MODE_TOGGLE_TIMER), this.optionEntry((ConfigOption)WorldMapProfiledConfigOptions.DEFAULT_CAVE_MODE_TYPE), this.optionEntry((ConfigOption)WorldMapProfiledConfigOptions.DISPLAY_CAVE_MODE_START), this.optionEntry((ConfigOption)WorldMapProfiledConfigOptions.WRITING_DISTANCE), this.optionEntry((ConfigOption)WorldMapProfiledConfigOptions.ARROW), this.optionEntry((ConfigOption)WorldMapProfiledConfigOptions.OPENING_ANIMATION), this.optionEntry((ConfigOption)WorldMapProfiledConfigOptions.ARROW_COLOR), this.optionEntry((ConfigOption)WorldMapProfiledConfigOptions.DISPLAY_ZOOM), this.optionEntry((ConfigOption)WorldMapProfiledConfigOptions.DISPLAY_HOVERED_BIOME), this.optionEntry((ConfigOption)WorldMapProfiledConfigOptions.ZOOM_BUTTONS), this.optionEntry(WorldMapProfiledConfigOptions.DEFAULT_MAP_TELEPORT_FORMAT), this.optionEntry(WorldMapProfiledConfigOptions.DEFAULT_MAP_TELEPORT_DIMENSION_FORMAT), mapTeleportCommandEntry, this.optionEntry(WorldMapProfiledConfigOptions.DEFAULT_PLAYER_TELEPORT_FORMAT), this.optionEntry((ConfigOption)WorldMapProfiledConfigOptions.DETECT_AMBIGUOUS_Y), playerTeleportCommandEntry, this.optionEntry((ConfigOption)WorldMapProfiledConfigOptions.MAP_TELEPORT_ALLOWED), this.optionEntry((ConfigOption)WorldMapProfiledConfigOptions.PARTIAL_Y_TELEPORT), this.optionEntry(WorldMapProfiledConfigOptions.MAP_ITEM), this.optionEntry((ConfigOption)WorldMapProfiledConfigOptions.DISPLAY_TRACKED_PLAYERS), this.primaryOptionEntry((ConfigOption)WorldMapPrimaryClientConfigOptions.RELOAD_VIEWED), fullReloadEntry, this.primaryOptionEntry((ConfigOption)WorldMapPrimaryClientConfigOptions.UPDATE_NOTIFICATIONS), fullResaveEntry, this.primaryOptionEntry((ConfigOption)WorldMapPrimaryClientConfigOptions.DEBUG), resetEntry, this.optionEntry((ConfigOption)BuiltInProfiledConfigOptions.IGNORE_ENFORCEMENT_IF_EDITOR)};
    }

    private ISettingEntry getEntryForFullReloadOption(final boolean isResave) {
        return new CustomSettingEntry(new BooleanSupplier(){

            @Override
            public boolean getAsBoolean() {
                return false;
            }
        }, (ITextComponent)new TextComponentTranslation(isResave ? "gui.xaero_full_resave" : "gui.xaero_full_reload", new Object[0]), this.context.isClientSide() ? new TooltipInfo(isResave ? "gui.xaero_box_full_resave" : "gui.xaero_box_full_reload") : new TooltipInfo(GuiConstants.SETTING_ENTRY_WRONG_CONTEXT_COMPONENT, false, true), false, (Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                WorldMapSession session = WorldMapSession.getCurrentSession();
                if (session == null) {
                    return false;
                }
                MapDimension mapDimension = session.getMapProcessor().getMapWorld().getCurrentDimension();
                MapFullReloader reloader = mapDimension == null ? null : mapDimension.getFullReloader();
                return reloader != null && (!isResave || reloader.isResave());
            }
        }, 0, 1, (IntFunction)new IntFunction<Boolean>(){

            @Override
            public Boolean apply(int i) {
                return i == 1;
            }
        }, (Function)new Function<Boolean, ITextComponent>(){

            @Override
            public ITextComponent apply(Boolean v) {
                return v != false ? ConfigConstants.ON : ConfigConstants.OFF;
            }
        }, (BiConsumer)new BiConsumer<Boolean, Boolean>(){

            @Override
            public void accept(Boolean oldValue, Boolean newValue) {
                WorldMapSession session = WorldMapSession.getCurrentSession();
                MapProcessor mapProcessor = session.getMapProcessor();
                MapDimension mapDimension = mapProcessor.getMapWorld().getCurrentDimension();
                if (mapDimension == null) {
                    return;
                }
                if (newValue.booleanValue() && (mapDimension.getFullReloader() == null || !mapDimension.getFullReloader().isResave() && isResave)) {
                    mapDimension.startFullMapReload(mapProcessor.getCurrentCaveLayer(), isResave, mapProcessor);
                } else if (!newValue.booleanValue()) {
                    mapDimension.clearFullMapReload();
                }
                GuiWorldMapSettings.this.refresh();
            }
        }, new BooleanSupplier(){

            @Override
            public boolean getAsBoolean() {
                return GuiWorldMapSettings.this.context.isClientSide() && WorldMapSession.getCurrentSession() != null;
            }
        });
    }

    protected void resetConfirmResult(boolean result, GuiScreen parent, GuiScreen escScreen) {
        if (result) {
            this.resetProfileToDefaults();
        }
        Minecraft.func_71410_x().func_147108_a(parent);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        final Tooltip closeSettingsTooltip = new Tooltip((ITextComponent)new TextComponentTranslation("gui.xaero_box_close_settings", new Object[]{KeyMappingUtils.getKeyName((KeyBinding)ControlsRegister.keyOpenSettings)}));
        if (this.parent instanceof GuiMap) {
            this.func_189646_b((GuiButton)new GuiTexturedButton(0, 0, 30, 30, 113, 0, 20, 20, WorldMap.guiTextures, new Consumer<GuiButton>(){

                @Override
                public void accept(GuiButton b) {
                    GuiWorldMapSettings.this.onSettingsButton(b);
                }
            }, new Supplier<Tooltip>(){

                @Override
                public Tooltip get() {
                    return closeSettingsTooltip;
                }
            }));
        }
    }

    private void onSettingsButton(GuiButton button) {
        this.goBack();
    }

    protected void func_73869_a(char typedChar, int key) throws IOException {
        super.func_73869_a(typedChar, key);
        if (this.handledKeyboardInput) {
            return;
        }
        if (this.context.isClientSide() && KeyMappingUtils.inputMatches((boolean)false, (int)key, (KeyBinding)ControlsRegister.keyOpenSettings, (int)0) || !this.context.isClientSide() && KeyMappingUtils.inputMatches((boolean)false, (int)key, (KeyBinding)ControlsRegister.keyOpenServerSettings, (int)0)) {
            this.onExit(this.escape);
            this.handledKeyboardInput = true;
            return;
        }
    }
}

