/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.gui;

import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import xaero.lib.client.gui.ISettingEntry;
import xaero.lib.client.gui.ScreenBase;
import xaero.lib.client.gui.widget.Tooltip;
import xaero.map.gui.TooltipButton;

public class ScreenSwitchSettingEntry
implements ISettingEntry {
    private String name;
    private BiFunction<GuiScreen, GuiScreen, GuiScreen> screenFactory;
    private Supplier<Tooltip> tooltipSupplier;
    private boolean active;
    private final boolean consideredAnExit;

    public ScreenSwitchSettingEntry(String name, BiFunction<GuiScreen, GuiScreen, GuiScreen> screenFactoryFromCurrentAndEscape, Tooltip tooltip, boolean active) {
        this(name, screenFactoryFromCurrentAndEscape, tooltip, active, true);
    }

    public ScreenSwitchSettingEntry(String name, BiFunction<GuiScreen, GuiScreen, GuiScreen> screenFactoryFromCurrentAndEscape, final Tooltip tooltip, boolean active, boolean consideredAnExit) {
        this.name = name;
        this.screenFactory = screenFactoryFromCurrentAndEscape;
        this.tooltipSupplier = new Supplier<Tooltip>(){

            @Override
            public Tooltip get() {
                return tooltip;
            }
        };
        this.active = active;
        this.consideredAnExit = consideredAnExit;
    }

    public String getStringForSearch() {
        Tooltip entryTooltip = this.tooltipSupplier == null ? null : this.tooltipSupplier.get();
        String tooltipFullCode = entryTooltip == null ? null : entryTooltip.getFullCode();
        return I18n.func_135052_a((String)this.name, (Object[])new Object[0]) + " " + this.name.replace("gui.xaero", "") + (tooltipFullCode != null ? " " + tooltipFullCode.replace("gui.xaero", "") : "") + (entryTooltip != null ? " " + entryTooltip.getPlainText() : "");
    }

    public GuiButton createWidget(int x, int y, int w, int width) {
        TooltipButton button = new TooltipButton(x, y, w, 20, I18n.func_135052_a((String)this.name, (Object[])new Object[0]), this.tooltipSupplier){

            protected void onPress() {
                Minecraft mc = Minecraft.func_71410_x();
                GuiScreen current = mc.field_71462_r;
                GuiScreen currentEscScreen = current instanceof ScreenBase ? ((ScreenBase)current).escape : null;
                GuiScreen targetScreen = (GuiScreen)ScreenSwitchSettingEntry.this.screenFactory.apply(current, currentEscScreen);
                if (ScreenSwitchSettingEntry.this.consideredAnExit && current instanceof ScreenBase) {
                    ((ScreenBase)current).onExit(targetScreen);
                } else {
                    mc.func_147108_a(targetScreen);
                }
            }
        };
        button.field_146124_l = this.active;
        return button;
    }

    public BiFunction<GuiScreen, GuiScreen, GuiScreen> getScreenFactory() {
        return this.screenFactory;
    }
}

