/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.misc;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.NonNullList;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldProviderHell;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.EXTSeparateShaderObjects;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GLContext;
import xaero.map.WorldMap;

public class Misc {
    private static final long[] ZERO_LONG_586 = new long[586];
    private static long cpuTimerPreTime;
    private static long glTimerPreTime;
    public static final String OUTDATED_FILE_EXT = ".outdated";
    private static int shadersType;
    private static boolean EXTgeometryShader;

    public static IBlockState getStateById(int id) {
        try {
            return Block.func_176220_d((int)id);
        }
        catch (Exception e) {
            return Misc.getDefaultBlockStateForStateId(id);
        }
    }

    private static IBlockState getDefaultBlockStateForStateId(int id) {
        try {
            Block block = Block.func_176220_d((int)id).func_177230_c();
            return block.func_176223_P();
        }
        catch (Exception e) {
            return Blocks.field_150350_a.func_176223_P();
        }
    }

    public static void glTimerPre() {
        GL11.glFinish();
        glTimerPreTime = System.nanoTime();
    }

    public static int glTimerResult() {
        GL11.glFinish();
        return (int)(System.nanoTime() - glTimerPreTime);
    }

    public static void timerPre() {
        cpuTimerPreTime = System.nanoTime();
    }

    public static int timerResult() {
        return (int)(System.nanoTime() - cpuTimerPreTime);
    }

    public static double getMouseX(Minecraft mc) {
        return Mouse.getX();
    }

    public static double getMouseY(Minecraft mc) {
        return mc.field_71440_d - Mouse.getY() - 1;
    }

    public static void clearHeightsData586(long[] data) {
        System.arraycopy(ZERO_LONG_586, 0, data, 0, 586);
    }

    public static <T extends Comparable<? super T>> void addToListOfSmallest(int maxSize, List<T> list, T element) {
        int currentSize = list.size();
        if (currentSize == maxSize && ((Comparable)list.get(currentSize - 1)).compareTo(element) <= 0) {
            return;
        }
        int iterLimit = currentSize == maxSize ? maxSize : currentSize + 1;
        for (int i = 0; i < iterLimit; ++i) {
            if (i != currentSize && element.compareTo(list.get(i)) >= 0) continue;
            list.add(i, element);
            if (currentSize != maxSize) break;
            list.remove(currentSize);
            break;
        }
    }

    public static void minecraftOrtho(ScaledResolution scaledresolution) {
        GlStateManager.func_179096_D();
        GlStateManager.func_179130_a((double)0.0, (double)scaledresolution.func_78327_c(), (double)scaledresolution.func_78324_d(), (double)0.0, (double)1000.0, (double)3000.0);
    }

    public static void setShaderProgram(int program) {
        if (shadersType == -500) {
            shadersType = GLContext.getCapabilities().OpenGL20 ? 0 : (GLContext.getCapabilities().GL_ARB_shader_objects ? 1 : (GLContext.getCapabilities().GL_EXT_separate_shader_objects ? 2 : -1));
            EXTgeometryShader = GLContext.getCapabilities().GL_EXT_geometry_shader4 || GLContext.getCapabilities().GL_ARB_geometry_shader4;
        }
        switch (shadersType) {
            case 0: {
                GL20.glUseProgram((int)program);
                break;
            }
            case 1: {
                ARBShaderObjects.glUseProgramObjectARB((int)program);
                break;
            }
            case 2: {
                EXTSeparateShaderObjects.glUseShaderProgramEXT((int)35633, (int)program);
                if (EXTgeometryShader) {
                    EXTSeparateShaderObjects.glUseShaderProgramEXT((int)36313, (int)program);
                }
                EXTSeparateShaderObjects.glUseShaderProgramEXT((int)35632, (int)program);
                EXTSeparateShaderObjects.glActiveProgramEXT((int)program);
                break;
            }
        }
    }

    public static Path convertToOutdated(Path path, int attempts) throws IOException {
        if (path.getFileName().toString().endsWith(OUTDATED_FILE_EXT)) {
            return path;
        }
        Path outdatedPath = path.resolveSibling(path.getFileName().toString() + OUTDATED_FILE_EXT);
        if (Files.exists(path, new LinkOption[0])) {
            Misc.convertToOutdated(path, outdatedPath, attempts);
        }
        return outdatedPath;
    }

    private static void convertToOutdated(Path path, Path outdatedPath, int attempts) throws IOException {
        --attempts;
        try {
            Files.move(path, outdatedPath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            if (attempts > 0) {
                WorldMap.LOGGER.info("Failed to convert file to outdated! Retrying... " + attempts);
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Misc.convertToOutdated(path, outdatedPath, attempts);
            }
            throw e;
        }
    }

    public static boolean hasItem(EntityPlayer player, Item item) {
        return Misc.hasItem((NonNullList<ItemStack>)player.field_71071_by.field_184439_c, -1, item) || Misc.hasItem((NonNullList<ItemStack>)player.field_71071_by.field_70460_b, -1, item) || Misc.hasItem((NonNullList<ItemStack>)player.field_71071_by.field_70462_a, 9, item);
    }

    public static boolean hasItem(NonNullList<ItemStack> inventory, int limit, Item item) {
        for (int i = 0; i < inventory.size() && (limit == -1 || i < limit); ++i) {
            if (inventory.get(i) == null || ((ItemStack)inventory.get(i)).func_77973_b() != item) continue;
            return true;
        }
        return false;
    }

    public static int getTeamColour(Entity e) {
        Integer teamColour = null;
        Team team = e.func_96124_cp();
        if (team != null) {
            String prefix = team.func_178775_l().toString();
            try {
                teamColour = Minecraft.func_71410_x().field_71466_p.func_175064_b(prefix.charAt(prefix.length() - 1));
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        return teamColour == null ? -1 : teamColour;
    }

    public static double getDimensionTypeScale(World world) {
        return Misc.getDimensionTypeScale(world.field_73011_w);
    }

    public static double getDimensionTypeScale(WorldProvider provider) {
        return provider.func_177495_o() || provider instanceof WorldProviderHell || provider.func_186058_p() == DimensionType.NETHER ? 8.0 : 1.0;
    }

    public static boolean hasEffect(EntityPlayer player, Potion effect) {
        return effect != null && player != null && player.func_70644_a(effect);
    }

    public static boolean hasEffect(Potion effect) {
        return Misc.hasEffect((EntityPlayer)Minecraft.func_71410_x().field_71439_g, effect);
    }

    static {
        shadersType = -500;
    }
}

