/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.radar.tracker;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import xaero.map.icon.XaeroIcon;
import xaero.map.icon.XaeroIconAtlas;
import xaero.map.icon.XaeroIconAtlasManager;
import xaero.map.radar.tracker.PlayerTrackerMapElement;
import xaero.map.radar.tracker.TrackedPlayerIconPrerenderer;

public final class TrackedPlayerIconManager {
    private static final int ICON_WIDTH = 32;
    private static final int PREFERRED_ATLAS_WIDTH = 1024;
    private final TrackedPlayerIconPrerenderer prerenderer;
    private final XaeroIconAtlasManager iconAtlasManager;
    private final Map<ResourceLocation, XaeroIcon> icons;
    private final int iconWidth;

    private TrackedPlayerIconManager(TrackedPlayerIconPrerenderer prerenderer, XaeroIconAtlasManager iconAtlasManager, Map<ResourceLocation, XaeroIcon> icons, int iconWidth) {
        this.prerenderer = prerenderer;
        this.iconAtlasManager = iconAtlasManager;
        this.icons = icons;
        this.iconWidth = iconWidth;
    }

    public ResourceLocation getPlayerSkin(EntityPlayer player, NetworkPlayerInfo info) {
        ResourceLocation skinTextureLocation;
        ResourceLocation resourceLocation = skinTextureLocation = player instanceof AbstractClientPlayer ? ((AbstractClientPlayer)player).func_110306_p() : info.func_178837_g();
        if (skinTextureLocation == null) {
            skinTextureLocation = DefaultPlayerSkin.func_177334_a((UUID)player.func_110124_au());
        }
        return skinTextureLocation;
    }

    public XaeroIcon getIcon(EntityPlayer player, NetworkPlayerInfo info, PlayerTrackerMapElement<?> element, ScaledResolution scaledRes) {
        ResourceLocation skinTextureLocation = this.getPlayerSkin(player, info);
        XaeroIcon result = this.icons.get(skinTextureLocation);
        if (result == null) {
            result = this.iconAtlasManager.getCurrentAtlas().createIcon();
            this.icons.put(skinTextureLocation, result);
            this.prerenderer.prerender(result, player, this.iconWidth, skinTextureLocation, element, scaledRes);
        }
        return result;
    }

    public static final class Builder {
        public TrackedPlayerIconManager build() {
            int maxTextureSize = GlStateManager.func_187397_v((int)3379);
            int atlasTextureSize = Math.min(maxTextureSize, 1024) / 32 * 32;
            return new TrackedPlayerIconManager(new TrackedPlayerIconPrerenderer(), new XaeroIconAtlasManager(32, atlasTextureSize, new ArrayList<XaeroIconAtlas>()), new HashMap(), 32);
        }

        public static Builder begin() {
            return new Builder();
        }
    }
}

