/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.world;

import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import xaero.map.world.MapDimension;
import xaero.map.world.MapWorld;

public class MapConnectionNode {
    private final RegistryKey<World> dimId;
    private final String mw;
    private String cachedString;

    public MapConnectionNode(RegistryKey<World> dimId, String mw) {
        this.dimId = dimId;
        this.mw = mw;
    }

    public String toString() {
        if (this.cachedString == null) {
            this.cachedString = this.dimId.func_240901_a_().toString().replace(':', '$') + "/" + this.mw;
        }
        return this.cachedString;
    }

    public String getNamedString(MapWorld mapWorld) {
        MapDimension dim = mapWorld.getDimension(this.dimId);
        return this.dimId.func_240901_a_() + "/" + dim.getMultiworldName(this.mw);
    }

    public static MapConnectionNode fromString(String s) {
        ResourceLocation dimLocation;
        int dividerIndex = s.lastIndexOf(47);
        if (dividerIndex == -1) {
            return null;
        }
        String dimString = s.substring(0, dividerIndex);
        try {
            dimLocation = dimString.equals("0") ? World.field_234918_g_.func_240901_a_() : (dimString.equals("-1") ? World.field_234919_h_.func_240901_a_() : (dimString.equals("1") ? World.field_234920_i_.func_240901_a_() : new ResourceLocation(dimString.replace('$', ':'))));
        }
        catch (Throwable t) {
            return null;
        }
        String mwString = s.substring(dividerIndex + 1);
        return new MapConnectionNode((RegistryKey<World>)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)dimLocation), mwString);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        if (another == null || !(another instanceof MapConnectionNode)) {
            return false;
        }
        MapConnectionNode anotherNode = (MapConnectionNode)another;
        return this.dimId.equals(anotherNode.dimId) && this.mw.equals(anotherNode.mw);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public RegistryKey<World> getDimId() {
        return this.dimId;
    }

    public String getMw() {
        return this.mw;
    }
}

