/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.mods.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.io.IOException;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import xaero.common.HudMod;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.gui.GuiNewSet;
import xaero.common.gui.GuiWaypointSets;
import xaero.common.minimap.waypoints.WaypointWorld;
import xaero.common.settings.ModSettings;
import xaero.hud.minimap.common.config.option.MinimapProfiledConfigOptions;
import xaero.lib.client.config.ClientConfigManager;
import xaero.lib.client.controls.util.KeyMappingUtils;
import xaero.lib.client.gui.widget.Tooltip;
import xaero.lib.client.gui.widget.dropdown.DropDownWidget;
import xaero.lib.client.gui.widget.dropdown.IDropDownContainer;
import xaero.lib.client.gui.widget.dropdown.IDropDownWidgetCallback;
import xaero.lib.common.config.option.ConfigOption;
import xaero.lib.common.config.single.SingleConfigManager;
import xaero.map.WorldMap;
import xaero.map.common.config.option.WorldMapProfiledConfigOptions;
import xaero.map.config.primary.option.WorldMapPrimaryClientConfigOptions;
import xaero.map.config.util.WorldMapClientConfigUtils;
import xaero.map.element.MapElementMenuRenderer;
import xaero.map.element.render.ElementRenderer;
import xaero.map.gui.GuiMap;
import xaero.map.gui.GuiTexturedButton;
import xaero.map.mods.SupportMods;
import xaero.map.mods.gui.Waypoint;
import xaero.map.mods.gui.WaypointMenuRenderContext;
import xaero.map.mods.gui.WaypointMenuRenderProvider;
import xaero.map.mods.gui.WaypointRenderer;

public class WaypointMenuRenderer
extends MapElementMenuRenderer<Waypoint, WaypointMenuRenderContext> {
    private final WaypointRenderer renderer;
    private Button renderWaypointsButton;
    private Button showDisabledButton;
    private Button closeMenuWhenHoppingButton;
    private Button currentMapWaypointsButton;
    private Button renderAllSetsButton;

    public WaypointMenuRenderer(WaypointMenuRenderContext context, WaypointMenuRenderProvider provider, WaypointRenderer renderer) {
        super(context, provider);
        this.renderer = renderer;
    }

    public void onMapInit(GuiMap screen, Minecraft mc, int width, int height, WaypointWorld waypointWorld, IXaeroMinimap modMain, XaeroMinimapSession minimapSession) {
        DropDownWidget setsDropdown;
        super.onMapInit(screen, mc, width, height);
        GuiWaypointSets sets = waypointWorld != null ? new GuiWaypointSets(true, waypointWorld) : null;
        IDropDownWidgetCallback setsDropdownCallback = null;
        if (sets != null) {
            setsDropdownCallback = (menu, selected) -> {
                if (selected == menu.size() - 1) {
                    GuiNewSet guiNewSet = new GuiNewSet(modMain, minimapSession, (Screen)screen, (Screen)screen, waypointWorld);
                    Minecraft.m_91087_().m_91152_((Screen)guiNewSet);
                    return false;
                }
                sets.setCurrentSet(selected);
                waypointWorld.setCurrent(sets.getCurrentSetKey());
                minimapSession.getWaypointsManager().updateWaypoints();
                try {
                    modMain.getSettings().saveWaypoints(waypointWorld);
                }
                catch (IOException e) {
                    WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
                }
                return true;
            };
        }
        DropDownWidget dropDownWidget = setsDropdown = sets == null ? null : DropDownWidget.Builder.begin().setOptions(sets.getOptions()).setX(width - 173).setY(height - 56).setW(151).setSelected(Integer.valueOf(sets.getCurrentSet())).setCallback(setsDropdownCallback).setContainer((IDropDownContainer)screen).setOpeningUp(true).setNarrationTitle((Component)Component.m_237115_((String)"gui.xaero_dropdown_waypoint_set")).build();
        if (setsDropdown != null) {
            screen.m_7787_(setsDropdown);
        }
        MutableComponent fullWaypointMenuTooltipText = Component.m_237110_((String)"gui.xaero_box_full_waypoints_menu", (Object[])new Object[]{Component.m_237113_((String)KeyMappingUtils.getKeyName((KeyMapping)ModSettings.keyWaypoints)).m_130940_(ChatFormatting.DARK_GREEN)});
        ClientConfigManager configManager = WorldMap.INSTANCE.getConfigs().getClientConfigManager();
        boolean renderWaypoints = (Boolean)configManager.getEffective((ConfigOption)WorldMapProfiledConfigOptions.RENDER_WAYPOINTS);
        SingleConfigManager primaryConfigManager = configManager.getPrimaryConfigManager();
        boolean onlyCurrentMapWaypoints = (Boolean)primaryConfigManager.getEffective((ConfigOption)WorldMapPrimaryClientConfigOptions.ONLY_CURRENT_MAP_WAYPOINTS);
        boolean showDisabledWaypoints = (Boolean)primaryConfigManager.getEffective((ConfigOption)WorldMapPrimaryClientConfigOptions.DISPLAY_DISABLED_WAYPOINTS);
        boolean closeWaypointsWhenHopping = (Boolean)primaryConfigManager.getEffective((ConfigOption)WorldMapPrimaryClientConfigOptions.CLOSE_WAYPOINTS_AFTER_HOP);
        Tooltip fullWaypointMenuTooltip = new Tooltip((Component)fullWaypointMenuTooltipText, true);
        Tooltip onlyCurrentMapWaypointsTooltip = new Tooltip(onlyCurrentMapWaypoints ? "gui.xaero_box_only_current_map_waypoints" : "gui.xaero_box_waypoints_selected_by_minimap", Style.f_131099_, true);
        Tooltip renderingWaypointsTooltip = new Tooltip((Component)Component.m_237110_((String)(renderWaypoints ? "gui.xaero_box_rendering_waypoints" : "gui.xaero_box_not_rendering_waypoints"), (Object[])new Object[]{Component.m_237113_((String)KeyMappingUtils.getKeyName((KeyMapping)ModSettings.keyToggleMapWaypoints)).m_130940_(ChatFormatting.DARK_GREEN)}), true);
        ClientConfigManager minimapConfigManager = HudMod.INSTANCE.getHudConfigs().getClientConfigManager();
        boolean renderAllSetsConfig = (Boolean)minimapConfigManager.getEffective((ConfigOption)MinimapProfiledConfigOptions.WAYPOINTS_ALL_SETS);
        Tooltip renderAllSetsTooltip = new Tooltip((Component)Component.m_237110_((String)(!renderAllSetsConfig ? "gui.xaero_box_rendering_current_set" : "gui.xaero_box_rendering_all_sets"), (Object[])new Object[]{Component.m_237113_((String)KeyMappingUtils.getKeyName((KeyMapping)ModSettings.keyAllSets)).m_130940_(ChatFormatting.DARK_GREEN)}), true);
        Tooltip showingDisabledTooltip = new Tooltip(showDisabledWaypoints ? "gui.xaero_box_showing_disabled" : "gui.xaero_box_hiding_disabled", Style.f_131099_, true);
        Tooltip closeWhenHoppingTooltip = new Tooltip(closeWaypointsWhenHopping ? "gui.xaero_box_closing_menu_when_hopping" : "gui.xaero_box_not_closing_menu_when_hopping", Style.f_131099_, true);
        screen.addButton(new GuiTexturedButton(width - 173, height - 20, 20, 20, 229, 0, 16, 16, WorldMap.guiTextures, b -> this.onFullMenuButton(b, screen), () -> fullWaypointMenuTooltip));
        this.currentMapWaypointsButton = new GuiTexturedButton(width - 153, height - 20, 20, 20, onlyCurrentMapWaypoints ? 213 : 229, 16, 16, 16, WorldMap.guiTextures, b -> this.onCurrentMapWaypointsButton(b, screen, width, height), () -> onlyCurrentMapWaypointsTooltip);
        screen.addButton(this.currentMapWaypointsButton);
        this.renderWaypointsButton = new GuiTexturedButton(width - 133, height - 20, 20, 20, renderWaypoints ? 229 : 213, 48, 16, 16, WorldMap.guiTextures, b -> this.onRenderWaypointsButton(screen, width, height), () -> renderingWaypointsTooltip);
        screen.addButton(this.renderWaypointsButton);
        this.renderAllSetsButton = new GuiTexturedButton(width - 113, height - 20, 20, 20, !renderAllSetsConfig ? 81 : 97, 16, 16, 16, WorldMap.guiTextures, b -> this.onRenderAllSetsButton(b, screen, width, height), () -> renderAllSetsTooltip);
        screen.addButton(this.renderAllSetsButton);
        this.showDisabledButton = new GuiTexturedButton(width - 93, height - 20, 20, 20, showDisabledWaypoints ? 133 : 149, 16, 16, 16, WorldMap.guiTextures, b -> this.onShowDisabledButton(b, screen, width, height), () -> showingDisabledTooltip);
        screen.addButton(this.showDisabledButton);
        this.closeMenuWhenHoppingButton = new GuiTexturedButton(width - 73, height - 20, 20, 20, closeWaypointsWhenHopping ? 181 : 197, 16, 16, 16, WorldMap.guiTextures, b -> this.onCloseMenuWhenHoppingButton(b, screen, width, height), () -> closeWhenHoppingTooltip);
        screen.addButton(this.closeMenuWhenHoppingButton);
        this.renderWaypointsButton.f_93623_ = !WorldMapClientConfigUtils.isOptionServerEnforced((ConfigOption<Boolean>)WorldMapProfiledConfigOptions.RENDER_WAYPOINTS);
    }

    public void onRenderWaypointsButton(GuiMap screen, int width, int height) {
        WorldMapClientConfigUtils.tryTogglingCurrentProfileOption((ConfigOption<Boolean>)WorldMapProfiledConfigOptions.RENDER_WAYPOINTS);
        screen.m_6575_(this.mc, width, height);
        screen.m_7522_((GuiEventListener)this.renderWaypointsButton);
    }

    private void onFullMenuButton(Button b, GuiMap screen) {
        SupportMods.xaeroMinimap.openWaypointsMenu(this.mc, screen);
    }

    private void onRenderAllSetsButton(Button b, GuiMap screen, int width, int height) {
        SupportMods.xaeroMinimap.handleMinimapKeyBinding(ModSettings.keyAllSets, screen);
        screen.m_7522_((GuiEventListener)this.renderAllSetsButton);
    }

    private void onShowDisabledButton(Button b, GuiMap screen, int width, int height) {
        WorldMapClientConfigUtils.togglePrimaryOption((ConfigOption<Boolean>)WorldMapPrimaryClientConfigOptions.DISPLAY_DISABLED_WAYPOINTS);
        screen.m_6575_(this.mc, width, height);
        screen.m_7522_((GuiEventListener)this.showDisabledButton);
    }

    private void onCloseMenuWhenHoppingButton(Button b, GuiMap screen, int width, int height) {
        WorldMapClientConfigUtils.togglePrimaryOption((ConfigOption<Boolean>)WorldMapPrimaryClientConfigOptions.CLOSE_WAYPOINTS_AFTER_HOP);
        screen.m_6575_(this.mc, width, height);
        screen.m_7522_((GuiEventListener)this.closeMenuWhenHoppingButton);
    }

    private void onCurrentMapWaypointsButton(Button b, GuiMap screen, int width, int height) {
        WorldMapClientConfigUtils.togglePrimaryOption((ConfigOption<Boolean>)WorldMapPrimaryClientConfigOptions.ONLY_CURRENT_MAP_WAYPOINTS);
        screen.m_6575_(this.mc, width, height);
        screen.m_7522_((GuiEventListener)this.currentMapWaypointsButton);
    }

    @Override
    public void renderInMenu(Waypoint element, GuiGraphics guiGraphics, Screen gui, int mouseX, int mouseY, double scale, boolean enabled, boolean hovered, Minecraft mc, boolean pressed, int textX) {
        PoseStack matrixStack = guiGraphics.m_280168_();
        Waypoint w = element;
        boolean disabled = w.isDisabled();
        boolean temporary = w.isTemporary();
        int type = w.getType();
        int color = w.getColor();
        String symbol = w.getSymbol();
        matrixStack.m_252880_(-4.0f, -4.0f, 0.0f);
        RenderSystem.enableBlend();
        if (type == 1) {
            guiGraphics.m_280509_(0, 0, 9, 9, color);
            AbstractTexture texture = mc.m_91097_().m_118506_(Waypoint.minimapTextures);
            texture.m_117960_(false, false);
            RenderSystem.setShaderColor((float)0.2431f, (float)0.2431f, (float)0.2431f, (float)1.0f);
            guiGraphics.m_280218_(Waypoint.minimapTextures, 1, 1, 0, 78, 9, 9);
            RenderSystem.setShaderColor((float)0.9882f, (float)0.9882f, (float)0.9882f, (float)1.0f);
            guiGraphics.m_280218_(Waypoint.minimapTextures, 0, 0, 0, 78, 9, 9);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else {
            guiGraphics.m_280509_(0, 0, 9, 9, color);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (type != 1) {
            guiGraphics.m_280488_(mc.f_91062_, symbol, 5 - mc.f_91062_.m_92895_(symbol) / 2, 1, -1);
        }
        RenderSystem.enableBlend();
        int infoIconOffset = 10;
        if (disabled) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f);
            guiGraphics.m_280218_(WorldMap.guiTextures, textX - 1 - infoIconOffset, 0, 173, 16, 8, 8);
            infoIconOffset += 10;
        }
        if (temporary) {
            RenderSystem.setShaderColor((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            guiGraphics.m_280218_(WorldMap.guiTextures, textX - 1 - infoIconOffset, 0, 165, 16, 8, 8);
            infoIconOffset += 10;
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public int menuStartPos(int height) {
        return height - 59;
    }

    @Override
    public int menuSearchPadding() {
        return 14;
    }

    @Override
    protected String getFilterPlaceholder() {
        return "gui.xaero_filter_waypoints_by_name";
    }

    @Override
    protected ElementRenderer<? super Waypoint, ?, ?> getRenderer(Waypoint element) {
        return this.renderer;
    }

    @Override
    protected void beforeFiltering() {
    }

    @Override
    protected void beforeMenuRender() {
    }

    @Override
    protected void afterMenuRender() {
    }
}

