/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.highlight;

import java.util.List;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import xaero.map.highlight.ChunkHighlighter;

public class TestHighlighter
extends ChunkHighlighter {
    public TestHighlighter() {
        super(false);
    }

    @Override
    public boolean regionHasHighlights(RegistryKey<World> dimension, int regionX, int regionZ) {
        return true;
    }

    @Override
    protected int[] getColors(RegistryKey<World> dimension, int chunkX, int chunkZ) {
        if (!this.chunkIsHighlit(dimension, chunkX, chunkZ)) {
            return null;
        }
        int centerColor = 0x55FF5577;
        int sideColor = 0x55FF55CC;
        this.resultStore[0] = centerColor;
        this.resultStore[1] = (chunkZ & 3) == 0 ? sideColor : centerColor;
        this.resultStore[2] = (chunkX & 3) == 3 ? sideColor : centerColor;
        this.resultStore[3] = (chunkZ & 3) == 3 ? sideColor : centerColor;
        this.resultStore[4] = (chunkX & 3) == 0 ? sideColor : centerColor;
        return this.resultStore;
    }

    @Override
    public int calculateRegionHash(RegistryKey<World> dimension, int regionX, int regionZ) {
        return 51;
    }

    @Override
    public boolean chunkIsHighlit(RegistryKey<World> dimension, int chunkX, int chunkZ) {
        return (chunkX >> 2 & 1) == (chunkZ >> 2 & 1);
    }

    @Override
    public ITextComponent getChunkHighlightSubtleTooltip(RegistryKey<World> dimension, int chunkX, int chunkZ) {
        return new StringTextComponent("subtle!");
    }

    @Override
    public ITextComponent getChunkHighlightBluntTooltip(RegistryKey<World> dimension, int chunkX, int chunkZ) {
        return new StringTextComponent("blunt!");
    }

    @Override
    public void addMinimapBlockHighlightTooltips(List<ITextComponent> list, RegistryKey<World> dimension, int blockX, int blockZ, int width) {
        list.add((ITextComponent)new StringTextComponent("minimap tooltip!"));
    }
}

