/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.graphics.renderer.multitexture;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.function.IntConsumer;
import net.minecraft.client.renderer.RenderType;
import xaero.map.graphics.renderer.multitexture.MultiTextureRenderTypeRenderer;

public class MultiTextureRenderTypeRendererProvider {
    private Deque<MultiTextureRenderTypeRenderer> availableRenderers = new ArrayDeque<MultiTextureRenderTypeRenderer>();
    private HashSet<MultiTextureRenderTypeRenderer> usedRenderers;

    public MultiTextureRenderTypeRendererProvider(int rendererCount) {
        for (int i = 0; i < rendererCount; ++i) {
            this.availableRenderers.add(new MultiTextureRenderTypeRenderer());
        }
        this.usedRenderers = new HashSet();
    }

    public MultiTextureRenderTypeRenderer getRenderer(IntConsumer textureBinder, RenderType renderType) {
        return this.getRenderer(textureBinder, null, renderType);
    }

    public MultiTextureRenderTypeRenderer getRenderer(IntConsumer textureBinder, Runnable textureFinalizer, RenderType renderType) {
        if (this.availableRenderers.isEmpty()) {
            throw new RuntimeException("No renderers available!");
        }
        MultiTextureRenderTypeRenderer renderer = this.availableRenderers.removeFirst();
        renderer.init(textureBinder, textureFinalizer, renderType);
        this.usedRenderers.add(renderer);
        return renderer;
    }

    public void draw(MultiTextureRenderTypeRenderer renderer) {
        if (!this.usedRenderers.remove(renderer)) {
            throw new RuntimeException("The renderer requested for drawing was not provided by this provider!");
        }
        renderer.draw();
        this.availableRenderers.add(renderer);
    }

    public static void defaultTextureBind(int texture) {
        GlStateManager.func_227756_r_((int)33984);
        GlStateManager.func_227760_t_((int)texture);
    }
}

