/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.config.listener.handler;

import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import xaero.lib.client.config.listener.ClientConfigChangeListener;
import xaero.lib.common.config.Config;
import xaero.lib.common.config.option.ConfigOption;
import xaero.map.WorldMap;
import xaero.map.WorldMapSession;
import xaero.map.common.config.option.WorldMapProfiledConfigOptions;
import xaero.map.config.primary.option.WorldMapPrimaryClientConfigOptions;

public class WorldMapConfigOptionClientHandlers {
    private static void handleBlockColors(Config config) {
        WorldMap.settings.updateRegionCacheHashCode();
    }

    private static void handleTerrainDepth(Config config) {
        WorldMap.settings.updateRegionCacheHashCode();
    }

    private static void handleTerrainSlopes(Config config) {
        WorldMap.settings.updateRegionCacheHashCode();
    }

    private static void handleBiomeBlending(Config config) {
        WorldMap.settings.updateRegionCacheHashCode();
    }

    private static void handleBiomesInVanilla(Config config) {
        WorldMap.settings.updateRegionCacheHashCode();
    }

    private static void handleAdjustShortBlockHeight(Config config) {
        WorldMap.settings.updateRegionCacheHashCode();
    }

    private static void handleStainedGlass(Config config) {
        WorldMap.settings.updateRegionCacheHashCode();
    }

    private static void handleLegibleCaveMaps(Config config) {
        WorldMap.settings.updateRegionCacheHashCode();
    }

    private static void handleFlowers(Config config) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null || mc.f_91074_ == null) {
            return;
        }
        WorldMapSession session = WorldMapSession.getCurrentSession();
        if (session != null) {
            session.getMapProcessor().getMapWriter().setDirtyInWriteDistance((Player)mc.f_91074_, (Level)mc.f_91073_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clearAllCachedHighlightHashes() {
        WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
        if (worldmapSession == null) {
            return;
        }
        Object object = worldmapSession.getMapProcessor().uiSync;
        synchronized (object) {
            worldmapSession.getMapProcessor().getMapWorld().clearAllCachedHighlightHashes();
        }
    }

    private static void handleOpacClaims(Config config) {
        WorldMapConfigOptionClientHandlers.clearAllCachedHighlightHashes();
    }

    private static void handleOpacClaimFillOpacity(Config config) {
        WorldMapConfigOptionClientHandlers.clearAllCachedHighlightHashes();
    }

    private static void handleOpacClaimBorderOpacity(Config config) {
        WorldMapConfigOptionClientHandlers.clearAllCachedHighlightHashes();
    }

    private static void handleReloadViewed(Config config) {
        if (((Boolean)config.get((ConfigOption)WorldMapPrimaryClientConfigOptions.RELOAD_VIEWED)).booleanValue()) {
            config.set(WorldMapPrimaryClientConfigOptions.RELOAD_VIEWED_VERSION, (Object)((Integer)config.get(WorldMapPrimaryClientConfigOptions.RELOAD_VIEWED_VERSION) + 1));
        }
    }

    private static void handleMapItem(Config config) {
        WorldMapSession session = WorldMapSession.getCurrentSession();
        if (session != null) {
            session.getMapProcessor().updateMapItem();
        }
    }

    public static void registerAll(ClientConfigChangeListener registry) {
        registry.register((ConfigOption)WorldMapProfiledConfigOptions.BLOCK_COLORS, WorldMapConfigOptionClientHandlers::handleBlockColors);
        registry.register((ConfigOption)WorldMapProfiledConfigOptions.TERRAIN_DEPTH, WorldMapConfigOptionClientHandlers::handleTerrainDepth);
        registry.register((ConfigOption)WorldMapProfiledConfigOptions.TERRAIN_SLOPES, WorldMapConfigOptionClientHandlers::handleTerrainSlopes);
        registry.register((ConfigOption)WorldMapProfiledConfigOptions.BIOME_BLENDING, WorldMapConfigOptionClientHandlers::handleBiomeBlending);
        registry.register((ConfigOption)WorldMapProfiledConfigOptions.BIOME_COLORS_IN_VANILLA, WorldMapConfigOptionClientHandlers::handleBiomesInVanilla);
        registry.register((ConfigOption)WorldMapProfiledConfigOptions.ADJUST_HEIGHT_FOR_SHORT_BLOCKS, WorldMapConfigOptionClientHandlers::handleAdjustShortBlockHeight);
        registry.register((ConfigOption)WorldMapProfiledConfigOptions.STAINED_GLASS, WorldMapConfigOptionClientHandlers::handleStainedGlass);
        registry.register((ConfigOption)WorldMapProfiledConfigOptions.LEGIBLE_CAVE_MAPS, WorldMapConfigOptionClientHandlers::handleLegibleCaveMaps);
        registry.register((ConfigOption)WorldMapProfiledConfigOptions.FLOWERS, WorldMapConfigOptionClientHandlers::handleFlowers);
        registry.register((ConfigOption)WorldMapProfiledConfigOptions.OPAC_CLAIMS, WorldMapConfigOptionClientHandlers::handleOpacClaims);
        registry.register((ConfigOption)WorldMapProfiledConfigOptions.OPAC_CLAIMS_FILL_OPACITY, WorldMapConfigOptionClientHandlers::handleOpacClaimFillOpacity);
        registry.register((ConfigOption)WorldMapProfiledConfigOptions.OPAC_CLAIMS_BORDER_OPACITY, WorldMapConfigOptionClientHandlers::handleOpacClaimBorderOpacity);
        registry.register((ConfigOption)WorldMapPrimaryClientConfigOptions.RELOAD_VIEWED, WorldMapConfigOptionClientHandlers::handleReloadViewed);
        registry.register(WorldMapProfiledConfigOptions.MAP_ITEM, WorldMapConfigOptionClientHandlers::handleMapItem);
    }
}

