/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.region.texture;

import com.mojang.blaze3d.ProjectionType;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import xaero.map.exception.OpenGLException;
import xaero.map.graphics.ImprovedFramebuffer;
import xaero.map.graphics.MapRenderHelper;
import xaero.map.misc.Misc;

public class BranchTextureRenderer {
    private ImprovedFramebuffer renderFBO;
    private int glEmptyTexture;
    private PoseStack matrixStack = new PoseStack();
    private Matrix4f projectionMatrix = new Matrix4f().setOrtho(0.0f, 64.0f, 64.0f, 0.0f, -1.0f, 1.0f);

    public void render(int destTexture, Integer srcTextureTopLeft, Integer srcTextureTopRight, Integer srcTextureBottomLeft, Integer srcTextureBottomRight, RenderTarget defaultFramebuffer, boolean justAllocated) {
        if (this.renderFBO == null) {
            this.renderFBO = new ImprovedFramebuffer(64, 64, false);
            this.glEmptyTexture = this.renderFBO.getFramebufferTexture();
            this.renderFBO.bindAsMainTarget(true);
            GlStateManager._disableBlend();
            GlStateManager._clearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            GlStateManager._clear((int)16384);
            GlStateManager._enableBlend();
        }
        GlStateManager._bindTexture((int)0);
        this.renderFBO.bindAsMainTarget(true);
        this.renderFBO.setFramebufferTexture(destTexture);
        OpenGLException.checkGLError();
        Matrix4fStack shaderMatrixStack = RenderSystem.getModelViewStack();
        shaderMatrixStack.pushMatrix();
        shaderMatrixStack.identity();
        RenderSystem.setProjectionMatrix((Matrix4f)this.projectionMatrix, (ProjectionType)ProjectionType.ORTHOGRAPHIC);
        GlStateManager._disableBlend();
        if (justAllocated) {
            GlStateManager._clearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager._clear((int)16384);
        }
        boolean first = true;
        if (srcTextureTopLeft != null) {
            first = this.renderCorner(srcTextureTopLeft, 0, 0, first);
        }
        if (srcTextureTopRight != null) {
            first = this.renderCorner(srcTextureTopRight, 1, 0, first);
        }
        if (srcTextureBottomLeft != null) {
            first = this.renderCorner(srcTextureBottomLeft, 0, 1, first);
        }
        if (srcTextureBottomRight != null) {
            first = this.renderCorner(srcTextureBottomRight, 1, 1, first);
        }
        OpenGLException.checkGLError(false, "updating a map branch texture");
        GlStateManager._enableBlend();
        GlStateManager._glUseProgram((int)0);
        GlStateManager._bindTexture((int)0);
        shaderMatrixStack.popMatrix();
        Minecraft mc = Minecraft.getInstance();
        Misc.minecraftOrtho(mc, false);
        this.renderFBO.unbindWrite();
        this.renderFBO.bindDefaultFramebuffer(mc);
        GlStateManager._viewport((int)0, (int)0, (int)mc.getWindow().getWidth(), (int)mc.getWindow().getHeight());
        OpenGLException.checkGLError();
    }

    private boolean renderCorner(Integer srcTexture, int cornerX, int cornerY, boolean first) {
        int texture;
        int xOffset = cornerX * 32;
        int yOffset = (1 - cornerY) * 32;
        int n = texture = srcTexture != -1 ? srcTexture : this.glEmptyTexture;
        if (first) {
            RenderSystem.setShaderTexture((int)0, (int)texture);
        } else {
            GlStateManager._activeTexture((int)33984);
            GlStateManager._bindTexture((int)texture);
        }
        MapRenderHelper.renderBranchUpdate(xOffset, yOffset, 32.0f, 32.0f, 0, 64, 64.0f, -64.0f, 64.0f, 64.0f, first);
        return false;
    }
}

