/*
 * Decompiled with CFR 0.152.
 */
package xaero.map;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import xaero.map.MapWriter;
import xaero.map.biome.BiomeGetter;
import xaero.map.cache.BlockStateShortShapeCache;
import xaero.map.region.OverlayManager;

public class MapWriterForge
extends MapWriter {
    public MapWriterForge(OverlayManager overlayManager, BlockStateShortShapeCache blockStateShortShapeCache, BiomeGetter biomeGetter) {
        super(overlayManager, blockStateShortShapeCache, biomeGetter);
    }

    @Override
    protected boolean blockStateHasTranslucentRenderType(BlockState blockState) {
        BlockModelShaper bms = Minecraft.getInstance().getBlockRenderer().getBlockModelShaper();
        BlockStateModel model = bms.getBlockModel(blockState);
        if (model == null) {
            return true;
        }
        return model.getRenderTypes(blockState, this.usedRandom, ModelData.EMPTY).contains(RenderType.translucent());
    }

    @Override
    protected List<BakedQuad> getQuads(BlockStateModel model, Level level, BlockPos pos, BlockState state, Direction direction) {
        this.reusableBlockModelPartList.clear();
        model.collectParts(this.usedRandom, this.reusableBlockModelPartList, ModelData.EMPTY, null);
        if (this.reusableBlockModelPartList.isEmpty()) {
            return null;
        }
        return ((BlockModelPart)this.reusableBlockModelPartList.getFirst()).getQuads(direction);
    }

    @Override
    protected TextureAtlasSprite getParticleIcon(BlockModelShaper bms, BlockStateModel model, Level level, BlockPos pos, BlockState state) {
        return model.particleIcon(ModelData.EMPTY);
    }
}

