/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.radar.tracker;

import com.mojang.blaze3d.ProjectionType;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import xaero.lib.client.graphics.util.TextureUtils;
import xaero.map.graphics.ImprovedFramebuffer;
import xaero.map.icon.XaeroIcon;
import xaero.map.icon.XaeroIconAtlas;
import xaero.map.misc.Misc;
import xaero.map.radar.tracker.PlayerTrackerIconRenderer;
import xaero.map.radar.tracker.PlayerTrackerMapElement;

public class TrackedPlayerIconPrerenderer {
    private ImprovedFramebuffer renderFramebuffer;
    private XaeroIconAtlas lastAtlas;
    private final PlayerTrackerIconRenderer renderer = new PlayerTrackerIconRenderer();

    public void prerender(GuiGraphics guiGraphics, XaeroIcon icon, Player player, int iconWidth, ResourceLocation skinTextureLocation, PlayerTrackerMapElement<?> mapElement) {
        if (this.renderFramebuffer == null) {
            this.renderFramebuffer = new ImprovedFramebuffer(icon.getTextureAtlas().getWidth(), icon.getTextureAtlas().getWidth(), true);
            this.renderFramebuffer.getColorTexture().close();
            this.renderFramebuffer.setColorTexture(null);
        }
        guiGraphics.flush();
        this.renderFramebuffer.bindAsMainTarget(false);
        this.renderFramebuffer.setColorTexture(icon.getTextureAtlas().getTextureId());
        if (this.lastAtlas != icon.getTextureAtlas()) {
            TextureUtils.clearRenderTarget((RenderTarget)this.renderFramebuffer, (int)0, (float)1.0f);
            this.lastAtlas = icon.getTextureAtlas();
        }
        Matrix4f ortho = new Matrix4f().setOrtho(0.0f, (float)this.renderFramebuffer.viewWidth, (float)this.renderFramebuffer.viewHeight, 0.0f, -1.0f, 1000.0f);
        RenderSystem.setProjectionMatrix((Matrix4f)ortho, (ProjectionType)ProjectionType.ORTHOGRAPHIC);
        Matrix4fStack shaderMatrixStack = RenderSystem.getModelViewStack();
        shaderMatrixStack.pushMatrix();
        shaderMatrixStack.identity();
        PoseStack matrixStack = guiGraphics.pose();
        matrixStack.pushPose();
        matrixStack.setIdentity();
        matrixStack.translate((float)icon.getOffsetX(), (float)(this.renderFramebuffer.viewHeight - iconWidth - icon.getOffsetY()), 0.0f);
        matrixStack.translate((float)(iconWidth / 2), (float)(iconWidth / 2), 0.0f);
        matrixStack.scale(3.0f, 3.0f, 1.0f);
        guiGraphics.fill(-5, -5, 5, 5, -1);
        guiGraphics.flush();
        this.renderer.renderIcon(guiGraphics, player, skinTextureLocation);
        matrixStack.popPose();
        guiGraphics.flush();
        Minecraft mc = Minecraft.getInstance();
        Misc.minecraftOrtho(mc, false);
        shaderMatrixStack.popMatrix();
        this.renderFramebuffer.bindDefaultFramebuffer(mc);
    }
}

